/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerSmallBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KitchenRangeHoodBlock
extends HorizontalDirectionalBlock {
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final BooleanProperty DRAWER = BooleanProperty.create((String)"drawer");
    private static final List<FurnitureBlock> OVEN_RANGE_HOOD = new ArrayList<FurnitureBlock>();
    public static final MapCodec<KitchenRangeHoodBlock> CODEC = KitchenRangeHoodBlock.simpleCodec(KitchenRangeHoodBlock::new);
    protected static final VoxelShape RANGE_HOOD = Shapes.or((VoxelShape)KitchenRangeHoodBlock.box((double)2.0, (double)4.0, (double)0.0, (double)14.0, (double)16.0, (double)7.0), (VoxelShape)KitchenRangeHoodBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)15.0));
    protected static final VoxelShape RANGE_HOOD_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, RANGE_HOOD);
    protected static final VoxelShape RANGE_HOOD_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, RANGE_HOOD);
    protected static final VoxelShape RANGE_HOOD_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, RANGE_HOOD);
    protected static final VoxelShape RANGE_HOOD_BOTTOM_DRAWER = Shapes.or((VoxelShape)KitchenRangeHoodBlock.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)28.0, (double)7.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape RANGE_HOOD_BOTTOM_DRAWER_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, RANGE_HOOD_BOTTOM_DRAWER);
    protected static final VoxelShape RANGE_HOOD_BOTTOM_DRAWER_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, RANGE_HOOD_BOTTOM_DRAWER);
    protected static final VoxelShape RANGE_HOOD_BOTTOM_DRAWER_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, RANGE_HOOD_BOTTOM_DRAWER);
    protected static final VoxelShape RANGE_HOOD_BOTTOM = Shapes.or((VoxelShape)KitchenRangeHoodBlock.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)7.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape RANGE_HOOD_BOTTOM_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, RANGE_HOOD_BOTTOM);
    protected static final VoxelShape RANGE_HOOD_BOTTOM_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, RANGE_HOOD_BOTTOM);
    protected static final VoxelShape RANGE_HOOD_BOTTOM_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, RANGE_HOOD_BOTTOM);
    protected static final VoxelShape RANGE_HOOD_DRAWER = Shapes.or((VoxelShape)KitchenRangeHoodBlock.box((double)2.0, (double)16.0, (double)0.0, (double)14.0, (double)28.0, (double)7.0), (VoxelShape)KitchenRangeHoodBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0));
    protected static final VoxelShape RANGE_HOOD_DRAWER_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, RANGE_HOOD_DRAWER);
    protected static final VoxelShape RANGE_HOOD_DRAWER_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, RANGE_HOOD_DRAWER);
    protected static final VoxelShape RANGE_HOOD_DRAWER_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, RANGE_HOOD_DRAWER);

    public KitchenRangeHoodBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)DRAWER, (Comparable)Boolean.valueOf(false)));
        OVEN_RANGE_HOOD.add(new FurnitureBlock((Block)this, "oven_range_hood"));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static Stream<FurnitureBlock> streamOvenRangeHoods() {
        return OVEN_RANGE_HOOD.stream();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{DOWN});
        builder.add(new Property[]{DRAWER});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean down = ctx.getLevel().getBlockState(ctx.getClickedPos().below()).getBlock() instanceof KitchenRangeHoodBlock;
        boolean drawer = ctx.getLevel().getBlockState(ctx.getClickedPos().above()).getBlock() instanceof KitchenWallDrawerSmallBlock;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)DOWN, (Comparable)Boolean.valueOf(down))).setValue((Property)DRAWER, (Comparable)Boolean.valueOf(drawer));
    }

    public FluidState getFluidState(BlockState state) {
        return super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction.getAxis().isVertical()) {
            boolean down = world.getBlockState(pos.below()).getBlock() instanceof KitchenRangeHoodBlock;
            boolean drawer = world.getBlockState(pos.above()).getBlock() instanceof KitchenWallDrawerSmallBlock;
            return (BlockState)((BlockState)state.setValue((Property)DOWN, (Comparable)Boolean.valueOf(down))).setValue((Property)DRAWER, (Comparable)Boolean.valueOf(drawer));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean down = (Boolean)state.getValue((Property)DOWN);
        boolean drawer = (Boolean)state.getValue((Property)DRAWER);
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (down && drawer) {
            return switch (direction) {
                case Direction.NORTH -> RANGE_HOOD_BOTTOM_DRAWER;
                case Direction.SOUTH -> RANGE_HOOD_BOTTOM_DRAWER_SOUTH;
                case Direction.EAST -> RANGE_HOOD_BOTTOM_DRAWER_EAST;
                default -> RANGE_HOOD_BOTTOM_DRAWER_WEST;
            };
        }
        if (down) {
            return switch (direction) {
                case Direction.NORTH -> RANGE_HOOD_BOTTOM;
                case Direction.SOUTH -> RANGE_HOOD_BOTTOM_SOUTH;
                case Direction.EAST -> RANGE_HOOD_BOTTOM_EAST;
                default -> RANGE_HOOD_BOTTOM_WEST;
            };
        }
        if (drawer) {
            return switch (direction) {
                case Direction.NORTH -> RANGE_HOOD_DRAWER;
                case Direction.SOUTH -> RANGE_HOOD_DRAWER_SOUTH;
                case Direction.EAST -> RANGE_HOOD_DRAWER_EAST;
                default -> RANGE_HOOD_DRAWER_WEST;
            };
        }
        return switch (direction) {
            case Direction.NORTH -> RANGE_HOOD;
            case Direction.SOUTH -> RANGE_HOOD_SOUTH;
            case Direction.EAST -> RANGE_HOOD_EAST;
            default -> RANGE_HOOD_WEST;
        };
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

