/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWithEntity;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterOvenBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.blockentities.StovetopBlockEntity;
import com.unlikepaladin.pfm.blocks.neoforge.KitchenStovetopBlockImpl;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.Statistics;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KitchenStovetopBlock
extends HorizontalFacingBlockWithEntity {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private static final List<KitchenStovetopBlock> KITCHEN_STOVETOPS = new ArrayList<KitchenStovetopBlock>();
    public static final MapCodec<KitchenStovetopBlock> CODEC = KitchenStovetopBlock.simpleCodec(KitchenStovetopBlock::new);
    protected static final VoxelShape STOVETOP = Shapes.or((VoxelShape)KitchenStovetopBlock.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape STOVETOP_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, STOVETOP);
    protected static final VoxelShape STOVETOP_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, STOVETOP);
    protected static final VoxelShape STOVETOP_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, STOVETOP);

    public KitchenStovetopBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
        KITCHEN_STOVETOPS.add(this);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public static Stream<KitchenStovetopBlock> streamKitchenStovetop() {
        return KITCHEN_STOVETOPS.stream();
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Block neighborBlock = world.getBlockState(pos.below()).getBlock();
        return neighborBlock instanceof KitchenCounterOvenBlock || neighborBlock instanceof KitchenCounterBlock;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        StovetopBlockEntity stovetopBlockEntity;
        Optional<RecipeHolder<CampfireCookingRecipe>> optional;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof StovetopBlockEntity && (optional = (stovetopBlockEntity = (StovetopBlockEntity)blockEntity).getRecipeFor(itemStack)).isPresent()) {
            if (!world.isClientSide && stovetopBlockEntity.addItem(player.getAbilities().instabuild ? itemStack.copy() : itemStack, ((CampfireCookingRecipe)optional.get().value()).getCookingTime())) {
                player.awardStat(Statistics.STOVETOP_USED);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.CONSUME;
        }
        return super.useItemOn(itemStack, state, world, pos, player, hand, hit);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof StovetopBlockEntity) {
            StovetopBlockEntity stovetopBlockEntity = (StovetopBlockEntity)blockEntity;
            for (int i = 0; i < stovetopBlockEntity.getItemsBeingCooked().size(); ++i) {
                ItemStack stack = (ItemStack)stovetopBlockEntity.getItemsBeingCooked().get(i);
                if (stack.isEmpty() || !world.getRecipeManager().getRecipeFor(RecipeType.CAMPFIRE_COOKING, (RecipeInput)new SingleRecipeInput(stack), world).isEmpty()) continue;
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, stovetopBlockEntity.removeStack(i));
                world.addFreshEntity((Entity)itemEntity);
                player.awardStat(Statistics.STOVETOP_USED);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !this.canSurvive(state, (LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        return switch (dir) {
            case Direction.WEST -> STOVETOP_EAST;
            case Direction.NORTH -> STOVETOP_SOUTH;
            case Direction.SOUTH -> STOVETOP;
            default -> STOVETOP_WEST;
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return KitchenStovetopBlock.getBlockEntity(pos, state);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntity getBlockEntity(BlockPos pos, BlockState state) {
        void var1_1;
        return KitchenStovetopBlockImpl.getBlockEntity(pos, (BlockState)var1_1);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        if (world.isClientSide) {
            if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                return BasicToiletBlock.checkType(type, BlockEntities.STOVE_TOP_BLOCK_ENTITY, StovetopBlockEntity::clientTick);
            }
        } else {
            if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                return BasicToiletBlock.checkType(type, BlockEntities.STOVE_TOP_BLOCK_ENTITY, StovetopBlockEntity::litServerTick);
            }
            return BasicToiletBlock.checkType(type, BlockEntities.STOVE_TOP_BLOCK_ENTITY, StovetopBlockEntity::unlitServerTick);
        }
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof StovetopBlockEntity) {
            StovetopBlockEntity stovetopBlockEntity = (StovetopBlockEntity)blockEntity;
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)stovetopBlockEntity.getInventory());
            world.updateNeighbourForOutputSignal(pos, (Block)this);
            stovetopBlockEntity.setRemoved();
        }
        super.onRemove(state, world, pos, newState, moved);
    }
}

