/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KitchenWallCounterBlock
extends KitchenCounterBlock {
    private static final List<FurnitureBlock> WOOD_COUNTERS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_COUNTERS = new ArrayList<FurnitureBlock>();

    public KitchenWallCounterBlock(BlockBehaviour.Properties settings) {
        super(settings);
        if (AbstractSittableBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(KitchenWallCounterBlock.class)) {
            WOOD_COUNTERS.add(new FurnitureBlock((Block)this, "kitchen_wall_counter"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(KitchenWallCounterBlock.class)) {
            STONE_COUNTERS.add(new FurnitureBlock((Block)this, "kitchen_wall_counter"));
        }
    }

    public static Stream<FurnitureBlock> streamWallWoodCounters() {
        return WOOD_COUNTERS.stream();
    }

    public static Stream<FurnitureBlock> streamWallStoneCounters() {
        return STONE_COUNTERS.stream();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)KitchenCounterBlock.FACING);
        BlockState neighborStateFacing = view.getBlockState(pos.relative(direction));
        BlockState neighborStateOpposite = view.getBlockState(pos.relative(direction.getOpposite()));
        if (this.canConnectToCounter(neighborStateFacing) && neighborStateFacing.getProperties().contains(BlockStateProperties.HORIZONTAL_FACING)) {
            Direction direction2 = (Direction)neighborStateFacing.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (direction2.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() && this.isDifferentOrientation(state, view, pos, direction2.getOpposite())) {
                if (direction2 == direction.getCounterClockWise()) {
                    switch (direction) {
                        case NORTH: {
                            return OUTER_MIDDLE;
                        }
                        case SOUTH: {
                            return OUTER_MIDDLE_SOUTH;
                        }
                        case EAST: {
                            return OUTER_MIDDLE_EAST;
                        }
                    }
                    return OUTER_MIDDLE_WEST;
                }
                switch (direction) {
                    case NORTH: {
                        return OUTER_MIDDLE_EAST;
                    }
                    case SOUTH: {
                        return OUTER_MIDDLE_WEST;
                    }
                    case EAST: {
                        return OUTER_MIDDLE_SOUTH;
                    }
                }
                return OUTER_MIDDLE;
            }
            switch (direction) {
                case NORTH: {
                    return MIDDLE;
                }
                case SOUTH: {
                    return MIDDLE_SOUTH;
                }
                case EAST: {
                    return MIDDLE_EAST;
                }
            }
            return MIDDLE_WEST;
        }
        if (this.canConnectToCounter(neighborStateOpposite) && neighborStateOpposite.getProperties().contains(BlockStateProperties.HORIZONTAL_FACING)) {
            Direction direction3 = neighborStateOpposite.getBlock() instanceof AbstractFurnaceBlock ? ((Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite() : (Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (direction3.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() && this.isDifferentOrientation(state, view, pos, direction3)) {
                if (direction3 == direction.getCounterClockWise()) {
                    switch (direction) {
                        case NORTH: {
                            return INNER_MIDDLE_WEST;
                        }
                        case SOUTH: {
                            return INNER_MIDDLE_EAST;
                        }
                        case EAST: {
                            return INNER_MIDDLE;
                        }
                    }
                    return INNER_MIDDLE_SOUTH;
                }
                switch (direction) {
                    case NORTH: {
                        return INNER_MIDDLE;
                    }
                    case SOUTH: {
                        return INNER_MIDDLE_SOUTH;
                    }
                    case EAST: {
                        return INNER_MIDDLE_EAST;
                    }
                }
                return INNER_MIDDLE_WEST;
            }
            switch (direction) {
                case NORTH: {
                    return MIDDLE;
                }
                case SOUTH: {
                    return MIDDLE_SOUTH;
                }
                case EAST: {
                    return MIDDLE_EAST;
                }
            }
            return MIDDLE_WEST;
        }
        switch (direction) {
            case NORTH: {
                return MIDDLE;
            }
            case SOUTH: {
                return MIDDLE_SOUTH;
            }
            case EAST: {
                return MIDDLE_EAST;
            }
        }
        return MIDDLE_WEST;
    }
}

