/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerBlock;
import com.unlikepaladin.pfm.blocks.blockentities.GenericStorageBlockEntity3x3;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KitchenWallDrawerSmallBlock
extends KitchenWallDrawerBlock {
    private static final List<FurnitureBlock> WOOD_SMALL_WALL_DRAWERS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_SMALL_WALL_DRAWERS = new ArrayList<FurnitureBlock>();
    protected static final VoxelShape SMALL_DRAWER = Shapes.or((VoxelShape)KitchenWallDrawerSmallBlock.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{KitchenWallDrawerSmallBlock.box((double)9.0, (double)9.0, (double)14.0, (double)10.0, (double)12.0, (double)15.0), KitchenWallDrawerSmallBlock.box((double)6.0, (double)9.0, (double)14.0, (double)7.0, (double)12.0, (double)15.0), KitchenWallDrawerSmallBlock.box((double)1.0, (double)7.0, (double)13.0, (double)15.0, (double)15.0, (double)14.0)});
    protected static final VoxelShape SMALL_DRAWER_SOUTH = KitchenWallDrawerSmallBlock.rotateShape(Direction.NORTH, Direction.SOUTH, SMALL_DRAWER);
    protected static final VoxelShape SMALL_DRAWER_EAST = KitchenWallDrawerSmallBlock.rotateShape(Direction.NORTH, Direction.EAST, SMALL_DRAWER);
    protected static final VoxelShape SMALL_DRAWER_WEST = KitchenWallDrawerSmallBlock.rotateShape(Direction.NORTH, Direction.WEST, SMALL_DRAWER);
    protected static final VoxelShape SMALL_DRAWER_OPEN = Shapes.or((VoxelShape)KitchenWallDrawerSmallBlock.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{KitchenWallDrawerSmallBlock.box((double)0.0, (double)7.0, (double)13.0, (double)1.0, (double)15.0, (double)20.0), KitchenWallDrawerSmallBlock.box((double)-1.0, (double)9.0, (double)18.0, (double)0.0, (double)12.0, (double)19.0), KitchenWallDrawerSmallBlock.box((double)15.0, (double)7.0, (double)13.0, (double)16.0, (double)15.0, (double)20.0), KitchenWallDrawerSmallBlock.box((double)16.0, (double)9.0, (double)18.0, (double)17.0, (double)12.0, (double)19.0)});
    protected static final VoxelShape SMALL_DRAWER_OPEN_SOUTH = KitchenWallDrawerSmallBlock.rotateShape(Direction.NORTH, Direction.SOUTH, SMALL_DRAWER_OPEN);
    protected static final VoxelShape SMALL_DRAWER_OPEN_EAST = KitchenWallDrawerSmallBlock.rotateShape(Direction.NORTH, Direction.EAST, SMALL_DRAWER_OPEN);
    protected static final VoxelShape SMALL_DRAWER_OPEN_WEST = KitchenWallDrawerSmallBlock.rotateShape(Direction.NORTH, Direction.WEST, SMALL_DRAWER_OPEN);

    public KitchenWallDrawerSmallBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        if (AbstractSittableBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(KitchenWallDrawerSmallBlock.class)) {
            WOOD_SMALL_WALL_DRAWERS.add(new FurnitureBlock((Block)this, "kitchen_wall_small_drawer"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(KitchenWallDrawerSmallBlock.class)) {
            STONE_SMALL_WALL_DRAWERS.add(new FurnitureBlock((Block)this, "kitchen_wall_small_drawer"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodWallSmallDrawers() {
        return WOOD_SMALL_WALL_DRAWERS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneWallSmallDrawers() {
        return STONE_SMALL_WALL_DRAWERS.stream();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        boolean open = (Boolean)state.getValue((Property)OPEN);
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (open) {
            return switch (direction) {
                case Direction.NORTH -> SMALL_DRAWER_OPEN;
                case Direction.SOUTH -> SMALL_DRAWER_OPEN_SOUTH;
                case Direction.WEST -> SMALL_DRAWER_OPEN_WEST;
                default -> SMALL_DRAWER_OPEN_EAST;
            };
        }
        return switch (direction) {
            case Direction.NORTH -> SMALL_DRAWER;
            case Direction.SOUTH -> SMALL_DRAWER_SOUTH;
            case Direction.WEST -> SMALL_DRAWER_WEST;
            default -> SMALL_DRAWER_EAST;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{FACING});
        stateManager.add(new Property[]{OPEN});
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return state;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return GenericStorageBlockEntity3x3.getFactory().create(pos, state);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof GenericStorageBlockEntity3x3) {
            player.openMenu((MenuProvider)((GenericStorageBlockEntity3x3)blockEntity));
            player.awardStat(Statistics.DRAWER_SEARCHED);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }
}

