/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.BasicChairBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LogStoolBlock
extends BasicChairBlock {
    private static final List<FurnitureBlock> WOOD_LOG_STOOLS = new ArrayList<FurnitureBlock>();
    protected static final VoxelShape COLLISION = Shapes.or((VoxelShape)LogStoolBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape FACE_NORTH_TUCKED = LogStoolBlock.tuckShape(Direction.NORTH, COLLISION);
    protected static final VoxelShape FACE_SOUTH_TUCKED = LogStoolBlock.tuckShape(Direction.SOUTH, COLLISION);
    protected static final VoxelShape FACE_EAST_TUCKED = LogStoolBlock.tuckShape(Direction.EAST, COLLISION);
    protected static final VoxelShape FACE_WEST_TUCKED = LogStoolBlock.tuckShape(Direction.WEST, COLLISION);

    public LogStoolBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
        if (AbstractSittableBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(LogStoolBlock.class)) {
            WOOD_LOG_STOOLS.add(new FurnitureBlock((Block)this, "_stool"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodLogStools() {
        return WOOD_LOG_STOOLS.stream();
    }

    @Override
    public boolean canTuck(BlockState state) {
        return super.canTuck(state) || state.getBlock() instanceof KitchenCounterBlock;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        if (((Boolean)state.getValue((Property)TUCKED)).booleanValue()) {
            return switch (dir) {
                case Direction.WEST -> FACE_WEST_TUCKED;
                case Direction.NORTH -> FACE_NORTH_TUCKED;
                case Direction.SOUTH -> FACE_SOUTH_TUCKED;
                default -> FACE_EAST_TUCKED;
            };
        }
        return COLLISION;
    }
}

