/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.SimpleStoolBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MirrorBlock
extends HorizontalDirectionalBlock {
    protected static List<FurnitureBlock> mirrorBlockList = new ArrayList<FurnitureBlock>();
    public static final MapCodec<MirrorBlock> CODEC = MirrorBlock.simpleCodec(MirrorBlock::new);
    protected static final VoxelShape MIRROR_NORTH = Shapes.or((VoxelShape)MirrorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape MIRROR_SOUTH = SimpleStoolBlock.rotateShape(Direction.NORTH, Direction.SOUTH, MIRROR_NORTH);
    protected static final VoxelShape MIRROR_EAST = SimpleStoolBlock.rotateShape(Direction.NORTH, Direction.EAST, MIRROR_NORTH);
    protected static final VoxelShape MIRROR_WEST = SimpleStoolBlock.rotateShape(Direction.NORTH, Direction.WEST, MIRROR_NORTH);

    public MirrorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        mirrorBlockList.add(new FurnitureBlock((Block)this, "mirror"));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static Stream<FurnitureBlock> streamMirrorBlocks() {
        return mirrorBlockList.stream();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockPos = pos.relative(direction);
        BlockState blockState = world.getBlockState(blockPos);
        return blockState.isFaceSturdy((BlockGetter)world, blockPos, direction.getOpposite());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == state.getValue((Property)FACING) && !state.canSurvive((LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public boolean canConnect(BlockState neighborState, BlockState state) {
        return PaladinFurnitureMod.getPFMConfig().doDifferentMirrorsConnect() ? neighborState.getBlock() instanceof MirrorBlock && neighborState.getValue((Property)FACING) == state.getValue((Property)FACING) : neighborState.getBlock() == state.getBlock() && neighborState.getValue((Property)FACING) == state.getValue((Property)FACING);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch (direction) {
            case SOUTH: {
                return MIRROR_SOUTH;
            }
            case EAST: {
                return MIRROR_EAST;
            }
            case WEST: {
                return MIRROR_WEST;
            }
        }
        return MIRROR_NORTH;
    }
}

