/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWithEntity;
import com.unlikepaladin.pfm.blocks.LogTableBlock;
import com.unlikepaladin.pfm.blocks.blockentities.PFMToasterBlockEntity;
import com.unlikepaladin.pfm.blocks.neoforge.PFMToasterBlockImpl;
import com.unlikepaladin.pfm.registry.BlockEntities;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PFMToasterBlock
extends HorizontalFacingBlockWithEntity {
    public static final BooleanProperty ON = BooleanProperty.create((String)"on");
    public static final MapCodec<PFMToasterBlock> CODEC = PFMToasterBlock.simpleCodec(PFMToasterBlock::new);
    public static final VoxelShape IRON_TOASTER = Shapes.or((VoxelShape)PFMToasterBlock.box((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)7.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);
    public static final VoxelShape IRON_TOASTER_WEST_EAST = LogTableBlock.rotateShape(Direction.NORTH, Direction.WEST, IRON_TOASTER);

    public PFMToasterBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{FACING, ON});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ctx) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        return switch (dir) {
            case Direction.EAST, Direction.WEST -> IRON_TOASTER_WEST_EAST;
            default -> IRON_TOASTER;
        };
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return PFMToasterBlockEntity.getFactory().create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return BasicToiletBlock.checkType(type, BlockEntities.TOASTER_BLOCK_ENTITY, PFMToasterBlockEntity::tick);
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return world.getBlockEntity(pos) instanceof PFMToasterBlockEntity ? ((PFMToasterBlockEntity)world.getBlockEntity(pos)).getComparatorOutput() : 0;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighborPos, boolean moved) {
        super.neighborChanged(state, world, pos, block, neighborPos, moved);
        if (world.getBlockEntity(pos) instanceof PFMToasterBlockEntity) {
            boolean toasting = ((PFMToasterBlockEntity)world.getBlockEntity(pos)).isToasting();
            world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue((Property)ON, (Comparable)Boolean.valueOf(toasting)));
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (world.getBlockEntity(pos) instanceof PFMToasterBlockEntity) {
            boolean toasting = ((PFMToasterBlockEntity)world.getBlockEntity(pos)).isToasting();
            world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue((Property)ON, (Comparable)Boolean.valueOf(toasting)));
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity be = world.getBlockEntity(pos);
            if (be instanceof PFMToasterBlockEntity) {
                PFMToasterBlockEntity blockEntity = (PFMToasterBlockEntity)world.getBlockEntity(pos);
                for (int i = 0; i < 2; ++i) {
                    ItemEntity item = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (ItemStack)blockEntity.getItems().get(i));
                    world.addFreshEntity((Entity)item);
                }
                world.blockUpdated(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.getBlockEntity(pos) instanceof PFMToasterBlockEntity) {
            PFMToasterBlockEntity blockEntity = (PFMToasterBlockEntity)world.getBlockEntity(pos);
            if (!player.isShiftKeyDown()) {
                if (!blockEntity.isToasting()) {
                    if (!stack.isEmpty() && !PFMToasterBlock.isSandwich(stack)) {
                        if (!blockEntity.addItem(hand, player)) {
                            ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, blockEntity.takeItem(player));
                            world.addFreshEntity((Entity)itemEntity);
                        }
                    } else {
                        ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, blockEntity.takeItem(player));
                        world.addFreshEntity((Entity)itemEntity);
                    }
                }
                PFMToasterBlockEntity.sync(blockEntity, blockEntity.getLevel());
            } else if (!blockEntity.isToasting()) {
                blockEntity.startToasting(player);
            } else {
                blockEntity.stopToasting(player);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isSandwich(ItemStack stack) {
        return PFMToasterBlockImpl.isSandwich(stack);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }
}

