/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.DynamicRenderLayerInterface;
import com.unlikepaladin.pfm.blocks.PowerableBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class PendantBlock
extends PowerableBlock
implements DynamicRenderLayerInterface {
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;
    private final BlockState baseBlockState;
    private final Block baseBlock;
    private static final List<PendantBlock> PENDANTS = new ArrayList<PendantBlock>();
    public static final MapCodec<PendantBlock> CODEC = PendantBlock.simpleCodec(PendantBlock::new);
    private static final VoxelShape single = Shapes.or((VoxelShape)PendantBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0), (VoxelShape[])new VoxelShape[]{PendantBlock.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), PendantBlock.box((double)7.5, (double)9.0, (double)7.5, (double)8.5, (double)15.5, (double)8.5), PendantBlock.box((double)6.5, (double)15.5, (double)6.5, (double)9.5, (double)16.0, (double)9.5)});
    private static final VoxelShape up = Shapes.or((VoxelShape)PendantBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0), (VoxelShape[])new VoxelShape[]{PendantBlock.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), PendantBlock.box((double)7.5, (double)9.0, (double)7.5, (double)8.5, (double)16.0, (double)8.5)});
    private static final VoxelShape middle = PendantBlock.box((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)16.0, (double)8.5);
    private static final VoxelShape down = Shapes.or((VoxelShape)PendantBlock.box((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)15.5, (double)8.5), (VoxelShape)PendantBlock.box((double)6.5, (double)15.5, (double)6.5, (double)9.5, (double)16.0, (double)9.5));

    public PendantBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERLOCKED, (Comparable)Boolean.valueOf(false)));
        this.baseBlockState = this.defaultBlockState();
        this.baseBlock = this.baseBlockState.getBlock();
        PENDANTS.add(this);
    }

    protected MapCodec<? extends PowerableBlock> codec() {
        return CODEC;
    }

    public static Stream<PendantBlock> streamPendantLights() {
        return PENDANTS.stream();
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    @Override
    public void setPowered(Level world, BlockPos lightPos, boolean powered) {
        BlockState state = world.getBlockState(lightPos);
        world.setBlockAndUpdate(lightPos, (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(powered))).setValue((Property)POWERLOCKED, (Comparable)Boolean.valueOf(powered)));
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public static BlockState canConnect(BlockState state, LevelAccessor world, BlockPos pos) {
        boolean up = world.getBlockState(pos.above()).getBlock() instanceof PendantBlock;
        boolean down = world.getBlockState(pos.below()).getBlock() instanceof PendantBlock;
        if (up) {
            return (BlockState)((BlockState)((BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(true))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(down))).setValue((Property)LIT, (Comparable)((Boolean)world.getBlockState(pos.above()).getValue((Property)LIT)));
        }
        return (BlockState)((BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return direction.getAxis().isVertical() ? PendantBlock.canConnect(state, world, pos) : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        return super.getFluidState(state);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.is(state.getBlock())) {
            oldState.handleNeighborChanged(world, pos, Blocks.AIR, pos, false);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)UP)).booleanValue() && ((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            return middle;
        }
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            return up;
        }
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            return down;
        }
        return single;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean powered = ctx.getLevel().hasNeighborSignal(ctx.getClickedPos());
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(powered));
        return PendantBlock.canConnect(state, (LevelAccessor)ctx.getLevel(), ctx.getClickedPos());
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (world.isClientSide) {
            return;
        }
        if (world.getBlockState(pos.above()).getBlock() instanceof PendantBlock) {
            return;
        }
        boolean bl = (Boolean)state.getValue((Property)LIT);
        if (bl != world.hasNeighborSignal(pos)) {
            if (bl) {
                world.scheduleTick(pos, (Block)this, 4);
            } else {
                world.setBlock(pos, (BlockState)state.cycle((Property)LIT), 2);
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = Direction.UP;
        return Block.canSupportCenter((LevelReader)world, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite()) || world.getBlockState(pos.relative(direction)).getBlock() instanceof PendantBlock;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && !world.hasNeighborSignal(pos) && !((Boolean)state.getValue((Property)POWERLOCKED)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.cycle((Property)LIT), 2);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP});
        builder.add(new Property[]{DOWN});
        builder.add(new Property[]{LIT});
        builder.add(new Property[]{POWERLOCKED});
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getCustomRenderLayer() {
        return RenderType.translucent();
    }
}

