/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.blocks.LogTableBlock;
import com.unlikepaladin.pfm.blocks.blockentities.PFMBedBlockEntity;
import com.unlikepaladin.pfm.client.PFMBuiltinItemRendererExtension;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SimpleBedBlock
extends BedBlock
implements DyeableFurnitureBlock,
PFMBuiltinItemRendererExtension {
    private static final List<FurnitureBlock> SIMPLE_BEDS = new ArrayList<FurnitureBlock>();
    private final DyeColor color;
    static final VoxelShape HEAD = Shapes.or((VoxelShape)SimpleBedBlock.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)14.0, (double)3.0), (VoxelShape)SimpleBedBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0));
    static final VoxelShape HEAD_SOUTH = LogTableBlock.rotateShape(Direction.NORTH, Direction.SOUTH, HEAD);
    static final VoxelShape HEAD_EAST = LogTableBlock.rotateShape(Direction.NORTH, Direction.EAST, HEAD);
    static final VoxelShape HEAD_WEST = LogTableBlock.rotateShape(Direction.NORTH, Direction.WEST, HEAD);
    static final VoxelShape FOOT_EAST = Shapes.or((VoxelShape)SimpleBedBlock.box((double)0.0, (double)9.0, (double)0.0, (double)3.0, (double)10.0, (double)16.0), (VoxelShape)SimpleBedBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0));
    static final VoxelShape FOOT_SOUTH = LogTableBlock.rotateShape(Direction.EAST, Direction.SOUTH, FOOT_EAST);
    static final VoxelShape FOOT_WEST = LogTableBlock.rotateShape(Direction.EAST, Direction.WEST, FOOT_EAST);
    static final VoxelShape FOOT_NORTH = LogTableBlock.rotateShape(Direction.EAST, Direction.NORTH, FOOT_EAST);

    public SimpleBedBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(color, settings.lightLevel(state -> 0).emissiveRendering((blockstate, b, c) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)PART, (Comparable)BedPart.FOOT)).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
        if (this.getClass().isAssignableFrom(SimpleBedBlock.class)) {
            String bedColor = color.getName();
            SIMPLE_BEDS.add(new FurnitureBlock((Block)this, bedColor + "_simple_bed"));
        }
        this.color = color;
    }

    public static Stream<FurnitureBlock> streamSimpleBeds() {
        return SIMPLE_BEDS.stream();
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
        Direction direction = ctx.getHorizontalDirection();
        BlockPos blockPos = ctx.getClickedPos();
        BlockPos blockPos2 = blockPos.relative(direction);
        if (ctx.getLevel().getBlockState(blockPos2).canBeReplaced(ctx)) {
            return blockState;
        }
        return null;
    }

    private static Direction getDirectionTowardsOtherPart(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.getOpposite();
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (state.getValue((Property)PART) != BedPart.HEAD && !((state = world.getBlockState(pos = pos.relative((Direction)state.getValue((Property)FACING)))).getBlock() instanceof SimpleBedBlock)) {
            return InteractionResult.CONSUME;
        }
        if (!BedBlock.canSetSpawn((Level)world)) {
            world.removeBlock(pos, false);
            BlockPos blockPos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
            if (world.getBlockState(blockPos).is((Block)this)) {
                world.removeBlock(blockPos, false);
            }
            world.explode(null, world.damageSources().badRespawnPointExplosion(pos.getCenter()), null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)OCCUPIED)).booleanValue()) {
            if (!this.isFree(world, pos)) {
                player.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        player.startSleepInBed(pos).ifLeft(reason -> {
            if (reason.getMessage() != null) {
                player.displayClientMessage(reason.getMessage(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    private boolean isFree(Level world, BlockPos pos) {
        List list = world.getEntitiesOfClass(Villager.class, new AABB(pos), LivingEntity::isSleeping);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).stopSleeping();
        return true;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == SimpleBedBlock.getDirectionTowardsOtherPart((BedPart)state.getValue((Property)PART), (Direction)state.getValue((Property)FACING))) {
            if (neighborState.getBlock() instanceof SimpleBedBlock && neighborState.getValue((Property)PART) != state.getValue((Property)PART)) {
                return (BlockState)state.setValue((Property)OCCUPIED, (Comparable)((Boolean)neighborState.getValue((Property)OCCUPIED)));
            }
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        BedPart bedPart;
        if (!world.isClientSide && player.isCreative() && (bedPart = (BedPart)state.getValue((Property)PART)) == BedPart.FOOT && (blockState = world.getBlockState(blockPos = pos.relative(SimpleBedBlock.getDirectionTowardsOtherPart(bedPart, (Direction)state.getValue((Property)FACING))))).is((Block)this) && blockState.getValue((Property)PART) == BedPart.HEAD) {
            world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 35);
            world.levelEvent(player, 2001, blockPos, Block.getId((BlockState)blockState));
        }
        this.spawnDestroyParticles(world, player, pos, state);
        if (state.is(BlockTags.GUARDED_BY_PIGLINS)) {
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)false);
        }
        world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        return super.playerWillDestroy(world, pos, state, player);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.createBlockStateDefinition(stateManager);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    public FluidState getFluidState(BlockState state) {
        return super.getFluidState(state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SimpleBedBlock.getBedShape((Direction)state.getValue((Property)FACING), (BedPart)state.getValue((Property)PART), HEAD, FOOT_NORTH, HEAD_EAST, FOOT_EAST, HEAD_WEST, FOOT_WEST, HEAD_SOUTH, FOOT_SOUTH);
    }

    static VoxelShape getBedShape(Direction direction, BedPart bedPart2, VoxelShape head, VoxelShape footNorth, VoxelShape headEast, VoxelShape footEast, VoxelShape headWest, VoxelShape footWest, VoxelShape headSouth, VoxelShape footSouth) {
        switch (direction) {
            case NORTH: {
                if (bedPart2 == BedPart.HEAD) {
                    return head;
                }
                return footNorth;
            }
            case EAST: {
                if (bedPart2 == BedPart.HEAD) {
                    return headEast;
                }
                return footEast;
            }
            case WEST: {
                if (bedPart2 == BedPart.HEAD) {
                    return headWest;
                }
                return footWest;
            }
        }
        if (bedPart2 == BedPart.HEAD) {
            return headSouth;
        }
        return footSouth;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Override
    public DyeColor getPFMColor() {
        return this.color;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PFMBedBlockEntity(pos, state, this.color);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

