/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.PowerableBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SimpleLightBlock
extends PowerableBlock {
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;
    private static final List<SimpleLightBlock> SIMPLE_LIGHTS = new ArrayList<SimpleLightBlock>();
    public static final MapCodec<SimpleLightBlock> CODEC = SimpleLightBlock.simpleCodec(SimpleLightBlock::new);
    private static final VoxelShape SIMPLE_LIGHT = Shapes.or((VoxelShape)SimpleLightBlock.box((double)4.5, (double)13.5, (double)4.5, (double)11.5, (double)14.5, (double)11.5), (VoxelShape)SimpleLightBlock.box((double)3.0, (double)14.5, (double)3.0, (double)13.0, (double)16.0, (double)13.0));

    public SimpleLightBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERLOCKED, (Comparable)Boolean.valueOf(false)));
        SIMPLE_LIGHTS.add(this);
    }

    protected MapCodec<? extends PowerableBlock> codec() {
        return CODEC;
    }

    @Override
    public void setPowered(Level world, BlockPos lightPos, boolean powered) {
        BlockState state = world.getBlockState(lightPos);
        world.setBlockAndUpdate(lightPos, (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(powered))).setValue((Property)POWERLOCKED, (Comparable)Boolean.valueOf(powered)));
    }

    public static Stream<SimpleLightBlock> streamSimpleLights() {
        return SIMPLE_LIGHTS.stream();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean powered = ctx.getLevel().hasNeighborSignal(ctx.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(powered));
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && !world.hasNeighborSignal(pos) && !((Boolean)state.getValue((Property)POWERLOCKED)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.cycle((Property)LIT), 3);
        }
    }

    public FluidState getFluidState(BlockState state) {
        return super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
        builder.add(new Property[]{POWERLOCKED});
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = Direction.UP;
        return SimpleLightBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (world.isClientSide) {
            return;
        }
        boolean bl = (Boolean)state.getValue((Property)LIT);
        if (bl != world.hasNeighborSignal(pos)) {
            if (bl) {
                world.scheduleTick(pos, (Block)this, 4);
            } else {
                world.setBlock(pos, (BlockState)state.cycle((Property)LIT), 2);
            }
        }
        super.neighborChanged(state, world, pos, block, fromPos, notify);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SIMPLE_LIGHT;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

