/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.DynamicRenderLayerInterface;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.blockentities.StoveBlockEntity;
import com.unlikepaladin.pfm.blocks.neoforge.StoveBlockImpl;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.Statistics;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StoveBlock
extends SmokerBlock
implements DynamicRenderLayerInterface {
    private static final List<FurnitureBlock> STOVES = new ArrayList<FurnitureBlock>();
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    protected static final VoxelShape STOVE = Shapes.or((VoxelShape)StoveBlock.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{StoveBlock.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), StoveBlock.box((double)0.0, (double)16.0, (double)15.0, (double)16.0, (double)19.0, (double)16.0)});
    protected static final VoxelShape STOVE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, STOVE);
    protected static final VoxelShape STOVE_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, STOVE);
    protected static final VoxelShape STOVE_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, STOVE);

    public StoveBlock(BlockBehaviour.Properties settings) {
        super(settings);
        if (this.getClass().isAssignableFrom(StoveBlock.class)) {
            STOVES.add(new FurnitureBlock((Block)this, "stove"));
        }
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public static Stream<FurnitureBlock> streamStoves() {
        return STOVES.stream();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT, OPEN});
    }

    protected void openContainer(Level world, BlockPos pos, Player player) {
        StoveBlock.openMenuScreen(world, pos, player);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void openMenuScreen(Level world, BlockPos pos, Player player) {
        void var2_2;
        void var1_1;
        StoveBlockImpl.openMenuScreen(world, (BlockPos)var1_1, (Player)var2_2);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (PaladinFurnitureMod.getModList().contains("cookingforblockheads")) {
            return StoveBlock.onUseCookingForBlockheads(state, world, pos, player, hand, hit);
        }
        if (world.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (hit.getDirection() == Direction.UP && world.getBlockEntity(pos) instanceof StoveBlockEntity) {
            ItemStack itemStack;
            StoveBlockEntity stoveBlockEntity;
            Optional<RecipeHolder<CampfireCookingRecipe>> optional;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof StoveBlockEntity && (optional = (stoveBlockEntity = (StoveBlockEntity)blockEntity).getRecipeFor(itemStack = player.getItemInHand(hand))).isPresent() && stoveBlockEntity.addItem(player.getAbilities().instabuild ? itemStack.copy() : itemStack, ((CampfireCookingRecipe)optional.get().value()).getCookingTime())) {
                player.awardStat(Statistics.STOVE_OPENED);
                return ItemInteractionResult.SUCCESS;
            }
            if (blockEntity instanceof StoveBlockEntity) {
                stoveBlockEntity = (StoveBlockEntity)blockEntity;
                for (int i = 0; i < stoveBlockEntity.getItemsBeingCooked().size(); ++i) {
                    ItemStack itemStack1 = (ItemStack)stoveBlockEntity.getItemsBeingCooked().get(i);
                    if (itemStack1.isEmpty() || !world.getRecipeManager().getRecipeFor(RecipeType.CAMPFIRE_COOKING, (RecipeInput)new SingleRecipeInput(itemStack1), world).isEmpty()) continue;
                    ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, stoveBlockEntity.removeItemNoUpdate(i));
                    world.addFreshEntity((Entity)itemEntity);
                    player.awardStat(Statistics.STOVE_OPENED);
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.CONSUME;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        this.openContainer(world, pos, player);
        return ItemInteractionResult.CONSUME;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        return switch (dir) {
            case Direction.WEST -> STOVE_WEST;
            case Direction.NORTH -> STOVE;
            case Direction.SOUTH -> STOVE_SOUTH;
            default -> STOVE_EAST;
        };
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        double x = (double)pos.getX() + 0.5;
        double y = pos.getY();
        double z = (double)pos.getZ() + 0.5;
        if (random.nextDouble() < 0.1) {
            world.playLocalSound(x, y, z, SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        int min = 0;
        int max = 3;
        int griddleChosen = (int)Math.floor(Math.random() * (double)(max - min + 1) + (double)min);
        switch (griddleChosen) {
            case 0: {
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x - 0.25, y + 1.1, z - 0.2, 0.0, 0.0, 0.0);
                break;
            }
            case 1: {
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + 0.25, y + 1.1, z - 0.2, 0.0, 0.0, 0.0);
                break;
            }
            case 2: {
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + 0.25, y + 1.1, z + 0.2, 0.0, 0.0, 0.0);
                break;
            }
            case 3: {
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x - 0.25, y + 1.1, z + 0.2, 0.0, 0.0, 0.0);
            }
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return StoveBlock.getBlockEntity(pos, state);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntity getBlockEntity(BlockPos pos, BlockState state) {
        void var1_1;
        return StoveBlockImpl.getBlockEntity(pos, (BlockState)var1_1);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return StoveBlock.getModdedTicker(world, state, type);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockEntity> BlockEntityTicker<T> getModdedTicker(Level world, BlockState state, BlockEntityType<T> type) {
        void var2_2;
        void var1_1;
        return StoveBlockImpl.getModdedTicker(world, (BlockState)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemInteractionResult onUseCookingForBlockheads(BlockState blockState, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return StoveBlockImpl.onUseCookingForBlockheads(blockState, (Level)var1_1, (BlockPos)var2_2, (Player)var3_3, (InteractionHand)var4_4, (BlockHitResult)var5_5);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof StoveBlockEntity) {
            if (world instanceof ServerLevel) {
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)((StoveBlockEntity)blockEntity));
                ((StoveBlockEntity)blockEntity).getRecipesToAwardAndPopExperience((ServerLevel)world, Vec3.atCenterOf((Vec3i)pos));
                Containers.dropContents((Level)world, (BlockPos)pos, ((StoveBlockEntity)blockEntity).getItemsBeingCooked());
            }
            world.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getCustomRenderLayer() {
        return RenderType.translucent();
    }
}

