/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.SimpleStoolBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WallToiletPaperBlock
extends HorizontalDirectionalBlock {
    protected static final BooleanProperty WALL = BooleanProperty.create((String)"wall");
    private static final List<FurnitureBlock> TOILET_PAPER = new ArrayList<FurnitureBlock>();
    public static final MapCodec<WallToiletPaperBlock> CODEC = WallToiletPaperBlock.simpleCodec(WallToiletPaperBlock::new);
    public static final VoxelShape WALL_PAPER_SOUTH = Shapes.or((VoxelShape)WallToiletPaperBlock.box((double)11.5, (double)12.0, (double)12.0, (double)12.5, (double)13.0, (double)16.0), (VoxelShape[])new VoxelShape[]{WallToiletPaperBlock.box((double)3.5, (double)12.0, (double)11.5, (double)4.5, (double)13.0, (double)16.0), WallToiletPaperBlock.box((double)4.5, (double)10.5, (double)10.5, (double)11.5, (double)14.5, (double)14.5)});
    public static final VoxelShape WALL_PAPER_NORTH = SimpleStoolBlock.rotateShape(Direction.SOUTH, Direction.NORTH, WALL_PAPER_SOUTH);
    public static final VoxelShape WALL_PAPER_EAST = SimpleStoolBlock.rotateShape(Direction.SOUTH, Direction.EAST, WALL_PAPER_SOUTH);
    public static final VoxelShape WALL_PAPER_WEST = SimpleStoolBlock.rotateShape(Direction.SOUTH, Direction.WEST, WALL_PAPER_SOUTH);

    public WallToiletPaperBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WALL, (Comparable)Boolean.valueOf(false)));
        TOILET_PAPER.add(new FurnitureBlock((Block)this, "toilet_paper"));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static Stream<FurnitureBlock> streamToiletPaperBlocks() {
        return TOILET_PAPER.stream();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WALL, FACING});
        super.createBlockStateDefinition(builder);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockPos = pos.relative(direction);
        BlockState blockState = world.getBlockState(blockPos);
        return blockState.isFaceSturdy((BlockGetter)world, blockPos, direction);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == state.getValue((Property)FACING) && !state.canSurvive((LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isShiftKeyDown()) {
            world.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)WALL));
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch (direction) {
            case EAST: {
                return WALL_PAPER_EAST;
            }
            case WEST: {
                return WALL_PAPER_WEST;
            }
            case SOUTH: {
                return WALL_PAPER_SOUTH;
            }
        }
        return WALL_PAPER_NORTH;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

