/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.FreezerBlock;
import com.unlikepaladin.pfm.blocks.FridgeBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.blockentities.FridgeBlockEntity;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class XboxFridgeBlock
extends FridgeBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    protected static final VoxelShape XBOX_FRIDGE = Shapes.or((VoxelShape)XboxFridgeBlock.box((double)0.5, (double)1.0, (double)3.0, (double)15.5, (double)32.0, (double)16.0), (VoxelShape[])new VoxelShape[]{XboxFridgeBlock.box((double)1.0, (double)0.0, (double)2.84, (double)15.0, (double)1.0, (double)15.84), XboxFridgeBlock.box((double)0.51, (double)1.0, (double)1.91, (double)15.31, (double)16.0, (double)2.91)});
    protected static final VoxelShape XBOX_FRIDGE_UPPER = Shapes.or((VoxelShape)XboxFridgeBlock.box((double)0.5, (double)-15.0, (double)3.0, (double)15.5, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{XboxFridgeBlock.box((double)1.0, (double)-16.0, (double)2.84, (double)15.0, (double)-15.0, (double)15.84), XboxFridgeBlock.box((double)0.51, (double)0.0, (double)1.91, (double)15.31, (double)16.0, (double)2.91)});
    protected static final VoxelShape XBOX_FRIDGE_OPEN = Shapes.or((VoxelShape)XboxFridgeBlock.box((double)0.5, (double)1.0, (double)3.0, (double)15.5, (double)32.0, (double)16.0), (VoxelShape[])new VoxelShape[]{XboxFridgeBlock.box((double)1.0, (double)0.0, (double)2.84, (double)15.0, (double)1.0, (double)15.84), XboxFridgeBlock.box((double)0.5, (double)16.0, (double)-11.69, (double)1.5, (double)32.0, (double)3.11)});
    protected static final VoxelShape XBOX_FRIDGE_UPPER_OPEN = Shapes.or((VoxelShape)XboxFridgeBlock.box((double)0.5, (double)-15.0, (double)3.0, (double)15.5, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{XboxFridgeBlock.box((double)1.0, (double)-16.0, (double)2.84, (double)15.0, (double)-15.0, (double)15.84), XboxFridgeBlock.box((double)0.5, (double)0.0, (double)-11.69, (double)1.5, (double)16.0, (double)3.11)});
    protected static final VoxelShape XBOX_FRIDGE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, XBOX_FRIDGE);
    protected static final VoxelShape XBOX_FRIDGE_UPPER_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, XBOX_FRIDGE_UPPER);
    protected static final VoxelShape XBOX_FRIDGE_OPEN_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, XBOX_FRIDGE_OPEN);
    protected static final VoxelShape XBOX_FRIDGE_UPPER_OPEN_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, XBOX_FRIDGE_UPPER_OPEN);
    protected static final VoxelShape XBOX_FRIDGE_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, XBOX_FRIDGE);
    protected static final VoxelShape XBOX_FRIDGE_UPPER_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, XBOX_FRIDGE_UPPER);
    protected static final VoxelShape XBOX_FRIDGE_OPEN_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, XBOX_FRIDGE_OPEN);
    protected static final VoxelShape XBOX_FRIDGE_UPPER_OPEN_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, XBOX_FRIDGE_UPPER_OPEN);
    protected static final VoxelShape XBOX_FRIDGE_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, XBOX_FRIDGE);
    protected static final VoxelShape XBOX_FRIDGE_UPPER_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, XBOX_FRIDGE_UPPER);
    protected static final VoxelShape XBOX_FRIDGE_OPEN_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, XBOX_FRIDGE_OPEN);
    protected static final VoxelShape XBOX_FRIDGE_UPPER_OPEN_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, XBOX_FRIDGE_UPPER_OPEN);

    public XboxFridgeBlock(BlockBehaviour.Properties settings, Supplier<FreezerBlock> freezer) {
        super(settings, freezer);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        stateManager.add(new Property[]{OPEN});
        stateManager.add(new Property[]{HALF});
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FridgeBlockEntity) {
            player.openMenu((MenuProvider)((FridgeBlockEntity)blockEntity));
            player.awardStat(Statistics.FRIDGE_OPENED);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        world.setBlock(pos.above(), (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)placer.getDirection())).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)), 3);
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide && player.isCreative()) {
            this.onBreakInCreative(world, pos, state, player);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.getValue(HALF);
        if (direction.getAxis() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP) && neighborState.is((Block)this) && neighborState.getValue(HALF) != doubleBlockHalf) {
            return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)neighborState.getValue((Property)FACING)))).setValue((Property)OPEN, (Comparable)((Boolean)neighborState.getValue((Property)OPEN)));
        }
        return state;
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.below();
        BlockState blockState = world.getBlockState(blockPos);
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return blockState.isFaceSturdy((BlockGetter)world, blockPos, Direction.UP);
        }
        return blockState.is((Block)this);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        Level world = ctx.getLevel();
        if (blockPos.getY() < world.getMaxBuildHeight() - 1 && world.getBlockState(blockPos.above()).canBeReplaced(ctx)) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockState blockState2;
        BlockPos blockPos = pos.below();
        BlockState blockState = world.getBlockState(blockPos);
        if (blockState.is(state.getBlock())) {
            blockState2 = blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            world.setBlock(blockPos, blockState2, 35);
        }
        if ((blockState = world.getBlockState(blockPos = pos.above())).is(state.getBlock())) {
            blockState2 = blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            world.setBlock(blockPos, blockState2, 35);
        }
        super.destroy(world, pos, state);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        Boolean open = (Boolean)state.getValue((Property)OPEN);
        Enum half = (Enum)((Object)state.getValue(HALF));
        switch (dir) {
            case NORTH: {
                if (half == DoubleBlockHalf.UPPER) {
                    if (open.booleanValue()) {
                        return XBOX_FRIDGE_UPPER_OPEN_SOUTH;
                    }
                    return XBOX_FRIDGE_UPPER_SOUTH;
                }
                if (open.booleanValue()) {
                    return XBOX_FRIDGE_OPEN_SOUTH;
                }
                return XBOX_FRIDGE_SOUTH;
            }
            case SOUTH: {
                if (half == DoubleBlockHalf.UPPER) {
                    if (open.booleanValue()) {
                        return XBOX_FRIDGE_UPPER_OPEN;
                    }
                    return XBOX_FRIDGE_UPPER;
                }
                if (open.booleanValue()) {
                    return XBOX_FRIDGE_OPEN;
                }
                return XBOX_FRIDGE;
            }
            case EAST: {
                if (half == DoubleBlockHalf.UPPER) {
                    if (open.booleanValue()) {
                        return XBOX_FRIDGE_UPPER_OPEN_WEST;
                    }
                    return XBOX_FRIDGE_UPPER_WEST;
                }
                if (open.booleanValue()) {
                    return XBOX_FRIDGE_OPEN_WEST;
                }
                return XBOX_FRIDGE_WEST;
            }
        }
        if (half == DoubleBlockHalf.UPPER) {
            if (open.booleanValue()) {
                return XBOX_FRIDGE_UPPER_OPEN_EAST;
            }
            return XBOX_FRIDGE_UPPER_EAST;
        }
        if (open.booleanValue()) {
            return XBOX_FRIDGE_OPEN_EAST;
        }
        return XBOX_FRIDGE_EAST;
    }
}

