/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.behavior;

import com.unlikepaladin.pfm.blocks.KitchenSinkBlock;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public interface SinkBehavior
extends CauldronInteraction {
    public static final SinkBehavior FILL_SINK_WITH_WATER = (state, world, pos, player, hand, stack) -> SinkBehavior.fillCauldron(world, pos, player, hand, stack, (BlockState)state.setValue((Property)KitchenSinkBlock.LEVEL_4, (Comparable)Integer.valueOf(3)), SoundEvents.BUCKET_EMPTY);
    public static final CauldronInteraction.InteractionMap WATER_SINK_BEHAVIOR = CauldronInteraction.newInteractionMap((String)"sink");
    public static final CauldronInteraction CLEAN_SHULKER_BOX = (state, world, pos, player, hand, stack) -> {
        if ((Integer)state.getValue((Property)KitchenSinkBlock.LEVEL_4) == 0) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Block block = Block.byItem((Item)stack.getItem());
        if (!(block instanceof ShulkerBoxBlock)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!world.isClientSide) {
            player.setItemInHand(hand, stack.transmuteCopy((ItemLike)Blocks.SHULKER_BOX, 1));
            player.awardStat(Stats.CLEAN_SHULKER_BOX);
            KitchenSinkBlock.decrementFluidLevel(state, world, pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    };
    public static final CauldronInteraction CLEAN_DYEABLE_ITEM = (state, world, pos, player, hand, stack) -> {
        if ((Integer)state.getValue((Property)KitchenSinkBlock.LEVEL_4) == 0) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!stack.is(ItemTags.DYEABLE)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!stack.has(DataComponents.DYED_COLOR)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!world.isClientSide) {
            stack.remove(DataComponents.DYED_COLOR);
            player.awardStat(Stats.CLEAN_ARMOR);
            KitchenSinkBlock.decrementFluidLevel(state, world, pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    };
    public static final CauldronInteraction CLEAN_BANNER = (state, world, pos, player, hand, stack) -> {
        BannerPatternLayers bannerPatternsComponent = (BannerPatternLayers)stack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
        if (bannerPatternsComponent.layers().isEmpty() || (Integer)state.getValue((Property)KitchenSinkBlock.LEVEL_4) == 0) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!world.isClientSide) {
            ItemStack itemStack = stack.copyWithCount(1);
            itemStack.set(DataComponents.BANNER_PATTERNS, (Object)bannerPatternsComponent.removeLast());
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if (stack.isEmpty()) {
                player.setItemInHand(hand, itemStack);
            } else if (player.getInventory().add(itemStack)) {
                player.inventoryMenu.sendAllDataToRemote();
            } else {
                player.drop(itemStack, false);
            }
            player.awardStat(Stats.CLEAN_BANNER);
            KitchenSinkBlock.decrementFluidLevel(state, world, pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    };

    public static ItemInteractionResult fillCauldron(Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, BlockState state, SoundEvent soundEvent) {
        if (!world.isClientSide) {
            Item item = stack.getItem();
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.BUCKET)));
            player.awardStat(Statistics.SINK_FILLED);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            world.setBlockAndUpdate(pos, state);
            world.playSound(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    public static ItemInteractionResult emptyCauldron(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, ItemStack output, Predicate<BlockState> predicate, SoundEvent soundEvent) {
        if (!predicate.test(state)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!world.isClientSide) {
            Item item = stack.getItem();
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)output));
            player.awardStat(Statistics.USE_SINK);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)KitchenSinkBlock.LEVEL_4, (Comparable)Integer.valueOf(0)));
            world.playSound(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    public static void registerBucketBehavior(Map<Item, CauldronInteraction> behavior) {
        behavior.put(Items.WATER_BUCKET, FILL_SINK_WITH_WATER);
    }

    public static void registerBehavior() {
        WATER_SINK_BEHAVIOR.map().put(Items.POTION, (state, world, pos, player, hand, stack) -> {
            PotionContents potionContentsComponent = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
            if (potionContentsComponent != null && !potionContentsComponent.is(Potions.WATER)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (!world.isClientSide) {
                Item item = stack.getItem();
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                player.awardStat(Statistics.USE_SINK);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)KitchenSinkBlock.LEVEL_4, (Comparable)Integer.valueOf((Integer)state.getValue((Property)KitchenSinkBlock.LEVEL_4) + 1)));
                world.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        });
        SinkBehavior.registerBucketBehavior(WATER_SINK_BEHAVIOR.map());
        WATER_SINK_BEHAVIOR.map().put(Items.BUCKET, (state2, world, pos, player, hand, stack) -> SinkBehavior.emptyCauldron(state2, world, pos, player, hand, stack, new ItemStack((ItemLike)Items.WATER_BUCKET), state -> (Integer)state.getValue((Property)KitchenSinkBlock.LEVEL_4) == 3, SoundEvents.BUCKET_FILL));
        WATER_SINK_BEHAVIOR.map().put(Items.GLASS_BOTTLE, (state, world, pos, player, hand, stack) -> {
            if (!world.isClientSide) {
                if ((Integer)state.getValue((Property)KitchenSinkBlock.LEVEL_4) == 0) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                Item item = stack.getItem();
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER)));
                player.awardStat(Statistics.USE_SINK);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                KitchenSinkBlock.decrementFluidLevel(state, world, pos);
                world.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        });
        WATER_SINK_BEHAVIOR.map().put(Items.POTION, (state, world, pos, player, hand, stack) -> {
            PotionContents potionContentsComponent = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
            if ((Integer)state.getValue((Property)KitchenSinkBlock.LEVEL_4) == 3 || potionContentsComponent != null && !potionContentsComponent.is(Potions.WATER)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (!world.isClientSide) {
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                player.awardStat(Statistics.USE_SINK);
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                world.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)KitchenSinkBlock.LEVEL_4));
                world.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        });
        WATER_SINK_BEHAVIOR.map().put(Items.LEATHER_BOOTS, CLEAN_DYEABLE_ITEM);
        WATER_SINK_BEHAVIOR.map().put(Items.LEATHER_LEGGINGS, CLEAN_DYEABLE_ITEM);
        WATER_SINK_BEHAVIOR.map().put(Items.LEATHER_CHESTPLATE, CLEAN_DYEABLE_ITEM);
        WATER_SINK_BEHAVIOR.map().put(Items.LEATHER_HELMET, CLEAN_DYEABLE_ITEM);
        WATER_SINK_BEHAVIOR.map().put(Items.LEATHER_HORSE_ARMOR, CLEAN_DYEABLE_ITEM);
        WATER_SINK_BEHAVIOR.map().put(Items.WHITE_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.GRAY_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.BLACK_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.BLUE_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.BROWN_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.CYAN_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.GREEN_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.LIGHT_BLUE_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.LIGHT_GRAY_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.LIME_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.MAGENTA_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.ORANGE_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.PINK_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.PURPLE_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.RED_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.YELLOW_BANNER, CLEAN_BANNER);
        WATER_SINK_BEHAVIOR.map().put(Items.WHITE_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.GRAY_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.BLACK_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.BLUE_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.BROWN_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.CYAN_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.GREEN_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.LIGHT_BLUE_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.LIGHT_GRAY_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.LIME_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.MAGENTA_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.ORANGE_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.PINK_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.PURPLE_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.RED_SHULKER_BOX, CLEAN_SHULKER_BOX);
        WATER_SINK_BEHAVIOR.map().put(Items.YELLOW_SHULKER_BOX, CLEAN_SHULKER_BOX);
    }
}

