/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.blocks.BasicBathtubBlock;
import com.unlikepaladin.pfm.registry.BlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BathtubBlockEntity
extends BedBlockEntity {
    private int fillTimer = 0;
    private boolean isFilling = false;

    public BathtubBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, DyeColor.WHITE);
    }

    public BlockEntityType<?> getType() {
        return BlockEntities.BATHTUB_BLOCK_ENTITY;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.writeIdentifyingTubData(new CompoundTag());
    }

    private CompoundTag writeIdentifyingTubData(CompoundTag nbt) {
        ResourceLocation identifier = BlockEntityType.getKey(this.getType());
        if (identifier == null) {
            throw new RuntimeException(String.valueOf(((Object)((Object)this)).getClass()) + " is missing a mapping! This is a bug!");
        }
        nbt.putString("id", identifier.toString());
        nbt.putInt("x", this.worldPosition.getX());
        nbt.putInt("y", this.worldPosition.getY());
        nbt.putInt("z", this.worldPosition.getZ());
        nbt.putInt("tubTimer", this.fillTimer);
        nbt.putBoolean("isTubFilling", this.isFilling);
        return nbt;
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.fillTimer = nbt.getInt("tubTimer");
        this.isFilling = nbt.getBoolean("isTubFilling");
        super.loadAdditional(nbt, registryLookup);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("tubTimer", this.fillTimer);
        nbt.putBoolean("isTubFilling", this.isFilling);
    }

    public void setFillTimer(int fillTimer) {
        this.fillTimer = fillTimer;
    }

    public void setFilling(boolean isFilling) {
        if (isFilling) {
            this.level.playSound(null, this.worldPosition, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, 0.7f, 1.0f);
        }
        this.isFilling = isFilling;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, BathtubBlockEntity blockEntity) {
        if (blockEntity.isFilling) {
            if (blockEntity.fillTimer >= 30) {
                blockEntity.setFillTimer(0);
                blockEntity.setFilling(false);
            } else {
                if (world.isClientSide) {
                    BasicBathtubBlock.spawnParticles((Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING), blockEntity.level, blockEntity.getBlockPos());
                }
                ++blockEntity.fillTimer;
            }
        }
    }

    public boolean isValidBlockState(BlockState state) {
        return this.getType().isValid(state);
    }
}

