/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.blocks.PowerableBlock;
import com.unlikepaladin.pfm.registry.BlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class LightSwitchBlockEntity
extends BlockEntity {
    private final List<BlockPos> lights = NonNullList.create();

    public LightSwitchBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.LIGHT_SWITCH_BLOCK_ENTITY, pos, state);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ListTag tagList = new ListTag();
        this.lights.forEach(blockPos -> tagList.add((Object)LongTag.valueOf((long)blockPos.asLong())));
        nbt.put("lights", (Tag)tagList);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        if (nbt.contains("lights", 9)) {
            this.lights.clear();
            ListTag lightTagList = nbt.getList("lights", 4);
            lightTagList.forEach(nbtElement -> this.addLight(((LongTag)nbtElement).getAsLong()));
        }
    }

    public void addLight(long pos) {
        BlockPos lightPos = BlockPos.of((long)pos);
        if (!this.lights.contains(lightPos)) {
            this.lights.add(lightPos);
        }
    }

    public void setState(boolean powered) {
        if (!this.lights.isEmpty()) {
            this.lights.removeIf(offset -> {
                BlockState state = this.level.getBlockState(this.worldPosition.subtract((Vec3i)offset));
                return !(state.getBlock() instanceof PowerableBlock);
            });
            this.lights.forEach(offset -> {
                BlockPos actualPos = this.worldPosition.subtract((Vec3i)offset);
                BlockState state = this.level.getBlockState(actualPos);
                ((PowerableBlock)state.getBlock()).setPowered(this.level, actualPos, powered);
            });
        }
    }
}

