/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.PFMToasterBlock;
import com.unlikepaladin.pfm.blocks.blockentities.neoforge.PFMToasterBlockEntityImpl;
import com.unlikepaladin.pfm.registry.BlockEntities;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PFMToasterBlockEntity
extends BlockEntity
implements WorldlyContainer {
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    @Nullable
    private UUID lastUser;
    private static int toastTime = 240;
    private int toastProgress = 0;
    private boolean toasting = false;
    private boolean smoking = false;
    private int smokeProgress = 0;
    private boolean currentlyPowered = false;
    private boolean previouslyPowered = false;
    private boolean updateNeighbors = false;
    private boolean tickPitch = false;

    public PFMToasterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.TOASTER_BLOCK_ENTITY, pos, state);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        this.toastProgress = nbt.getInt("toastProgress");
        this.toasting = nbt.getBoolean("toasting");
        this.smokeProgress = nbt.getInt("smokeProgress");
        this.smoking = nbt.getBoolean("smoking");
        this.lastUser = nbt.contains("lastUser") ? nbt.getUUID("lastUser") : null;
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.items, (HolderLookup.Provider)registryLookup);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        nbt.putInt("toastProgress", this.toastProgress);
        nbt.putBoolean("toasting", this.toasting);
        nbt.putInt("smokeProgress", this.smokeProgress);
        nbt.putBoolean("smoking", this.smoking);
        if (this.lastUser == null) {
            nbt.remove("lastUser");
        } else {
            nbt.putUUID("lastUser", this.lastUser);
        }
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.items, (HolderLookup.Provider)registryLookup);
        super.saveAdditional(nbt, registryLookup);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithoutMetadata(registryLookup);
    }

    private void explode() {
        if (!this.level.isClientSide) {
            this.level.removeBlock(this.worldPosition, true);
            Player player = this.level.getNearestPlayer((double)this.worldPosition.getX(), (double)this.worldPosition.getZ(), 8.0, 10.0, false);
            this.level.explode((Entity)player, this.level.damageSources().explosion((Entity)player, (Entity)player), null, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), 2.2f, true, Level.ExplosionInteraction.BLOCK);
        }
    }

    public Direction getToasterFacing() {
        if (this.level.getBlockState(this.worldPosition).getBlock() instanceof PFMToasterBlock) {
            return (Direction)this.level.getBlockState(this.worldPosition).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        }
        return Direction.NORTH;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setCurrentItem(int i, ItemStack stack) {
        this.items.set(i, (Object)stack);
        PFMToasterBlockEntity.sync(this, this.level);
    }

    public Optional<Player> getLastUser() {
        return Optional.ofNullable(this.lastUser).map(arg_0 -> ((Level)this.level).getPlayerByUUID(arg_0));
    }

    public void setLastUser(@Nullable Player player) {
        this.lastUser = player == null ? null : player.getUUID();
    }

    public ItemStack takeItem(@Nullable Player player) {
        int index = !((ItemStack)this.items.get(1)).isEmpty() ? 1 : 0;
        ItemStack stack = (ItemStack)this.items.get(index);
        this.items.set(index, (Object)ItemStack.EMPTY);
        this.updateNeighbors = true;
        this.setLastUser(player);
        return stack;
    }

    public boolean addItem(InteractionHand hand, Player player) {
        if (!this.toasting) {
            ItemStack playerItem = player.getItemInHand(hand).copy();
            playerItem.setCount(1);
            if (!((ItemStack)this.items.get(0)).isEmpty() && !((ItemStack)this.items.get(1)).isEmpty()) {
                return false;
            }
            if (!player.isCreative()) {
                player.getItemInHand(hand).shrink(1);
            }
            int index = !((ItemStack)this.items.get(0)).isEmpty() ? 1 : 0;
            this.items.set(index, (Object)playerItem);
            this.updateNeighbors = true;
            this.setLastUser(player);
            return true;
        }
        return false;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isMetal(ItemStack stack) {
        return PFMToasterBlockEntityImpl.isMetal(stack);
    }

    public boolean hasMetalInside() {
        if (PaladinFurnitureMod.getModList().contains("sandwichable")) {
            return PFMToasterBlockEntity.isMetal((ItemStack)this.items.get(0)) || PFMToasterBlockEntity.isMetal((ItemStack)this.items.get(1));
        }
        return ((ItemStack)this.items.get(0)).getDescriptionId().contains("iron") || ((ItemStack)this.items.get(1)).getDescriptionId().contains("iron");
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sandwichableToast(PFMToasterBlockEntity pfmToasterBlockEntity) {
        PFMToasterBlockEntityImpl.sandwichableToast(pfmToasterBlockEntity);
    }

    private void toastItems() {
        if (PaladinFurnitureMod.getModList().contains("sandwichable")) {
            PFMToasterBlockEntity.sandwichableToast(this);
        } else {
            for (int i = 0; i < 2; ++i) {
                Optional match = this.level.getRecipeManager().getRecipeFor(RecipeType.CAMPFIRE_COOKING, (RecipeInput)new SingleRecipeInput((ItemStack)this.items.get(i)), this.level);
                boolean changed = false;
                if (match.isPresent()) {
                    this.items.set(i, (Object)((CampfireCookingRecipe)((RecipeHolder)match.get()).value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).copy());
                    changed = true;
                    continue;
                }
                if (!((ItemStack)this.items.get(i)).has(DataComponents.FOOD)) continue;
                Item item = Items.COAL;
                this.items.set(i, (Object)new ItemStack((ItemLike)item, 1));
                boolean bl = true;
            }
        }
    }

    public void startToasting(@Nullable Player player) {
        if (this.level.getBlockState(this.worldPosition).getBlock() instanceof PFMToasterBlock) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)PFMToasterBlock.ON, (Comparable)Boolean.valueOf(true)));
        }
        this.level.playSound(null, this.worldPosition, SoundEvents.WOODEN_BUTTON_CLICK_ON, SoundSource.BLOCKS, 0.5f, 0.8f);
        this.toastProgress = 0;
        this.toasting = true;
        this.updateNeighbors = true;
        if (player != null) {
            this.setLastUser(player);
        }
    }

    public void stopToasting(@Nullable Player player) {
        if (this.level.getBlockState(this.worldPosition).getBlock() instanceof PFMToasterBlock) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)PFMToasterBlock.ON, (Comparable)Boolean.valueOf(false)));
        }
        this.level.playSound(null, this.worldPosition, (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.BLOCKS, 0.8f, 4.0f);
        this.toastProgress = 0;
        this.toasting = false;
        this.updateNeighbors = true;
        if (player != null) {
            this.setLastUser(player);
        }
    }

    public int getComparatorOutput() {
        int r = 0;
        for (int i = 0; i < 2; ++i) {
            r += ((ItemStack)this.items.get(i)).isEmpty() ? 0 : 1;
        }
        r = (int)Math.round((double)r * 7.5);
        return r;
    }

    public boolean isToasting() {
        return this.toasting;
    }

    public int getToastingProgress() {
        return this.toastProgress;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, PFMToasterBlockEntity blockEntity) {
        int smokeTime = 80;
        if (blockEntity.updateNeighbors) {
            world.blockUpdated(pos, world.getBlockState(pos).getBlock());
            blockEntity.updateNeighbors = false;
        }
        blockEntity.previouslyPowered = blockEntity.currentlyPowered;
        blockEntity.currentlyPowered = world.hasNeighborSignal(pos);
        if (blockEntity.toasting) {
            ++blockEntity.toastProgress;
            if (blockEntity.toastProgress % 4 == 0 && blockEntity.toastProgress != toastTime) {
                world.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.05f, blockEntity.tickPitch ? 2.0f : 1.9f);
                boolean bl = blockEntity.tickPitch = !blockEntity.tickPitch;
            }
            if (blockEntity.hasMetalInside()) {
                blockEntity.explode();
            }
        }
        if (blockEntity.toastProgress == toastTime) {
            blockEntity.stopToasting(null);
            blockEntity.toastItems();
            blockEntity.smoking = true;
        }
        if (blockEntity.smoking) {
            if (blockEntity.smokeProgress % 3 == 0) {
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, 0.0, 0.03, 0.0);
            }
            ++blockEntity.smokeProgress;
        }
        if (blockEntity.smokeProgress == smokeTime) {
            blockEntity.smoking = false;
            blockEntity.smokeProgress = 0;
        }
        if (blockEntity.currentlyPowered && !blockEntity.previouslyPowered && !blockEntity.toasting) {
            blockEntity.startToasting(null);
        }
    }

    public int[] getSlotsForFace(Direction side) {
        return new int[]{0, 1};
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return ((ItemStack)this.items.get(slot)).isEmpty();
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)PFMToasterBlock.ON) == false;
    }

    public int getContainerSize() {
        return 2;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.removeItemNoUpdate(slot);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = ((ItemStack)this.items.get(slot)).copy();
        this.items.set(slot, (Object)ItemStack.EMPTY);
        this.setLastUser(null);
        PFMToasterBlockEntity.sync(this, this.level);
        return stack;
    }

    public void setItem(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        this.setLastUser(null);
        PFMToasterBlockEntity.sync(this, this.level);
    }

    public boolean stillValid(Player player) {
        return false;
    }

    public void clearContent() {
        this.items.clear();
        PFMToasterBlockEntity.sync(this, this.level);
    }

    public static void sync(PFMToasterBlockEntity blockEntity, Level world) {
        if (!world.isClientSide) {
            ((ServerLevel)world).getChunkSource().blockChanged(blockEntity.getBlockPos());
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends PFMToasterBlockEntity> getFactory() {
        return PFMToasterBlockEntityImpl.getFactory();
    }
}

