/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.KitchenCounterOvenBlock;
import com.unlikepaladin.pfm.blocks.StoveBlock;
import com.unlikepaladin.pfm.blocks.blockentities.neoforge.StoveBlockEntityImpl;
import com.unlikepaladin.pfm.menus.StoveScreenHandler;
import com.unlikepaladin.pfm.registry.BlockEntities;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class StoveBlockEntity
extends AbstractFurnaceBlockEntity {
    String blockname = this.getBlockState().getBlock().getDescriptionId();
    protected final NonNullList<ItemStack> itemsBeingCooked = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private final int[] cookingTimes = new int[4];
    private final int[] cookingTotalTimes = new int[4];

    public StoveBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.STOVE_BLOCK_ENTITY, pos, state, RecipeType.SMOKING);
    }

    public StoveBlockEntity(BlockEntityType<?> entity, BlockPos pos, BlockState state) {
        super(entity, pos, state, RecipeType.SMOKING);
    }

    protected void onContainerOpen(Level world, BlockPos pos, BlockState state) {
        if (state.getBlock() instanceof StoveBlock) {
            this.playSound(state, SoundEvents.IRON_TRAPDOOR_OPEN);
            this.setOpen(state, true);
        }
    }

    protected void onContainerClose(Level world, BlockPos pos, BlockState state) {
        if (state.getBlock() instanceof StoveBlock) {
            this.playSound(state, SoundEvents.IRON_TRAPDOOR_CLOSE);
            this.setOpen(state, false);
        }
    }

    void setOpen(BlockState state, boolean open) {
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.onContainerClose(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.onContainerOpen(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    void playSound(BlockState state, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getNormal();
        double d = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double e = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double f = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    protected Component getDefaultName() {
        this.blockname = this.blockname.replace("block.pfm", "");
        if (this.getBlockState().getBlock() instanceof KitchenCounterOvenBlock) {
            return Component.translatable((String)"container.pfm.kitchen_counter_oven");
        }
        return Component.translatable((String)("container.pfm" + this.blockname));
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new StoveScreenHandler(syncId, playerInventory, (Container)this, this.dataAccess);
    }

    public NonNullList<ItemStack> getItemsBeingCooked() {
        return this.itemsBeingCooked;
    }

    public Optional<RecipeHolder<CampfireCookingRecipe>> getRecipeFor(ItemStack item) {
        if (this.itemsBeingCooked.stream().noneMatch(ItemStack::isEmpty)) {
            return Optional.empty();
        }
        return this.level.getRecipeManager().getRecipeFor(RecipeType.CAMPFIRE_COOKING, (RecipeInput)new SingleRecipeInput(item), this.level);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        int[] is;
        super.loadAdditional(nbt, registryLookup);
        this.itemsBeingCooked.clear();
        StoveBlockEntity.readNbt(nbt, this.itemsBeingCooked, registryLookup);
        if (nbt.contains("CookingTimes", 11)) {
            is = nbt.getIntArray("CookingTimes");
            System.arraycopy(is, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, is.length));
        }
        if (nbt.contains("CookingTotalTimes", 11)) {
            is = nbt.getIntArray("CookingTotalTimes");
            System.arraycopy(is, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, is.length));
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.saveInitialChunkData(nbt, registryLookup);
        nbt.putIntArray("CookingTimes", this.cookingTimes);
        nbt.putIntArray("CookingTotalTimes", this.cookingTotalTimes);
    }

    protected CompoundTag saveInitialChunkData(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        StoveBlockEntity.writeNbt(nbt, this.itemsBeingCooked, true, registryLookup);
        return nbt;
    }

    public static CompoundTag writeNbt(CompoundTag nbt, NonNullList<ItemStack> stacks, boolean setIfEmpty, HolderLookup.Provider registryLookup) {
        ListTag nbtList = new ListTag();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack itemStack = (ItemStack)stacks.get(i);
            if (itemStack.isEmpty()) continue;
            CompoundTag nbtCompound = new CompoundTag();
            nbtCompound.putByte("Slot", (byte)i);
            nbtList.add((Object)itemStack.save(registryLookup, (Tag)nbtCompound));
        }
        if (!nbtList.isEmpty() || setIfEmpty) {
            nbt.put("CookTopItems", (Tag)nbtList);
        }
        return nbt;
    }

    public static void readNbt(CompoundTag nbt, NonNullList<ItemStack> stacks, HolderLookup.Provider registryLookup) {
        ListTag nbtList = nbt.getList("CookTopItems", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.getCompound(i);
            int j = nbtCompound.getByte("Slot") & 0xFF;
            if (j < 0 || j >= stacks.size()) continue;
            stacks.set(j, (Object)ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)nbtCompound).orElse(ItemStack.EMPTY));
        }
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = ((ItemStack)this.itemsBeingCooked.get(slot)).copy();
        this.itemsBeingCooked.set(slot, (Object)ItemStack.EMPTY);
        this.updateListeners();
        return stack;
    }

    public void clearContent() {
        this.itemsBeingCooked.clear();
    }

    private void updateListeners() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public static void litServerTick(Level world, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof StoveBlockEntity) {
            StoveBlockEntity stoveBlockEntity = (StoveBlockEntity)blockEntity;
            boolean bl = false;
            for (int i = 0; i < stoveBlockEntity.itemsBeingCooked.size(); ++i) {
                ItemStack itemStack = (ItemStack)stoveBlockEntity.itemsBeingCooked.get(i);
                if (itemStack.isEmpty()) continue;
                bl = true;
                int n = i;
                if (stoveBlockEntity.cookingTimes[n] < 600) {
                    stoveBlockEntity.cookingTimes[n] = stoveBlockEntity.cookingTimes[n] + 2;
                }
                if (stoveBlockEntity.cookingTimes[i] < stoveBlockEntity.cookingTotalTimes[i]) continue;
                SingleRecipeInput inventory = new SingleRecipeInput(itemStack);
                ItemStack itemStack2 = world.getRecipeManager().getRecipeFor(RecipeType.CAMPFIRE_COOKING, (RecipeInput)inventory, world).map(campfireCookingRecipe -> ((CampfireCookingRecipe)campfireCookingRecipe.value()).assemble(inventory, (HolderLookup.Provider)world.registryAccess())).orElse(itemStack);
                if (PaladinFurnitureMod.getPFMConfig().doesFoodPopOffStove()) {
                    Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.above().getY(), (double)pos.getZ(), (ItemStack)itemStack2);
                    stoveBlockEntity.itemsBeingCooked.set(i, (Object)ItemStack.EMPTY);
                } else {
                    stoveBlockEntity.itemsBeingCooked.set(i, (Object)itemStack2);
                }
                world.sendBlockUpdated(pos, state, state, 3);
            }
            if (bl) {
                StoveBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
            }
            StoveBlockEntity.serverTick((Level)world, (BlockPos)pos, (BlockState)state, (AbstractFurnaceBlockEntity)stoveBlockEntity);
        }
    }

    public static void unlitServerTick(Level world, BlockPos pos, BlockState state, StoveBlockEntity stoveBlockEntity) {
        boolean bl = false;
        for (int i = 0; i < stoveBlockEntity.itemsBeingCooked.size(); ++i) {
            if (stoveBlockEntity.cookingTimes[i] <= 0) continue;
            bl = true;
            stoveBlockEntity.cookingTimes[i] = Mth.clamp((int)(stoveBlockEntity.cookingTimes[i] - 2), (int)0, (int)stoveBlockEntity.cookingTotalTimes[i]);
        }
        if (bl) {
            StoveBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
        }
        StoveBlockEntity.serverTick((Level)world, (BlockPos)pos, (BlockState)state, (AbstractFurnaceBlockEntity)stoveBlockEntity);
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof StoveBlockEntity) {
            StoveBlockEntity stoveBlockEntity = (StoveBlockEntity)blockEntity;
            RandomSource random = world.random;
            int i = ((Direction)state.getValue((Property)StoveBlock.FACING)).getClockWise().get2DDataValue();
            for (int j = 0; j < stoveBlockEntity.itemsBeingCooked.size(); ++j) {
                ItemStack stack = (ItemStack)stoveBlockEntity.itemsBeingCooked.get(j);
                if (stack.isEmpty() || !(random.nextFloat() < 0.2f) || world.getRecipeManager().getRecipeFor(RecipeType.CAMPFIRE_COOKING, (RecipeInput)new SingleRecipeInput(stack), world).isEmpty()) continue;
                Direction direction = Direction.from2DDataValue((int)Math.floorMod(j + i, 4));
                float f = 0.2125f;
                double x = (double)pos.getX() + 0.5 - (double)((float)direction.getStepX() * f + (float)direction.getClockWise().getStepX() * f);
                double y = (double)pos.getY() + 1.1;
                double z = (double)pos.getZ() + 0.5 - (double)((float)direction.getStepZ() * f + (float)direction.getClockWise().getStepZ() * f);
                for (int k = 0; k < 4; ++k) {
                    if (random.nextFloat() < 0.9f) continue;
                    world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 5.0E-4, 0.0);
                }
            }
        }
    }

    public boolean addItem(ItemStack item, int integer) {
        for (int i = 0; i < this.itemsBeingCooked.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.itemsBeingCooked.get(i);
            if (!itemStack.isEmpty()) continue;
            this.cookingTotalTimes[i] = integer;
            this.cookingTimes[i] = 0;
            this.itemsBeingCooked.set(i, (Object)item.split(1));
            this.updateListeners();
            return true;
        }
        return false;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends BlockEntity> getFactory() {
        return StoveBlockEntityImpl.getFactory();
    }
}

