/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.LogStoolBlock;
import com.unlikepaladin.pfm.blocks.SimpleBedBlock;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.runtime.data.PFMRecipeProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBakedModel
implements BakedModel {
    protected final ModelState settings;
    private final List<BakedModel> templateBakedModels;
    public static boolean reloading = false;
    Map<Block, VariantBase<?>> blockVariantMap = new HashMap();
    private final Map<BlockItem, BlockState> blockItemBlockStateMap = new HashMap<BlockItem, BlockState>();
    private final Map<Block, List<TextureAtlasSprite>> spriteList = new HashMap<Block, List<TextureAtlasSprite>>();

    public AbstractBakedModel(ModelState settings, List<BakedModel> templateBakedModels) {
        this.settings = settings;
        this.templateBakedModels = templateBakedModels;
    }

    public List<BakedModel> getTemplateBakedModels() {
        return this.templateBakedModels;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        return Collections.emptyList();
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public ItemTransforms getTransforms() {
        return this.templateBakedModels.get(0).getTransforms();
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public VariantBase<?> getVariant(BlockState state) {
        VariantBase<?> variant;
        if (this.blockVariantMap.containsKey(state.getBlock())) {
            variant = this.blockVariantMap.get(state.getBlock());
        } else if (state != null && PaladinFurnitureMod.furnitureEntryMap.containsKey(state.getBlock().getClass())) {
            variant = PaladinFurnitureMod.furnitureEntryMap.get(state.getBlock().getClass()).getVariantFromEntry(state.getBlock());
            this.blockVariantMap.put(state.getBlock(), variant);
        } else {
            variant = null;
        }
        return variant;
    }

    public <T> List<TextureAtlasSprite> getSpriteList(T element) {
        List<TextureAtlasSprite> spriteList = this.getSpriteListWrapped(element);
        if (spriteList == null || spriteList.isEmpty() || spriteList.size() < 2) {
            WoodVariant variant = WoodVariantRegistry.OAK;
            Material mainTexture = new Material(InventoryMenu.BLOCK_ATLAS, ModelHelper.getTextureId(((VariantBase)variant).getBaseBlock()));
            Material secondTexture = new Material(InventoryMenu.BLOCK_ATLAS, ModelHelper.getTextureId(((VariantBase)variant).getSecondaryBlock()));
            return List.of(mainTexture.sprite(), secondTexture.sprite());
        }
        return spriteList;
    }

    public <T> List<TextureAtlasSprite> getSpriteListWrapped(T element) {
        if (element instanceof BlockState) {
            BlockState state = (BlockState)element;
            return this.getSpriteFromState(state);
        }
        if (element instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)element;
            if (this.blockItemBlockStateMap.containsKey(blockItem)) {
                return this.getSpriteFromState(this.blockItemBlockStateMap.get(blockItem));
            }
            BlockState state = blockItem.getBlock().defaultBlockState();
            this.blockItemBlockStateMap.put(blockItem, state);
            return this.getSpriteFromState(state);
        }
        if (element instanceof Block) {
            Block block = (Block)element;
            if (this.spriteList.containsKey(block)) {
                return this.spriteList.get(block);
            }
            BlockState state = block.defaultBlockState();
            return this.getSpriteFromState(state);
        }
        if (element instanceof ItemStack && ((ItemStack)element).getItem() instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)((ItemStack)element).getItem();
            if (this.blockItemBlockStateMap.containsKey(blockItem)) {
                return this.getSpriteFromState(this.blockItemBlockStateMap.get(blockItem));
            }
            BlockState state = blockItem.getBlock().defaultBlockState();
            this.blockItemBlockStateMap.put(blockItem, state);
            return this.getSpriteFromState(state);
        }
        if (element == null) {
            return Collections.singletonList(this.getTemplateBakedModels().get(0).getParticleIcon());
        }
        PaladinFurnitureMod.GENERAL_LOGGER.error("Invalid element for sprite list method");
        return Collections.singletonList(this.getTemplateBakedModels().get(0).getParticleIcon());
    }

    protected List<TextureAtlasSprite> getBedSprites(DyeColor color, BlockState state) {
        ArrayList<TextureAtlasSprite> list = new ArrayList<TextureAtlasSprite>(3);
        VariantBase<?> variant = this.getVariant(state);
        return list;
    }

    private List<TextureAtlasSprite> getSpriteFromState(BlockState state) {
        if (this.spriteList.containsKey(state.getBlock())) {
            return this.spriteList.get(state.getBlock());
        }
        VariantBase<?> variant = this.getVariant(state);
        boolean stripped = state.getBlock().getDescriptionId().contains("stripped");
        ArrayList<TextureAtlasSprite> list = new ArrayList<TextureAtlasSprite>(3);
        if (state.getBlock() instanceof SimpleBedBlock) {
            DyeColor color = ModelHelper.getColor(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()));
            Material mainTexture = new Material(InventoryMenu.BLOCK_ATLAS, variant.getTexture(BlockType.PLANKS));
            Material spriteIdentifier = Sheets.BED_TEXTURES[color.getId()];
            list.add(mainTexture.sprite());
            list.add(spriteIdentifier.sprite());
        } else if (state.getBlock() instanceof LogStoolBlock) {
            mainTexture = stripped ? new Material(InventoryMenu.BLOCK_ATLAS, variant.getTexture(BlockType.STRIPPED_LOG)) : new Material(InventoryMenu.BLOCK_ATLAS, variant.getTexture(BlockType.LOG));
            secondTexture = stripped ? new Material(InventoryMenu.BLOCK_ATLAS, variant.getTexture(BlockType.STRIPPED_LOG_TOP)) : new Material(InventoryMenu.BLOCK_ATLAS, variant.getTexture(BlockType.LOG_TOP));
            list.add(mainTexture.sprite());
            list.add(secondTexture.sprite());
        } else if (!state.getBlock().getDescriptionId().contains("_raw_")) {
            mainTexture = stripped ? new Material(InventoryMenu.BLOCK_ATLAS, variant.getTexture(BlockType.STRIPPED_LOG)) : new Material(InventoryMenu.BLOCK_ATLAS, variant.getTexture(BlockType.PRIMARY));
            secondTexture = stripped ? new Material(InventoryMenu.BLOCK_ATLAS, variant.getTexture(BlockType.PRIMARY)) : new Material(InventoryMenu.BLOCK_ATLAS, variant.getTexture(BlockType.SECONDARY));
            list.add(mainTexture.sprite());
            list.add(secondTexture.sprite());
        } else {
            mainTexture = stripped ? new Material(InventoryMenu.BLOCK_ATLAS, variant.getTexture(BlockType.STRIPPED_LOG)) : new Material(InventoryMenu.BLOCK_ATLAS, variant.getTexture(BlockType.SECONDARY));
            list.add(mainTexture.sprite());
            list.add(mainTexture.sprite());
        }
        boolean isKitchen = state.getBlock().getDescriptionId().contains("kitchen_");
        if (isKitchen && !(variant instanceof WoodVariant)) {
            Tuple<Block, Block> counterMaterials = PFMRecipeProvider.getCounterMaterials(variant);
            Material mainTexture = new Material(InventoryMenu.BLOCK_ATLAS, ModelHelper.getTextureId((Block)counterMaterials.getA()));
            Material secondTexture = new Material(InventoryMenu.BLOCK_ATLAS, ModelHelper.getTextureId((Block)counterMaterials.getB()));
            list.set(0, mainTexture.sprite());
            list.set(1, secondTexture.sprite());
        }
        this.spriteList.put(state.getBlock(), list);
        return list;
    }
}

