/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models;

import com.mojang.datafixers.util.Pair;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.ExtraCounterVariant;
import com.unlikepaladin.pfm.data.materials.StoneVariant;
import com.unlikepaladin.pfm.data.materials.StoneVariantRegistry;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.runtime.PFMDataGenerator;
import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class ModelHelper {
    public static List<TextureAtlasSprite> OAK_SPRITES_PLANKS_TO_REPLACE = null;
    public static List<TextureAtlasSprite> OAK_SPRITES_BED_TO_REPLACE = null;
    public static List<TextureAtlasSprite> OAK_SPRITES_LOG_TOP_TO_REPLACE = null;
    public static final Map<Pair<String, String>, Pair<ResourceLocation, Integer>> blockToTextureMap = new HashMap<Pair<String, String>, Pair<ResourceLocation, Integer>>();
    private static final HashMap<ResourceLocation, Boolean> idCacheMap = new HashMap();

    public static List<TextureAtlasSprite> getOakPlankLogSprites() {
        if (OAK_SPRITES_PLANKS_TO_REPLACE == null) {
            Material planksId = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.parse((String)"minecraft:block/oak_planks"));
            Material logId = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.parse((String)"minecraft:block/oak_log"));
            OAK_SPRITES_PLANKS_TO_REPLACE = Arrays.asList(planksId.sprite(), logId.sprite());
        }
        return OAK_SPRITES_PLANKS_TO_REPLACE;
    }

    public static List<TextureAtlasSprite> getOakBedSprites() {
        if (OAK_SPRITES_BED_TO_REPLACE == null) {
            Material planksId = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.parse((String)"minecraft:block/oak_planks"));
            Material bedId = Sheets.BED_TEXTURES[DyeColor.RED.getId()];
            OAK_SPRITES_BED_TO_REPLACE = Arrays.asList(planksId.sprite(), bedId.sprite());
        }
        return OAK_SPRITES_BED_TO_REPLACE;
    }

    public static List<TextureAtlasSprite> getOakLogLogTopSprites() {
        if (OAK_SPRITES_LOG_TOP_TO_REPLACE == null) {
            Material logId = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.parse((String)"minecraft:block/oak_log"));
            Material logTopId = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.parse((String)"minecraft:block/oak_log_top"));
            OAK_SPRITES_LOG_TOP_TO_REPLACE = Arrays.asList(logId.sprite(), logTopId.sprite());
        }
        return OAK_SPRITES_LOG_TOP_TO_REPLACE;
    }

    public static boolean containsIdentifier(ResourceLocation[] modelIds, ResourceLocation comparison) {
        AtomicBoolean contains = new AtomicBoolean(false);
        Arrays.stream(modelIds).forEach(identifier -> {
            if (comparison.getPath().equals(identifier.getPath()) && comparison.getNamespace().equals(identifier.getNamespace())) {
                contains.set(true);
            }
        });
        return contains.get();
    }

    public static BlockType getBlockType(ResourceLocation identifier) {
        if (identifier.getPath().contains("stripped_")) {
            return BlockType.STRIPPED_LOG;
        }
        for (WoodVariant variant : WoodVariantRegistry.getVariants()) {
            if (!identifier.getPath().contains(variant.getPath())) continue;
            return BlockType.PLANKS;
        }
        return BlockType.BLOCK;
    }

    public static VariantBase<?> getVariant(ResourceLocation identifier) {
        VariantBase var = ModelHelper.getExtraCounterType(identifier);
        if (var == null) {
            var = ModelHelper.getStoneType(identifier);
        }
        if (var == null) {
            var = ModelHelper.getWoodType(identifier);
        }
        return var;
    }

    @Nullable
    public static ExtraCounterVariant getExtraCounterType(ResourceLocation identifier) {
        for (ExtraCounterVariant variant : ExtraCounterVariant.values()) {
            if (!identifier.getPath().contains(variant.getPath()) || ModelHelper.getBlockType(identifier) != BlockType.BLOCK) continue;
            return variant;
        }
        return null;
    }

    @Nullable
    public static StoneVariant getStoneType(ResourceLocation identifier) {
        for (StoneVariant variant : StoneVariantRegistry.getVariants()) {
            if (!identifier.getPath().contains(variant.getPath()) || ModelHelper.getBlockType(identifier) != BlockType.BLOCK) continue;
            return variant;
        }
        return null;
    }

    public static WoodVariant getWoodType(ResourceLocation identifier) {
        WoodVariant selectedVariant = null;
        for (WoodVariant woodVariant : WoodVariantRegistry.getVariants()) {
            if (!identifier.getPath().contains(woodVariant.identifier.getPath()) || identifier.getPath().contains("dark") && !woodVariant.identifier.getPath().contains("dark") || !identifier.getPath().contains(woodVariant.getNamespace()) && !woodVariant.isVanilla()) continue;
            selectedVariant = woodVariant;
        }
        return selectedVariant != null ? selectedVariant : WoodVariantRegistry.OAK;
    }

    public static DyeColor getColor(ResourceLocation identifier) {
        Object object = BuiltInRegistries.BLOCK.get(identifier);
        if (object instanceof DyeableFurnitureBlock) {
            DyeableFurnitureBlock block = (DyeableFurnitureBlock)object;
            return block.getPFMColor();
        }
        for (DyeColor color : DyeColor.values()) {
            if (!identifier.getPath().contains(color.getName()) || !identifier.getPath().contains("light") && color.getName().contains("light") || identifier.getPath().contains("light") && !color.getName().contains("light")) continue;
            return color;
        }
        return DyeColor.RED;
    }

    public static ResourceLocation getVanillaConcreteColor(ResourceLocation identifier) {
        DyeColor color = ModelHelper.getColor(identifier);
        if (!identifier.getPath().contains(color.getName())) {
            return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/white_concrete");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("block/" + color.getName() + "_concrete"));
    }

    public static Block getWoolColor(String string) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(string + "_wool")));
        if (block != Blocks.AIR) {
            return block;
        }
        return Blocks.WHITE_WOOL;
    }

    public static ResourceLocation getTextureId(Block block) {
        return ModelHelper.getTextureId(block, "");
    }

    public static ResourceLocation getTextureId(Block block, String postfix) {
        BakedModel model;
        ResourceLocation id;
        Pair pair;
        if (postfix.isEmpty()) {
            postfix = null;
        }
        if (blockToTextureMap.containsKey(pair = new Pair((Object)block.toString(), (Object)postfix)) && (blockToTextureMap.get(pair).getFirst() != MissingTextureAtlasSprite.getLocation() || (Integer)blockToTextureMap.get(pair).getSecond() > 3)) {
            return (ResourceLocation)blockToTextureMap.get(pair).getFirst();
        }
        int attemptNum = 1;
        if (blockToTextureMap.containsKey(pair)) {
            attemptNum += ((Integer)blockToTextureMap.get(pair).getSecond()).intValue();
        }
        if (postfix == null) {
            postfix = "";
        }
        if (postfix.isEmpty() && !PFMDataGenerator.areAssetsRunning()) {
            List quadList;
            BakedModel model2 = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(block.defaultBlockState());
            if (model2 != null && !(quadList = model2.getQuads(block.defaultBlockState(), Direction.NORTH, RandomSource.create((long)42L))).isEmpty() && (id = ((BakedQuad)quadList.get(0)).getSprite().contents().name()) != null && id != MissingTextureAtlasSprite.getLocation()) {
                blockToTextureMap.put((Pair<String, String>)pair, (Pair<ResourceLocation, Integer>)new Pair((Object)id, (Object)attemptNum));
                return id;
            }
        } else if (postfix.equals("_top") && !PFMDataGenerator.areAssetsRunning() && (model = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(block.defaultBlockState())) != null) {
            List quadList = model.getQuads(block.defaultBlockState(), Direction.UP, RandomSource.create((long)42L));
            if (!quadList.isEmpty() && (id = ((BakedQuad)quadList.get(0)).getSprite().contents().name()) != null && id != MissingTextureAtlasSprite.getLocation()) {
                blockToTextureMap.put((Pair<String, String>)pair, (Pair<ResourceLocation, Integer>)new Pair((Object)id, (Object)attemptNum));
                return id;
            }
            quadList = model.getQuads(block.defaultBlockState(), Direction.DOWN, RandomSource.create((long)42L));
            if (!quadList.isEmpty() && (id = ((BakedQuad)quadList.get(0)).getSprite().contents().name()) != null && id != MissingTextureAtlasSprite.getLocation()) {
                blockToTextureMap.put((Pair<String, String>)pair, (Pair<ResourceLocation, Integer>)new Pair((Object)id, (Object)attemptNum));
                return id;
            }
        }
        if (ModelHelper.idExists(TextureMapping.getBlockTexture((Block)block, (String)postfix), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = TextureMapping.getBlockTexture((Block)block, (String)postfix);
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, postfix), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, postfix);
        } else if (ModelHelper.idExists(TextureMapping.getBlockTexture((Block)block), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = TextureMapping.getBlockTexture((Block)block);
        } else if (ModelHelper.idExists(TextureMapping.getBlockTexture((Block)block, (String)"_side"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = TextureMapping.getBlockTexture((Block)block, (String)"_side");
        } else if (ModelHelper.idExists(TextureMapping.getBlockTexture((Block)block, (String)"_side_1"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = TextureMapping.getBlockTexture((Block)block, (String)"_side_1");
        } else if (ModelHelper.idExists(TextureMapping.getBlockTexture((Block)block, (String)"_bottom"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = TextureMapping.getBlockTexture((Block)block, (String)"_bottom");
        } else if (ModelHelper.idExists(TextureMapping.getBlockTexture((Block)block, (String)"_top"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = TextureMapping.getBlockTexture((Block)block, (String)"_top");
        } else if (ModelHelper.idExists(TextureMapping.getBlockTexture((Block)block, (String)"_middle"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = TextureMapping.getBlockTexture((Block)block, (String)"_middle");
        } else if (ModelHelper.idExists(ModelHelper.getPlankId(block), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = ModelHelper.getPlankId(block);
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_side"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_side");
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_side_1"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_side_1");
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_top"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_top");
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_middle"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_middle");
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_bottom"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_bottom");
        } else if (BuiltInRegistries.BLOCK.getKey((Object)block).getNamespace().equals("quark")) {
            id = TextureMapping.getBlockTexture((Block)block, (String)postfix);
        } else {
            PaladinFurnitureMod.GENERAL_LOGGER.warn("Couldn't find texture for, {}, this is attempt {} at finding it", (Object)block, (Object)attemptNum);
            id = MissingTextureAtlasSprite.getLocation();
        }
        blockToTextureMap.put((Pair<String, String>)pair, (Pair<ResourceLocation, Integer>)new Pair((Object)id, (Object)attemptNum));
        return id;
    }

    public static ResourceLocation getPlankId(Block block) {
        ResourceLocation identifier = BuiltInRegistries.BLOCK.getKey((Object)block);
        String namespace = identifier.getNamespace();
        Object path = identifier.getPath().replace("luphie_", "");
        if (((String)path).contains("planks")) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)(path = ((String)path).replace("_planks", "").replace("plank_", "")) + "/planks"));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            path = "planks_" + (String)path;
            if (namespace.contains("pixelmon") && ((String)path).contains("ultra")) {
                path = ((String)path).replace("ultra_", "").replace("_ultra", "");
                path = "ultra_space/" + (String)path;
            }
            if (namespace.equals("blue_skies")) {
                path = "wood/" + (String)path;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)path));
            path = ((String)path).replace("mining", "mine").replace("sorting", "sort").replace("transformation", "trans").replace("dark", "darkwood").replace("alpha_", "alpha_oak_").replace("flowering_pink", "flowerypink").replace("flowering_purple", "floweringpurple");
            ResourceLocation id2 = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/wood/" + (String)path));
            ResourceLocation id3 = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + ((String)path).replace("planks_", "") + "planks"));
            ResourceLocation id4 = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + ((String)path).replace("planks_", "") + "_planks"));
            ResourceLocation id5 = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + ((String)path).replace("planks_", "") + "plankstext"));
            ResourceLocation id6 = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + ((String)path).replace("planks_", "") + "plankretext"));
            ResourceLocation id7 = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + ((String)path).replace("planks_", "") + "_planks0"));
            ResourceLocation id8 = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + ((String)path).replace("planks_", "") + "_planks1"));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            if (ModelHelper.idExists(id2, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id2;
            }
            if (ModelHelper.idExists(id3, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id3;
            }
            if (ModelHelper.idExists(id4, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id4;
            }
            if (ModelHelper.idExists(id5, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id5;
            }
            if (ModelHelper.idExists(id6, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id6;
            }
            if (ModelHelper.idExists(id7, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id7;
            }
            if (ModelHelper.idExists(id8, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id8;
            }
            return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/wood/" + (String)path + "_0"));
        }
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)path));
    }

    public static ResourceLocation getLogId(Block block, String postFix) {
        ResourceLocation id;
        ResourceLocation identifier = BuiltInRegistries.BLOCK.getKey((Object)block);
        String namespace = identifier.getNamespace();
        Object path = identifier.getPath().replace("luphie_", "");
        if (namespace.contains("luphieclutteredmod") && ((String)path).contains("flowering_log")) {
            path = ((String)path).replace("flowering_log", "flowering_yellow_log");
        }
        if (namespace.contains("pixelmon") && ((String)path).contains("ultra")) {
            path = ((String)path).replace("ultra_", "").replace("_ultra", "");
            path = "ultra_space/" + (String)path;
        }
        if (namespace.equals("blue_skies")) {
            path = "wood/" + (String)path;
        }
        if (namespace.equals("byg") && ((String)path).contains("pedu")) {
            path = ((String)path).replace("pedu", "log");
        }
        if (((String)path).contains("log") || ((String)path).contains("stem")) {
            if (!((String)path).contains("_log")) {
                path = ((String)path).replace("log", "_log");
            }
            if (ModelHelper.idExists(id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)path)), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            path = ((String)path).replace("stem", "log").replace("log", "bark");
            path = (String)path + postFix;
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)(path = ((String)path).replace("stripped", "striped"))));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            path = ((String)path).replace("striped", "stripped");
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)(path = ((String)path).replace("bark", "log"))));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)(path = ((String)path).replace("stripped", "striped"))));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)(path = ((String)path).contains("striped") ? "stripped_" + ((String)path).replace("_striped", "") : path)));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)(path = ((String)path).replace("stripped", "striped"))));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            String loc = identifier.getPath().contains("stripped") || identifier.getPath().contains("striped") ? "stripped_log" : "log";
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)(path = ((String)path).replace("striped_", "").replace(postFix, "").replace("_log", "")) + "/" + loc + postFix));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)path + "/" + loc.replace("log", "stem") + postFix));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)path + "/" + loc + "/" + postFix.replace("_", "")));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)path + "/" + loc.replace("log", "stem") + "/" + postFix.replace("_", "")));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)path + "/" + loc));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)path + "/" + loc.replace("log", "stem")));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/stripped_" + (String)path + "_log"));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/stripped_" + (String)path + "_stem"));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)path + "_log_stripped"));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)path + "_stem_stripped"));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
        } else if (((String)path).contains("reed")) {
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)(path = ((String)path).replace("nether_", "").replace("reed", "reeds"))));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)(path = (String)path + postFix)));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + ((String)path).replace("planks", "roof")));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
        }
        if (((String)path).contains("alpha_") && namespace.contains("regions")) {
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)(path = !((String)path).contains("alpha_oak") ? ((String)path).replace("alpha", "alpha_oak") : path)));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)(path = (String)path + postFix)));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/alpha_oak_log" + postFix));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"block/alpha_oak_log");
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
        }
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + (String)path));
    }

    public static boolean idExists(ResourceLocation id, PackType resourceType, IdLocation idLocation) {
        if (idCacheMap.containsKey(id)) {
            return idCacheMap.get(id);
        }
        ResourceLocation id2 = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)(idLocation.getSerializedName() + "/" + id.getPath() + idLocation.getFileType()));
        AtomicBoolean exists = new AtomicBoolean(false);
        for (PackResources rp : PFMRuntimeResources.RESOURCE_PACK_LIST) {
            if (exists.get()) break;
            rp.listResources(resourceType, id2.getNamespace(), id2.getPath(), (identifier, supplier) -> {
                try {
                    ((InputStream)supplier.get()).read();
                    ((InputStream)supplier.get()).close();
                    exists.set(true);
                }
                catch (IOException e) {
                    exists.set(false);
                }
            });
        }
        idCacheMap.put(id, exists.get());
        return exists.get();
    }

    public static enum IdLocation implements StringRepresentable
    {
        TEXTURES("textures", ".png"),
        MODELS("models"),
        BLOCKSTATES("blockstates"),
        RECIPES("recipes"),
        TAGS("tags"),
        LOOT_TABLES("loot_tables"),
        STRUCTURES("structures"),
        ADVANCEMENTS("advancements");

        private final String name;
        private final String fileType;

        private IdLocation(String name, String fileType) {
            this.name = name;
            this.fileType = fileType;
        }

        private IdLocation(String name) {
            this.name = name;
            this.fileType = ".json";
        }

        public String getSerializedName() {
            return this.name;
        }

        public String getFileType() {
            return this.fileType;
        }
    }
}

