/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.basicCoffeeTable.neoforge;

import com.unlikepaladin.pfm.blocks.BasicCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.models.neoforge.ModelBitSetProperty;
import com.unlikepaladin.pfm.blocks.models.neoforge.PFMNeoForgeBakedModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgeCoffeeBasicTableModel
extends PFMNeoForgeBakedModel {
    public static ModelProperty<ModelBitSetProperty> CONNECTIONS = new ModelProperty();

    public NeoForgeCoffeeBasicTableModel(ModelState settings, List<BakedModel> modelParts) {
        super(settings, modelParts);
    }

    @Override
    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        if (state.getBlock() instanceof BasicCoffeeTableBlock) {
            ModelData.Builder builder = ModelData.builder();
            ModelData data = builder.build();
            data = super.getModelData(world, pos, state, data);
            BasicCoffeeTableBlock block = (BasicCoffeeTableBlock)state.getBlock();
            boolean north = block.canConnect((BlockGetter)world, state, pos.north(), pos);
            boolean east = block.canConnect((BlockGetter)world, state, pos.east(), pos);
            boolean west = block.canConnect((BlockGetter)world, state, pos.west(), pos);
            boolean south = block.canConnect((BlockGetter)world, state, pos.south(), pos);
            boolean cornerNorthWest = north && west && !block.canConnect((BlockGetter)world, state, pos.north().west(), pos);
            boolean cornerNorthEast = north && east && !block.canConnect((BlockGetter)world, state, pos.north().east(), pos);
            boolean cornerSouthEast = south && east && !block.canConnect((BlockGetter)world, state, pos.south().east(), pos);
            boolean cornerSouthWest = south && west && !block.canConnect((BlockGetter)world, state, pos.south().west(), pos);
            BitSet set = new BitSet();
            set.set(0, north);
            set.set(1, east);
            set.set(2, west);
            set.set(3, south);
            set.set(4, cornerNorthWest);
            set.set(5, cornerNorthEast);
            set.set(6, cornerSouthEast);
            set.set(7, cornerSouthWest);
            data = data.derive().with(CONNECTIONS, (Object)new ModelBitSetProperty(set)).build();
            return data;
        }
        return tileData;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, RenderType renderType) {
        if (state != null && state.getBlock() instanceof BasicCoffeeTableBlock && extraData.get(CONNECTIONS) != null && ((ModelBitSetProperty)extraData.get(NeoForgeCoffeeBasicTableModel.CONNECTIONS)).connections != null) {
            ArrayList<BakedQuad> baseQuads = new ArrayList<BakedQuad>();
            ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>();
            BitSet set = ((ModelBitSetProperty)extraData.get(NeoForgeCoffeeBasicTableModel.CONNECTIONS)).connections;
            boolean north = set.get(0);
            boolean east = set.get(1);
            boolean west = set.get(2);
            boolean south = set.get(3);
            boolean cornerNorthWest = set.get(4);
            boolean cornerNorthEast = set.get(5);
            boolean cornerSouthEast = set.get(6);
            boolean cornerSouthWest = set.get(7);
            Direction.Axis dir = (Direction.Axis)state.getValue(BasicCoffeeTableBlock.AXIS);
            baseQuads.addAll(this.getTemplateBakedModels().get(0).getQuads(state, side, rand, extraData, renderType));
            if (!(north || south || east || west)) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(8).getQuads(state, side, rand, extraData, renderType));
                secondaryQuads.addAll(this.getTemplateBakedModels().get(7).getQuads(state, side, rand, extraData, renderType));
            }
            if (dir == Direction.Axis.Z) {
                if (!north && !east) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData, renderType));
                }
                if (!south && !east) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData, renderType));
                }
                if (!south && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && south && !east && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(7).getQuads(state, side, rand, extraData, renderType));
                }
                if (north && !south && !east && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(8).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && east && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(5).getQuads(state, side, rand, extraData, renderType));
                }
                if (!south && !east && west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(10).getQuads(state, side, rand, extraData, renderType));
                }
                if (!south && east && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(9).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && !east && west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(6).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && east && west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(12).getQuads(state, side, rand, extraData, renderType));
                }
                if (!south && east && west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(11).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerNorthEast) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(13).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerNorthWest) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(14).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerSouthWest) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(16).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerSouthEast) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(15).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData, renderType));
                }
            } else {
                if (!north && !east) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderType));
                }
                if (!south && !east) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData, renderType));
                }
                if (!south && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && south && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(9).getQuads(state, side, rand, extraData, renderType));
                }
                if (north && !south && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(10).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && south && !east) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(5).getQuads(state, side, rand, extraData, renderType));
                }
                if (north && !south && !east) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(6).getQuads(state, side, rand, extraData, renderType));
                }
                if (!(north || south || east)) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(7).getQuads(state, side, rand, extraData, renderType));
                }
                if (!(north || south || west)) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(8).getQuads(state, side, rand, extraData, renderType));
                }
                if (north && south && !east) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(12).getQuads(state, side, rand, extraData, renderType));
                }
                if (north && south && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(11).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerNorthEast) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(14).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerSouthEast) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(13).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerNorthWest) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(16).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerSouthWest) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(15).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData, renderType));
                }
            }
            List<TextureAtlasSprite> spriteList = this.getSpriteList(state);
            List<BakedQuad> quads = this.getQuadsWithTexture(baseQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(0)));
            quads.addAll(this.getQuadsWithTexture(secondaryQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(1))));
            return quads;
        }
        return Collections.emptyList();
    }

    @Override
    public List<BakedQuad> getQuads(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        ArrayList<BakedQuad> baseQuads = new ArrayList<BakedQuad>(this.getTemplateBakedModels().get(0).getQuads(state, face, random));
        ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>();
        secondaryQuads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(8).getQuads(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(7).getQuads(state, face, random));
        List<TextureAtlasSprite> spriteList = this.getSpriteList(stack);
        List<BakedQuad> quads = this.getQuadsWithTexture(baseQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(0)));
        quads.addAll(this.getQuadsWithTexture(secondaryQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(1))));
        return quads;
    }
}

