/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.basicDesk.neoforge;

import com.unlikepaladin.pfm.blocks.BasicDeskBlock;
import com.unlikepaladin.pfm.blocks.models.neoforge.ModelBitSetProperty;
import com.unlikepaladin.pfm.blocks.models.neoforge.PFMNeoForgeBakedModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgeBasicDeskModel
extends PFMNeoForgeBakedModel {
    public static ModelProperty<ModelBitSetProperty> CONNECTIONS = new ModelProperty();

    public NeoForgeBasicDeskModel(ModelState settings, List<BakedModel> templateBakedModels) {
        super(settings, templateBakedModels);
    }

    @Override
    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        if (state.getBlock() instanceof BasicDeskBlock) {
            ModelData.Builder builder = ModelData.builder();
            ModelData data = builder.build();
            data = super.getModelData(world, pos, state, data);
            BasicDeskBlock block = (BasicDeskBlock)state.getBlock();
            boolean north = block.canConnect(world.getBlockState(pos.north()));
            boolean east = block.canConnect(world.getBlockState(pos.east()));
            boolean west = block.canConnect(world.getBlockState(pos.west()));
            boolean south = block.canConnect(world.getBlockState(pos.south()));
            BitSet set = new BitSet();
            set.set(0, north);
            set.set(1, east);
            set.set(2, west);
            set.set(3, south);
            data = data.derive().with(CONNECTIONS, (Object)new ModelBitSetProperty(set)).build();
            return data;
        }
        return tileData;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, RenderType renderLayer) {
        if (state != null && state.getBlock() instanceof BasicDeskBlock && extraData.get(CONNECTIONS) != null && ((ModelBitSetProperty)extraData.get(NeoForgeBasicDeskModel.CONNECTIONS)).connections != null) {
            ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>();
            BitSet set = ((ModelBitSetProperty)extraData.get(NeoForgeBasicDeskModel.CONNECTIONS)).connections;
            boolean north = set.get(0);
            boolean east = set.get(1);
            boolean west = set.get(2);
            boolean south = set.get(3);
            ArrayList<BakedQuad> baseQuads = new ArrayList<BakedQuad>(this.getTemplateBakedModels().get(0).getQuads(state, side, rand, extraData, renderLayer));
            if (!north && !west) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData, renderLayer));
            }
            if (!north && !east) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData, renderLayer));
            }
            if (!south && !west) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData, renderLayer));
            }
            if (!south && !east) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderLayer));
            }
            List<TextureAtlasSprite> spriteList = this.getSpriteList(state);
            List<BakedQuad> quads = this.getQuadsWithTexture(baseQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(0)));
            quads.addAll(this.getQuadsWithTexture(secondaryQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(1))));
            return quads;
        }
        return Collections.emptyList();
    }

    @Override
    public List<BakedQuad> getQuads(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        ArrayList<BakedQuad> baseQuads = new ArrayList<BakedQuad>(this.getTemplateBakedModels().get(0).getQuads(state, face, random));
        ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>();
        secondaryQuads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, face, random));
        List<TextureAtlasSprite> spriteList = this.getSpriteList(stack);
        List<BakedQuad> quads = this.getQuadsWithTexture(baseQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(0)));
        quads.addAll(this.getQuadsWithTexture(secondaryQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(1))));
        return quads;
    }
}

