/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.basicDeskCabinet.neoforge;

import com.unlikepaladin.pfm.blocks.BasicDeskCabinetBlock;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.blocks.models.neoforge.ModelBitSetProperty;
import com.unlikepaladin.pfm.blocks.models.neoforge.PFMNeoForgeBakedModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgeBasicDeskCabinetModel
extends PFMNeoForgeBakedModel {
    public static ModelProperty<ModelBitSetProperty> CONNECTIONS = new ModelProperty();
    public static ModelProperty<BlockState> NEIGHBOR_FACING = new ModelProperty();
    public static ModelProperty<BlockState> NEIGHBOR_OPPOSITE = new ModelProperty();

    public NeoForgeBasicDeskCabinetModel(ModelState settings, List<BakedModel> modelParts) {
        super(settings, modelParts);
    }

    @Override
    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        if (state.getBlock() instanceof BasicDeskCabinetBlock) {
            ModelData.Builder builder = ModelData.builder();
            ModelData data = builder.build();
            data = super.getModelData(world, pos, state, data);
            BasicDeskCabinetBlock block = (BasicDeskCabinetBlock)state.getBlock();
            boolean north = block.canConnect(world.getBlockState(pos.north()));
            boolean east = block.canConnect(world.getBlockState(pos.east()));
            boolean west = block.canConnect(world.getBlockState(pos.west()));
            boolean south = block.canConnect(world.getBlockState(pos.south()));
            Direction isFacing = (Direction)state.getValue((Property)BasicDeskCabinetBlock.FACING);
            BlockState neighborStateFacing = world.getBlockState(pos.relative(isFacing));
            BlockState neighborStateOpposite = world.getBlockState(pos.relative(isFacing.getOpposite()));
            boolean isNeighborStateOppositeFacingDifferentDirection = neighborStateOpposite.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) ? block.isDifferentOrientation((BlockGetter)world, pos, (Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) : false;
            boolean isNeighborStateFacingDifferentDirection = neighborStateFacing.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) ? block.isDifferentOrientation((BlockGetter)world, pos, ((Direction)neighborStateFacing.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite()) : false;
            BlockState rightState = world.getBlockState(pos.relative(isFacing.getCounterClockWise()));
            boolean right = block.canConnect(rightState) && rightState.getBlock() instanceof BasicDeskCabinetBlock;
            BlockState leftState = world.getBlockState(pos.relative(isFacing.getClockWise()));
            boolean left = block.canConnect(leftState) && leftState.getBlock() instanceof BasicDeskCabinetBlock;
            BitSet set = new BitSet();
            set.set(0, north);
            set.set(1, east);
            set.set(2, west);
            set.set(3, south);
            set.set(4, left);
            set.set(5, right);
            set.set(6, isNeighborStateOppositeFacingDifferentDirection);
            set.set(7, isNeighborStateFacingDifferentDirection);
            data = data.derive().with(CONNECTIONS, (Object)new ModelBitSetProperty(set)).build();
            data = data.derive().with(NEIGHBOR_FACING, (Object)neighborStateFacing).build();
            data = data.derive().with(NEIGHBOR_OPPOSITE, (Object)neighborStateOpposite).build();
            return data;
        }
        return tileData;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, RenderType renderLayer) {
        if (state != null && state.getBlock() instanceof BasicDeskCabinetBlock && extraData.get(CONNECTIONS) != null && ((ModelBitSetProperty)extraData.get(NeoForgeBasicDeskCabinetModel.CONNECTIONS)).connections != null) {
            int openOffset;
            ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>();
            BasicDeskCabinetBlock block = (BasicDeskCabinetBlock)state.getBlock();
            BitSet set = ((ModelBitSetProperty)extraData.get(NeoForgeBasicDeskCabinetModel.CONNECTIONS)).connections;
            boolean north = set.get(0);
            boolean east = set.get(1);
            boolean west = set.get(2);
            boolean south = set.get(3);
            Direction isFacing = (Direction)state.getValue((Property)BasicDeskCabinetBlock.FACING);
            switch (isFacing) {
                case SOUTH: {
                    secondaryQuads.addAll(this.legsDesk(state, side, rand, extraData, renderLayer, north, south, east, west, 18, 19, 16, 17));
                    break;
                }
                case NORTH: {
                    secondaryQuads.addAll(this.legsDesk(state, side, rand, extraData, renderLayer, north, south, east, west, 17, 16, 19, 18));
                    break;
                }
                case EAST: {
                    secondaryQuads.addAll(this.legsDesk(state, side, rand, extraData, renderLayer, north, south, east, west, 19, 17, 18, 16));
                    break;
                }
                default: {
                    secondaryQuads.addAll(this.legsDesk(state, side, rand, extraData, renderLayer, north, south, east, west, 16, 18, 17, 19));
                }
            }
            boolean left = set.get(4);
            boolean right = set.get(5);
            boolean isNeighborStateOppositeFacingDifferentDirection = set.get(6);
            boolean isNeighborStateFacingDifferentDirection = set.get(7);
            BlockState neighborStateFacing = (BlockState)extraData.get(NEIGHBOR_FACING);
            BlockState neighborStateOpposite = (BlockState)extraData.get(NEIGHBOR_OPPOSITE);
            int n = openOffset = (Boolean)state.getValue((Property)BasicDeskCabinetBlock.OPEN) != false ? 8 : 0;
            if (block.canConnect(neighborStateFacing) && neighborStateFacing.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                neighborFacing = (Direction)neighborStateFacing.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                if (neighborFacing.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() && isNeighborStateFacingDifferentDirection) {
                    if (neighborFacing == isFacing.getCounterClockWise()) {
                        secondaryQuads.addAll(this.getTemplateBakedModels().get(4 + openOffset).getQuads(state, side, rand, extraData, renderLayer));
                    } else {
                        secondaryQuads.addAll(this.getTemplateBakedModels().get(5 + openOffset).getQuads(state, side, rand, extraData, renderLayer));
                    }
                } else {
                    secondaryQuads.addAll(this.middleDesk(state, side, rand, extraData, renderLayer, left, right, openOffset));
                }
            } else if (block.canConnect(neighborStateOpposite) && neighborStateOpposite.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                neighborFacing = (Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                if (neighborFacing.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() && isNeighborStateOppositeFacingDifferentDirection) {
                    if (neighborFacing == isFacing.getCounterClockWise()) {
                        secondaryQuads.addAll(this.getTemplateBakedModels().get(6 + openOffset).getQuads(state, side, rand, extraData, renderLayer));
                    } else {
                        secondaryQuads.addAll(this.getTemplateBakedModels().get(7 + openOffset).getQuads(state, side, rand, extraData, renderLayer));
                    }
                } else {
                    secondaryQuads.addAll(this.middleDesk(state, side, rand, extraData, renderLayer, left, right, openOffset));
                }
            } else {
                secondaryQuads.addAll(this.middleDesk(state, side, rand, extraData, renderLayer, left, right, openOffset));
            }
            List<TextureAtlasSprite> spriteList = this.getSpriteList(state);
            return this.getQuadsWithTexture(secondaryQuads, ModelHelper.getOakPlankLogSprites(), spriteList);
        }
        return Collections.emptyList();
    }

    private List<BakedQuad> legsDesk(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderLayer, boolean north, boolean south, boolean west, boolean east, int northLeg, int southLeg, int westLeg, int eastLeg) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (!north && !east) {
            quads.addAll(this.getTemplateBakedModels().get(northLeg).getQuads(state, side, rand, extraData, renderLayer));
        }
        if (!north && !west) {
            quads.addAll(this.getTemplateBakedModels().get(southLeg).getQuads(state, side, rand, extraData, renderLayer));
        }
        if (!south && !west) {
            quads.addAll(this.getTemplateBakedModels().get(eastLeg).getQuads(state, side, rand, extraData, renderLayer));
        }
        if (!south && !east) {
            quads.addAll(this.getTemplateBakedModels().get(westLeg).getQuads(state, side, rand, extraData, renderLayer));
        }
        return quads;
    }

    private List<BakedQuad> middleDesk(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderLayer, boolean left, boolean right, int openOffset) {
        if (left && right) {
            return this.getTemplateBakedModels().get(3 + openOffset).getQuads(state, side, rand, extraData, renderLayer);
        }
        if (left) {
            return this.getTemplateBakedModels().get(1 + openOffset).getQuads(state, side, rand, extraData, renderLayer);
        }
        if (right) {
            return this.getTemplateBakedModels().get(2 + openOffset).getQuads(state, side, rand, extraData, renderLayer);
        }
        return this.getTemplateBakedModels().get(openOffset).getQuads(state, side, rand, extraData, renderLayer);
    }

    @Override
    public List<BakedQuad> getQuads(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        ArrayList<BakedQuad> baseQuads = new ArrayList<BakedQuad>(this.getTemplateBakedModels().get(0).getQuads(state, face, random));
        ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>();
        secondaryQuads.addAll(this.getTemplateBakedModels().get(18).getQuads(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(16).getQuads(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(17).getQuads(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(19).getQuads(state, face, random));
        List<TextureAtlasSprite> spriteList = this.getSpriteList(stack);
        List<BakedQuad> quads = this.getQuadsWithTexture(baseQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(0)));
        quads.addAll(this.getQuadsWithTexture(secondaryQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(1))));
        return quads;
    }
}

