/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.basicLamp.neoforge;

import com.unlikepaladin.pfm.blocks.BasicLampBlock;
import com.unlikepaladin.pfm.blocks.blockentities.LampBlockEntity;
import com.unlikepaladin.pfm.blocks.models.neoforge.ModelBitSetProperty;
import com.unlikepaladin.pfm.blocks.models.neoforge.PFMNeoForgeBakedModel;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.items.PFMComponents;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgeBasicLampModel
extends PFMNeoForgeBakedModel {
    public static ModelProperty<ModelBitSetProperty> CONNECTIONS = new ModelProperty();
    public static ModelProperty<WoodVariant> VARIANT = new ModelProperty();
    static List<TextureAtlasSprite> oakSprite = new ArrayList<TextureAtlasSprite>();
    Map<WoodVariant, List<TextureAtlasSprite>> sprites = new HashMap<WoodVariant, List<TextureAtlasSprite>>();

    public NeoForgeBasicLampModel(ModelState settings, List<BakedModel> modelParts) {
        super(settings, modelParts);
    }

    @Override
    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        if (state.getBlock() instanceof BasicLampBlock) {
            ModelData.Builder builder = ModelData.builder();
            ModelData data = builder.build();
            data = super.getModelData(world, pos, state, data);
            WoodVariant variant = WoodVariantRegistry.OAK;
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity instanceof LampBlockEntity) {
                variant = ((LampBlockEntity)entity).getVariant();
            }
            BitSet set = new BitSet();
            set.set(0, world.getBlockState(pos.above()).getBlock() instanceof BasicLampBlock);
            set.set(1, world.getBlockState(pos.below()).getBlock() instanceof BasicLampBlock);
            data = data.derive().with(CONNECTIONS, (Object)new ModelBitSetProperty(set)).with(VARIANT, (Object)variant).build();
            return data;
        }
        return tileData;
    }

    static List<TextureAtlasSprite> getOakStrippedLogSprite() {
        if (!oakSprite.isEmpty()) {
            return oakSprite;
        }
        TextureAtlasSprite wood = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.parse((String)"minecraft:block/stripped_oak_log")).sprite();
        oakSprite.add(wood);
        return oakSprite;
    }

    List<TextureAtlasSprite> getVariantStrippedLogSprite(WoodVariant variant) {
        if (this.sprites.containsKey(variant)) {
            return this.sprites.get(variant);
        }
        TextureAtlasSprite wood = new Material(InventoryMenu.BLOCK_ATLAS, variant.getTexture(BlockType.STRIPPED_LOG)).sprite();
        ArrayList<TextureAtlasSprite> spriteList = new ArrayList<TextureAtlasSprite>();
        spriteList.add(wood);
        this.sprites.put(variant, spriteList);
        return spriteList;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        if (state != null && extraData.get(CONNECTIONS) != null && ((ModelBitSetProperty)extraData.get(NeoForgeBasicLampModel.CONNECTIONS)).connections != null) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            int onOffset = (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 1 : 0;
            WoodVariant variant = (WoodVariant)extraData.get(VARIANT);
            TextureAtlasSprite sprite = new Material(InventoryMenu.BLOCK_ATLAS, variant.getTexture(BlockType.STRIPPED_LOG)).sprite();
            BitSet set = ((ModelBitSetProperty)extraData.get(NeoForgeBasicLampModel.CONNECTIONS)).connections;
            if (set.get(0) && set.get(1)) {
                quads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData, renderType));
            } else if (set.get(0)) {
                quads.addAll(this.getTemplateBakedModels().get(0).getQuads(state, side, rand, extraData, renderType));
            } else if (set.get(1)) {
                quads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData, renderType));
                quads.addAll(this.getTemplateBakedModels().get(5 + onOffset).getQuads(state, side, rand, extraData, renderType));
                quads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderType));
            } else {
                quads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderType));
                quads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData, renderType));
                quads.addAll(this.getTemplateBakedModels().get(5 + onOffset).getQuads(state, side, rand, extraData, renderType));
            }
            return this.getQuadsWithTexture(quads, NeoForgeBasicLampModel.getOakStrippedLogSprite(), this.getVariantStrippedLogSprite(variant));
        }
        return Collections.emptyList();
    }

    @Override
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        if (data != null && data.has(VARIANT)) {
            return this.getVariantStrippedLogSprite((WoodVariant)data.get(VARIANT)).get(0);
        }
        return super.getParticleIcon(data);
    }

    @Override
    public ItemTransforms getTransforms() {
        return this.getTemplateBakedModels().get(2).getTransforms();
    }

    @Override
    public List<BakedQuad> getQuads(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        WoodVariant variant = WoodVariantRegistry.OAK;
        if (stack.has(PFMComponents.VARIANT_COMPONENT)) {
            variant = WoodVariantRegistry.getVariant((ResourceLocation)stack.get(PFMComponents.VARIANT_COMPONENT));
        }
        quads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, face, random));
        quads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, face, random));
        quads.addAll(this.getTemplateBakedModels().get(5).getQuads(state, face, random));
        return this.getQuadsWithTexture(quads, NeoForgeBasicLampModel.getOakStrippedLogSprite(), this.getVariantStrippedLogSprite(variant));
    }
}

