/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.kitchenWallDrawer.neoforge;

import com.unlikepaladin.pfm.blocks.KitchenWallDrawerBlock;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.blocks.models.neoforge.ModelBitSetProperty;
import com.unlikepaladin.pfm.blocks.models.neoforge.PFMNeoForgeBakedModel;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgeKitchenWallDrawerModel
extends PFMNeoForgeBakedModel {
    public static ModelProperty<ModelBitSetProperty> CONNECTIONS = new ModelProperty();
    public static ModelProperty<BlockState> NEIGHBOR_FACING = new ModelProperty();
    public static ModelProperty<BlockState> NEIGHBOR_OPPOSITE = new ModelProperty();

    public NeoForgeKitchenWallDrawerModel(ModelState settings, List<BakedModel> modelParts) {
        super(settings, modelParts);
    }

    @Override
    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        if (state.getBlock() instanceof KitchenWallDrawerBlock) {
            boolean isNeighborStateFacingDifferentDirection;
            boolean isNeighborStateOppositeFacingDifferentDirection;
            ModelData.Builder builder = ModelData.builder();
            ModelData data = builder.build();
            data = super.getModelData(world, pos, state, data);
            KitchenWallDrawerBlock block = (KitchenWallDrawerBlock)state.getBlock();
            Direction direction = (Direction)state.getValue((Property)KitchenWallDrawerBlock.FACING);
            BlockState neighborStateFacing = world.getBlockState(pos.relative(direction));
            BlockState neighborStateOpposite = world.getBlockState(pos.relative(direction.getOpposite()));
            if (neighborStateOpposite.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                Direction direction3 = neighborStateOpposite.getBlock() instanceof AbstractFurnaceBlock ? ((Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite() : (Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                isNeighborStateOppositeFacingDifferentDirection = block.isDifferentOrientation(state, (BlockGetter)world, pos, direction3);
            } else {
                isNeighborStateOppositeFacingDifferentDirection = false;
            }
            if (neighborStateFacing.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                Direction direction2 = (Direction)neighborStateFacing.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                isNeighborStateFacingDifferentDirection = block.isDifferentOrientation(state, (BlockGetter)world, pos, direction2.getOpposite());
            } else {
                isNeighborStateFacingDifferentDirection = false;
            }
            BitSet set = new BitSet();
            set.set(0, isNeighborStateOppositeFacingDifferentDirection);
            set.set(1, isNeighborStateFacingDifferentDirection);
            data = data.derive().with(CONNECTIONS, (Object)new ModelBitSetProperty(set)).with(NEIGHBOR_FACING, (Object)neighborStateFacing).with(NEIGHBOR_OPPOSITE, (Object)neighborStateOpposite).build();
            return data;
        }
        return tileData;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, RenderType renderLayer) {
        if (state != null && state.getBlock() instanceof KitchenWallDrawerBlock && extraData.get(CONNECTIONS) != null && ((ModelBitSetProperty)extraData.get(NeoForgeKitchenWallDrawerModel.CONNECTIONS)).connections != null) {
            BitSet set = ((ModelBitSetProperty)extraData.get(NeoForgeKitchenWallDrawerModel.CONNECTIONS)).connections;
            Direction direction = (Direction)state.getValue((Property)KitchenWallDrawerBlock.FACING);
            KitchenWallDrawerBlock block = (KitchenWallDrawerBlock)state.getBlock();
            boolean isNeighborStateOppositeFacingDifferentDirection = set.get(0);
            boolean isNeighborStateFacingDifferentDirection = set.get(1);
            BlockState neighborStateFacing = (BlockState)extraData.get(NEIGHBOR_FACING);
            BlockState neighborStateOpposite = (BlockState)extraData.get(NEIGHBOR_OPPOSITE);
            int openOffset = (Boolean)state.getValue((Property)KitchenWallDrawerBlock.OPEN) != false ? 5 : 0;
            List<TextureAtlasSprite> spriteList = this.getSpriteList(state);
            if (block.canConnectToCounter(neighborStateFacing) && neighborStateFacing.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                Direction direction2 = (Direction)neighborStateFacing.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                if (direction2.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() && isNeighborStateFacingDifferentDirection) {
                    if (direction2 == direction.getCounterClockWise()) {
                        return this.getQuadsWithTexture(this.getTemplateBakedModels().get(3 + openOffset).getQuads(state, side, rand, extraData, renderLayer), ModelHelper.getOakPlankLogSprites(), spriteList);
                    }
                    return this.getQuadsWithTexture(this.getTemplateBakedModels().get(4 + openOffset).getQuads(state, side, rand, extraData, renderLayer), ModelHelper.getOakPlankLogSprites(), spriteList);
                }
                return this.getQuadsWithTexture(this.getTemplateBakedModels().get(openOffset).getQuads(state, side, rand, extraData, renderLayer), ModelHelper.getOakPlankLogSprites(), spriteList);
            }
            if (block.canConnectToCounter(neighborStateOpposite) && neighborStateOpposite.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                Direction direction3 = neighborStateOpposite.getBlock() instanceof AbstractFurnaceBlock ? ((Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite() : (Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                if (direction3.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() && isNeighborStateOppositeFacingDifferentDirection) {
                    if (direction3 == direction.getCounterClockWise()) {
                        return this.getQuadsWithTexture(this.getTemplateBakedModels().get(2 + openOffset).getQuads(state, side, rand, extraData, renderLayer), ModelHelper.getOakPlankLogSprites(), spriteList);
                    }
                    return this.getQuadsWithTexture(this.getTemplateBakedModels().get(1 + openOffset).getQuads(state, side, rand, extraData, renderLayer), ModelHelper.getOakPlankLogSprites(), spriteList);
                }
                return this.getQuadsWithTexture(this.getTemplateBakedModels().get(openOffset).getQuads(state, side, rand, extraData, renderLayer), ModelHelper.getOakPlankLogSprites(), spriteList);
            }
            return this.getQuadsWithTexture(this.getTemplateBakedModels().get(openOffset).getQuads(state, side, rand, extraData, renderLayer), ModelHelper.getOakPlankLogSprites(), spriteList);
        }
        return Collections.emptyList();
    }

    @Override
    public List<BakedQuad> getQuads(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        List<TextureAtlasSprite> spriteList = this.getSpriteList(state);
        return this.getQuadsWithTexture(this.getTemplateBakedModels().get(0).getQuads(state, face, random), ModelHelper.getOakPlankLogSprites(), spriteList);
    }
}

