/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.logTable.neoforge;

import com.unlikepaladin.pfm.blocks.LogTableBlock;
import com.unlikepaladin.pfm.blocks.models.neoforge.ModelBitSetProperty;
import com.unlikepaladin.pfm.blocks.models.neoforge.PFMNeoForgeBakedModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgeLogTableModel
extends PFMNeoForgeBakedModel {
    public static ModelProperty<ModelBitSetProperty> CONNECTIONS = new ModelProperty();

    public NeoForgeLogTableModel(ModelState settings, List<BakedModel> modelParts) {
        super(settings, modelParts);
    }

    @Override
    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        if (state.getBlock() instanceof LogTableBlock) {
            ModelData.Builder builder = ModelData.builder();
            ModelData data = builder.build();
            data = super.getModelData(world, pos, state, data);
            LogTableBlock block = (LogTableBlock)state.getBlock();
            Direction dir = (Direction)state.getValue((Property)LogTableBlock.FACING);
            boolean left = block.isTable((BlockGetter)world, pos, dir.getCounterClockWise(), dir);
            boolean right = block.isTable((BlockGetter)world, pos, dir.getClockWise(), dir);
            BitSet set = new BitSet();
            set.set(0, left);
            set.set(1, right);
            data = data.derive().with(CONNECTIONS, (Object)new ModelBitSetProperty(set)).build();
            return data;
        }
        return tileData;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, RenderType renderLayer) {
        if (state != null && state.getBlock() instanceof LogTableBlock && extraData.get(CONNECTIONS) != null && ((ModelBitSetProperty)extraData.get(NeoForgeLogTableModel.CONNECTIONS)).connections != null) {
            int index;
            ArrayList<BakedQuad> baseQuads = new ArrayList<BakedQuad>();
            ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>();
            BitSet set = ((ModelBitSetProperty)extraData.get(NeoForgeLogTableModel.CONNECTIONS)).connections;
            boolean left = set.get(0);
            boolean right = set.get(1);
            Direction dir = (Direction)state.getValue((Property)LogTableBlock.FACING);
            baseQuads.addAll(this.getTemplateBakedModels().get(0).getQuads(state, side, rand, extraData, renderLayer));
            if (!left && right) {
                index = dir == Direction.NORTH || dir == Direction.WEST ? 1 : 2;
                secondaryQuads.addAll(this.getTemplateBakedModels().get(index).getQuads(state, side, rand, extraData, renderLayer));
            }
            if (!right && left) {
                index = dir == Direction.NORTH || dir == Direction.WEST ? 2 : 1;
                secondaryQuads.addAll(this.getTemplateBakedModels().get(index).getQuads(state, side, rand, extraData, renderLayer));
            }
            if (!right && !left) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData, renderLayer));
            }
            List<TextureAtlasSprite> spriteList = this.getSpriteList(state);
            List<BakedQuad> quads = this.getQuadsWithTexture(baseQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(0)));
            quads.addAll(this.getQuadsWithTexture(secondaryQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(1))));
            return quads;
        }
        return Collections.emptyList();
    }

    @Override
    public List<BakedQuad> getQuads(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        ArrayList<BakedQuad> baseQuads = new ArrayList<BakedQuad>(this.getTemplateBakedModels().get(0).getQuads(state, face, random));
        ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>(this.getTemplateBakedModels().get(3).getQuads(state, face, random));
        List<TextureAtlasSprite> spriteList = this.getSpriteList(stack);
        List<BakedQuad> quads = this.getQuadsWithTexture(baseQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(0)));
        quads.addAll(this.getQuadsWithTexture(secondaryQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(1))));
        return quads;
    }
}

