/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.SimpleBedBlock;
import com.unlikepaladin.pfm.blocks.blockentities.PFMBedBlockEntity;
import com.unlikepaladin.pfm.blocks.models.basicLamp.UnbakedBasicLampModel;
import com.unlikepaladin.pfm.blocks.models.bed.UnbakedBedModel;
import com.unlikepaladin.pfm.client.PFMBakedModelManagerAccessor;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PFMItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private final PFMBedBlockEntity renderBed;
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    static Map<WoodVariant, Map<String, BakedModel>> bakedModels = new LinkedHashMap<WoodVariant, Map<String, BakedModel>>();
    static List<String> modelParts = new ArrayList<String>();
    public static Map<Boolean, BakedModel> bedModel = new HashMap<Boolean, BakedModel>();

    public PFMItemRenderer(BlockEntityRenderDispatcher blockEntityRenderDispatcher, EntityModelSet loader) {
        super(blockEntityRenderDispatcher, loader);
        this.blockEntityRenderDispatcher = blockEntityRenderDispatcher;
        this.renderBed = PaladinFurnitureMod.furnitureEntryMap.get(SimpleBedBlock.class) != null ? new PFMBedBlockEntity(BlockPos.ZERO, ((Block)PaladinFurnitureMod.furnitureEntryMap.get(SimpleBedBlock.class).getVariantToBlockMapList().get(WoodVariantRegistry.OAK).iterator().next()).defaultBlockState()) : null;
    }

    public BakedModel getLampPartFromVariant(WoodVariant variantBase, int index) {
        if (!bakedModels.isEmpty() && !modelParts.isEmpty()) {
            return bakedModels.get(variantBase).get(modelParts.get(index));
        }
        modelParts.clear();
        bakedModels.clear();
        modelParts.addAll(UnbakedBasicLampModel.MODEL_PARTS_BASE);
        modelParts.addAll(UnbakedBasicLampModel.STATIC_PARTS);
        for (WoodVariant woodVariant : WoodVariantRegistry.getVariants()) {
            bakedModels.put(woodVariant, new LinkedHashMap());
            for (String part : modelParts) {
                bakedModels.get(woodVariant).put(part, ((PFMBakedModelManagerAccessor)Minecraft.getInstance().getModelManager()).pfm$getModelFromNormalID(ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)part.replaceAll("template", woodVariant.getSerializedName()))));
            }
        }
        return bakedModels.get(variantBase).get(modelParts.get(index));
    }

    public BakedModel getBedModel(boolean classic) {
        if (bedModel.containsKey(classic) && bedModel.get(classic) != null) {
            return bedModel.get(classic);
        }
        bedModel.put(classic, classic ? (BakedModel)UnbakedBedModel.inventoryModels.getB() : (BakedModel)UnbakedBedModel.inventoryModels.getA());
        return bedModel.get(classic);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext mode, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        boolean glint = stack.hasFoil();
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        boolean leftHanded = Minecraft.getInstance().player != null && Minecraft.getInstance().player.getMainArm() == HumanoidArm.LEFT && mode.firstPerson();
        VertexConsumer consumer = ItemRenderer.getFoilBuffer((MultiBufferSource)vertexConsumers, (RenderType)ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)true), (boolean)true, (boolean)glint);
        if (stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock() instanceof SimpleBedBlock) {
            matrices.pushPose();
            Block block = ((BlockItem)stack.getItem()).getBlock();
            BakedModel bedModel = this.getBedModel(stack.getItem().getDescriptionId().contains("classic"));
            bedModel.getTransforms().getTransform(mode).apply(leftHanded, matrices);
            matrices.translate(-0.5, -0.5, -0.5);
            this.renderBed.setColor(((SimpleBedBlock)block).getColor());
            this.blockEntityRenderDispatcher.renderItem((BlockEntity)this.renderBed, matrices, vertexConsumers, light, overlay);
            matrices.popPose();
        }
    }
}

