/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client;

import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class PathPackRPWrapper
implements PackResources {
    private final Supplier<PackResources> delegate;
    private final PackMetadataSection packResourceMetadata;
    private final PackLocationInfo resourcePackInfo;

    public PathPackRPWrapper(Supplier<PackResources> delegate, PackMetadataSection packResourceMetadata, PackLocationInfo packInfo) {
        this.delegate = delegate;
        this.packResourceMetadata = packResourceMetadata;
        this.resourcePackInfo = packInfo;
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... segments) {
        if (PFMRuntimeResources.ready && Arrays.asList(segments).contains("pack.png")) {
            return this.delegate.get().getRootResource(segments);
        }
        return () -> null;
    }

    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation id) {
        if (PFMRuntimeResources.ready) {
            return this.delegate.get().getResource(type, id);
        }
        return () -> null;
    }

    public void listResources(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        if (PFMRuntimeResources.ready) {
            this.delegate.get().listResources(type, namespace, prefix, consumer);
        }
    }

    public Set<String> getNamespaces(PackType type) {
        if (PFMRuntimeResources.ready) {
            return this.delegate.get().getNamespaces(type);
        }
        return Set.of("pfm");
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> metaReader) throws IOException {
        if (metaReader.getMetadataSectionName().equals("pack")) {
            return (T)this.packResourceMetadata;
        }
        if (PFMRuntimeResources.ready) {
            return (T)this.delegate.get().getMetadataSection(metaReader);
        }
        return null;
    }

    public String getName() {
        return "PFM-Runtime-RP";
    }

    public PackLocationInfo location() {
        return this.resourcePackInfo;
    }

    public void close() {
        if (PFMRuntimeResources.ready) {
            this.delegate.get().close();
        }
    }
}

