/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.unlikepaladin.pfm.blocks.blockentities.MicrowaveBlockEntity;
import com.unlikepaladin.pfm.menus.AbstractMicrowaveScreenHandler;
import com.unlikepaladin.pfm.menus.MicrowaveScreenHandler;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.Level;

public class MicrowaveScreen
extends AbstractContainerScreen<MicrowaveScreenHandler> {
    private final ResourceLocation background = ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)"textures/gui/container/microwave.png");
    private boolean narrow;
    public boolean isActive;
    private MicrowaveBlockEntity microwaveBlockEntity;
    private final Component startButtonText = Component.translatable((String)"gui.pfm.microwave.start_button");
    public Button startButton;

    public MicrowaveScreen(MicrowaveScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    public void init() {
        super.init();
        this.microwaveBlockEntity = ((MicrowaveScreenHandler)this.menu).microwaveBlockEntity;
        this.isActive = ((MicrowaveScreenHandler)this.menu).getActive();
        this.narrow = this.width < 379;
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.startButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder(this.startButtonText, button -> AbstractMicrowaveScreenHandler.setActive(this.microwaveBlockEntity, true)).pos(this.leftPos + 8, this.topPos + 40).size(40, 20).build());
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.narrow) {
            this.renderBackground(context, mouseX, mouseY, delta);
        } else {
            super.render(context, mouseX, mouseY, delta);
        }
        this.renderTooltip(context, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.background);
        int i = this.leftPos;
        int j = this.topPos;
        context.blit(this.background, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int k = ((MicrowaveScreenHandler)this.menu).getCookProgress();
        k = Math.round((float)k * 1.75f);
        context.blit(this.background, i + 147, j + 66 + -k, 176, 40 - k, 13, k + 1);
    }

    public Optional<RecipeHolder<SmokingRecipe>> getRecipe(Level world, Container inventory) {
        return world.getRecipeManager().getRecipeFor(RecipeType.SMOKING, (RecipeInput)new SingleRecipeInput(inventory.getItem(0)), world);
    }

    protected void containerTick() {
        super.containerTick();
        this.isActive = ((MicrowaveScreenHandler)this.menu).isActive;
        NonNullList inventory = NonNullList.withSize((int)1, (Object)((MicrowaveScreenHandler)this.menu).getInventory().getItem(0));
        Optional<RecipeHolder<SmokingRecipe>> recipe = this.getRecipe(((MicrowaveScreenHandler)this.menu).microwaveBlockEntity.getLevel(), ((MicrowaveScreenHandler)this.menu).getInventory());
        this.startButton.active = recipe.isEmpty() || !MicrowaveBlockEntity.canAcceptRecipeOutput(this.microwaveBlockEntity.getLevel().registryAccess(), recipe.map(RecipeHolder::value).orElse(null), (NonNullList<ItemStack>)inventory, this.microwaveBlockEntity.getMaxStackSize()) && !((MicrowaveScreenHandler)this.menu).isActive() ? false : !((MicrowaveScreenHandler)this.menu).isActive();
    }
}

