/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client.screens.overlay;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL32;

public class GLText {
    public static final String GLT_NAME = "glText";
    public static final int GLT_VERSION_MAJOR = 1;
    public static final int GLT_VERSION_MINOR = 1;
    public static final int GLT_VERSION_PATCH = 6;
    public static final String GLT_VERSION = "1.1.6";
    public static final String GLT_NAME_VERSION = "glText 1.1.6";
    public static final int GLT_NULL = 0;
    public static final int GLT_NULL_HANDLE = 0;
    public static final int GLT_LEFT = 0;
    public static final int GLT_TOP = 0;
    public static final int GLT_CENTER = 1;
    public static final int GLT_RIGHT = 2;
    public static final int GLT_BOTTOM = 2;
    private static final int NULL = 0;
    private static final int _GLT_TEXT2D_POSITION_LOCATION = 0;
    private static final int _GLT_TEXT2D_TEXCOORD_LOCATION = 1;
    private static final int _GLT_TEXT2D_POSITION_SIZE = 2;
    private static final int _GLT_TEXT2D_TEXCOORD_SIZE = 2;
    private static final int _GLT_TEXT2D_VERTEX_SIZE = 4;
    private static final int _GLT_TEXT2D_POSITION_OFFSET = 0;
    private static final int _GLT_TEXT2D_TEXCOORD_OFFSET = 2;
    private static final String _gltFontGlyphCharacters = " abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.,!?-+/():;%&`*#=[]\"";
    private static final int _gltFontGlyphCount = 83;
    private static final char _gltFontGlyphMinChar = ' ';
    private static final char _gltFontGlyphMaxChar = 'z';
    private static final int _gltFontGlyphHeight = 17;
    private _GLTglyph[] _gltFontGlyphs = new _GLTglyph[83];
    private _GLTglyph[] _gltFontGlyphs2 = new _GLTglyph[91];
    private int _gltText2DShader = 0;
    private int _gltText2DFontTexture = 0;
    private int _gltText2DShaderMVPUniformLocation = -1;
    private int _gltText2DShaderColorUniformLocation = -1;
    private float[] _gltText2DProjectionMatrix = new float[16];
    private static final String _gltText2DVertexShaderSource = "#version 150 core\n\nin vec2 position;\nin vec2 texCoord;\n\nuniform mat4 mvp;\n\nout vec2 fTexCoord;\n\nvoid main()\n{\n    fTexCoord = texCoord;\n\n    gl_Position = mvp * vec4(position, 0.0, 1.0);\n}\n";
    private static final String _gltText2DFragmentShaderSource = "#version 150 core\n\nout vec4 fragColor;\n\nuniform sampler2D diffuse;\n\nuniform vec4 color;\n\nin vec2 fTexCoord;\n\nvoid main()\n{\n    vec4 outColor = texture(diffuse, fTexCoord) * color;\n    if (outColor.a < 0.01)\n        discard;\n    fragColor = outColor;\n}\n";
    private static final long[] _gltFontGlyphRects = new long[]{0x1100040000L, 12952600580L, 12919046157L, 12952600598L, 12919046175L, 12952600616L, 12919046193L, 67698746L, 12919046211L, 12902269004L, 17301589L, 12919046237L, 12919046246L, 12952666223L, 12952600697L, 12952600706L, 67698827L, 0x4090094L, 12952600733L, 12952600742L, 12919046319L, 12952600760L, 12952600769L, 12952666314L, 12952600788L, 67764445L, 12952600807L, 12919046384L, 12919046393L, 12919046402L, 12919046411L, 12919046420L, 12919046429L, 12919046438L, 12919046447L, 12918915384L, 12919046463L, 12919046472L, 12919046481L, 12919112026L, 12919112036L, 12919046510L, 12919046519L, 4329111936L, 12919046537L, 12919046546L, 12919046555L, 12919046564L, 12919046573L, 12919112118L, 12919046592L, 12919046601L, 12919046610L, 12919046619L, 12919046628L, 12919046637L, 12919046646L, 12919112191L, 12919046665L, 12919046674L, 12919046683L, 12919046692L, 12919046701L, 13036290614L, 4446356028L, 12918915650L, 12919046729L, 30166024786L, 21542535771L, 8624079460L, 4328981101L, 4328981108L, 12952404603L, 4362470017L, 8607433351L, 12919112338L, 47245099676L, 21542601386L, 12919112372L, 25854280382L, 34013895L, 34013902L, 47262008021L};
    private static final int _GLT_FONT_PIXEL_SIZE_BITS = 2;
    private static final int _gltFontGlyphDataCount = 387;
    private static final long[] _gltFontGlyphData = Arrays.copyOf(new long[]{6131252050904749396L, 6239338872445773146L, 384307082302872233L, -7968376178815772096L, -6510681785085831530L, 5860684320805918357L, 7595627162738442581L, 7572057671064704421L, 1536876828821198185L, -6244639706965846784L, 6239338872445692250L, 6144504825312270938L, -7968393771348569067L, 6171456139979019926L, 4635703847754749589L, 6171157054209982805L, -6531721094702475631L, 101612854302904661L, -6249495174183910060L, 6239338872445692250L, -7690553229969892774L, 4995993209514120534L, 6171058939889010005L, -6527570348114335088L, 7595701590583317925L, -8070076606669564587L, 408210550906568726L, -6628901726276544875L, 1537229039206831365L, 6503297093203940693L, 6507800779894838612L, 6503297094361569856L, 6148916151609285184L, 6237491685846488404L, -7680425817345992123L, -6510681786222488214L, -6627797451617774251L, 1625805671732170842L, -7708574861211182528L, 6148844322497930326L, -7663322169852537515L, 7591492914814474854L, 1532725073265726886L, 6239334220973823317L, -7595983066633774502L, 4995988788583488086L, -6510681786221510315L, -7680491852720073067L, 1537158298696238442L, 7591479449826192036L, 6244899038058358121L, 6142934705196324201L, 6244893260158948352L, -7595983066633774502L, 406820859829443158L, 5764982458013456021L, -6527288873137646251L, 101613954082968918L, 6052931358031873444L, 6150322071494366293L, -6172582044186420571L, 5982809203496278L, 6509296459222155625L, 4618036821821319445L, 6125270771807094106L, -6527570348114356907L, 7595701590583317925L, 6148913316845955733L, 6510611416073217109L, -6551142798112495255L, 1532719574197555285L, -7663321878935263895L, -6604922110837433754L, 6147788768781092201L, 5001974616119990853L, -6510681786221505175L, 0x4155545555155555L, -6603866648407156134L, -6249406782597610075L, 6244546158172655702L, 4995987414171604305L, 7585584945755937450L, 6172926926006872405L, 6507707304137528661L, -6527570348114335152L, 7595701590584628645L, 0x555555155555A5A5L, 6510611416002241557L, 6509555879894149481L, 1537228764346935642L, -7597173912151780011L, -7686055402779551146L, 7680160640758596950L, -6627797726512458427L, 7595701590299152474L, 7591479449826469285L, 0x5550555555AA55AL, 6509204037246932309L, 4996340723819571541L, 6149008489028588890L, -7662131129606646507L, 7684290406348641622L, -6628901636082936175L, 1536853737913798661L, 7591479449826192020L, 6510611484787451221L, 6058842631399893353L, 6239338872427599189L, -7595977569075635622L, 6171520736538810966L, 6172822472070862165L, 6503594809852596570L, 5860684679893816976L, 1625805667419095125L, -7686056863074330048L, 5001974616119990870L, -6510985337352481451L, -6531792488870013291L, 7595627098386370906L, 0x555555155555A5A5L, 25403213553705984L, 6503222669748732265L, 1537229039206754560L, 7591475304071517525L, 7391997334820394405L, -6527586856972424870L, 6130882700541318805L, -7663603354180692907L, 7591563283562846810L, 6239074730697463209L, 1536946922686076250L, 7591479449826192020L, 6510611416073217385L, 6058842630326151529L, 6239334220973823253L, 6239010117462350426L, 5766195223882717781L, 7679786715100545045L, -6527570348113226095L, 7595701590583317925L, 25425199847795349L, 1633189649634558293L, -6172580669791311511L, 6239338872444709206L, 6144411074429278810L, 6149002738397522241L, -6533497859669158566L, 4707761716670666389L, 6238992546145849685L, -8068862831400494511L, 406451416859295766L, 6504699040318362960L, 6239338872445692250L, -7595983066633774502L, 5860662324835559766L, -6510681785085835947L, -6527570348113226091L, 6147507658882176421L, -7663603650822908672L, 7591492914797697622L, -7330336659568421466L, 6147436947274572886L, -7680491852721203887L, 6513636234834298214L, 6150327569067910564L, 6510592444123664725L, -6244638263829239447L, 101613953747424342L, 6147506950206653860L, 406820854192319045L, 6171151557999269285L, 5860684337984657040L, 7595627162738443605L, -6243578605187257947L, 6244617563081713001L, -7781846316417460908L, 406820859812680982L, -6628901726277593451L, 4707387876656451589L, -6510681786221510315L, -7685792614471789227L, 6148920553598521686L, 7572425921538643281L, 6243421289061918057L, -6244638263829239467L, 5982808935060566L, 4713478827915871652L, -6262652680525244774L, 5766130708868584874L, 6533110442193322005L, -6178562014388595351L, 6171433032904955158L, 0x55005550555555AAL, -7974022990640274431L, -6510681785085835862L, 4707761716670666389L, 7590072434356998485L, -7776128768715429551L, 101613953730646102L, -6250621074090752684L, 6240464772352534806L, -7595983066616998231L, 4707740820228712790L, -6510681786221510315L, 5866683272084756117L, 1536877188793058665L, 6150392794567431488L, 6509295042884359493L, 1626948735719527785L, -6604927518482213207L, 383956677478667541L, 7595627162738442580L, -8046343646840773211L, 406451416858968150L, -6177437510356953776L, 23931237015311706L, 7590160369806804388L, 23925464562509077L, 7566444574072112464L, -8046080863582706427L, 389844329899380822L, 7584435606801876308L, -6604931986322270575L, 1625898766638868741L, 7566422668314154644L, 1625898766638868801L, 7590153454822688164L, -6605301449078057323L, 7657620565331896918L, 6243208808367478437L, -6527328477118114454L, 6126392295058401622L, 7567570901985284097L, 4636056974602618266L, 4713695414465074537L, 1560867095104809382L, 4617685320014845248L, -7775858100872673879L, 6509576834682339674L, 6147811142344746330L, 7585654987747054613L, 1537158213869332801L, 6244984525349562000L, 4635704942925010597L, 7585652285138863445L, -6444270183318379430L, 6514833626869950805L, 4995970096881313425L, -6154919490381867691L, -6263005881813346986L, 4713304692700306006L, 6503594809848402010L, 6148844322581403280L, 7567636265279595605L, 4713304687331269185L, 6148938057200865370L, -6510681786243787436L, 0x5555155555L}, 387);

    public GLText() {
        this.gltInit();
    }

    private static int _GLT_MAT4_INDEX(int row, int column) {
        return row + column * 4;
    }

    public static GLTtext gltCreateText() {
        GLTtext text = new GLTtext();
        text._vao = GL32.glGenVertexArrays();
        text._vbo = GL32.glGenBuffers();
        assert (text._vao != 0);
        assert (text._vbo != 0);
        if (text._vao == 0 || text._vbo == 0) {
            GLText.gltDeleteText(text);
            return null;
        }
        GL32.glBindVertexArray((int)text._vao);
        GL32.glBindBuffer((int)34962, (int)text._vbo);
        GL32.glEnableVertexAttribArray((int)0);
        GL32.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)16, (long)0L);
        GL32.glEnableVertexAttribArray((int)1);
        GL32.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)16, (long)8L);
        GL32.glBindBuffer((int)34962, (int)0);
        GL32.glBindVertexArray((int)0);
        return text;
    }

    public static void gltDeleteText(GLTtext text) {
        if (text == null) {
            return;
        }
        if (text._vao != 0) {
            GL32.glDeleteVertexArrays((int)text._vao);
            text._vao = 0;
        }
        if (text._vbo != 0) {
            GL32.glDeleteBuffers((int)text._vbo);
            text._vbo = 0;
        }
        if (text._text != null) {
            text._text = null;
        }
        if (text._vertices != null) {
            text._vertices = null;
        }
        text = null;
    }

    public static boolean gltSetText(GLTtext text, String string) {
        if (text == null) {
            return false;
        }
        int strLength = 0;
        if (string != null) {
            strLength = string.length();
        }
        if (strLength > 0) {
            if (text._text != null) {
                if (string.equals(text._text)) {
                    return true;
                }
                text._text = null;
            }
            text._text = string;
            text._textLength = strLength;
            text._dirty = true;
            return true;
        }
        if (text._text == null) {
            return true;
        }
        text._text = null;
        text._textLength = 0;
        text._dirty = true;
        return true;
    }

    public static String gltGetText(GLTtext text) {
        if (text != null && text._text != null) {
            return text._text;
        }
        return "";
    }

    public void gltViewport(int width, int height) {
        assert (width > 0);
        assert (height > 0);
        float left = 0.0f;
        float right = width;
        float bottom = height;
        float top = 0.0f;
        float zNear = -1.0f;
        float zFar = 1.0f;
        float[] projection = new float[]{2.0f / (right - 0.0f), 0.0f, 0.0f, 0.0f, 0.0f, 2.0f / (0.0f - bottom), 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, -((right + 0.0f) / (right - 0.0f)), -((0.0f + bottom) / (0.0f - bottom)), -0.0f, 1.0f};
        System.arraycopy(projection, 0, this._gltText2DProjectionMatrix, 0, 16);
    }

    public Closeable gltBeginDraw() {
        GL32.glUseProgram((int)this._gltText2DShader);
        GL32.glActiveTexture((int)33984);
        GL32.glBindTexture((int)3553, (int)this._gltText2DFontTexture);
        return () -> {
            GL32.glUseProgram((int)0);
            GL32.glBindTexture((int)3553, (int)0);
        };
    }

    public void gltDrawText(GLTtext text, float[] mvp) {
        if (text == null) {
            return;
        }
        if (text._dirty) {
            this._gltUpdateBuffers(text);
        }
        if (text.vertexCount == 0) {
            return;
        }
        GL32.glUniformMatrix4fv((int)this._gltText2DShaderMVPUniformLocation, (boolean)false, (float[])mvp);
        GL32.glBindVertexArray((int)text._vao);
        GL32.glDrawArrays((int)4, (int)0, (int)text.vertexCount);
        GL32.glBindVertexArray((int)0);
    }

    public void gltDrawText2D(GLTtext text, float x, float y, float scale) {
        if (text == null) {
            return;
        }
        if (text._dirty) {
            this._gltUpdateBuffers(text);
        }
        if (text.vertexCount == 0) {
            return;
        }
        float[] model = new float[]{scale, 0.0f, 0.0f, 0.0f, 0.0f, scale, 0.0f, 0.0f, 0.0f, 0.0f, scale, 0.0f, x, y, 0.0f, 1.0f};
        float[] mvp = new float[16];
        GLText._gltMat4Mult(this._gltText2DProjectionMatrix, model, mvp);
        GL32.glUniformMatrix4fv((int)this._gltText2DShaderMVPUniformLocation, (boolean)false, (float[])mvp);
        GL32.glBindVertexArray((int)text._vao);
        GL32.glDrawArrays((int)4, (int)0, (int)text.vertexCount);
        GL32.glBindVertexArray((int)0);
    }

    public void gltDrawText2DAligned(GLTtext text, float x, float y, float scale, int horizontalAlignment, int verticalAlignment) {
        if (text == null) {
            return;
        }
        if (text._dirty) {
            this._gltUpdateBuffers(text);
        }
        if (text.vertexCount == 0) {
            return;
        }
        if (horizontalAlignment == 1) {
            x -= this.gltGetTextWidth(text, scale) * 0.5f;
        } else if (horizontalAlignment == 2) {
            x -= this.gltGetTextWidth(text, scale);
        }
        if (verticalAlignment == 1) {
            y -= GLText.gltGetTextHeight(text, scale) * 0.5f;
        } else if (verticalAlignment == 2) {
            y -= GLText.gltGetTextHeight(text, scale);
        }
        this.gltDrawText2D(text, x, y, scale);
    }

    public void gltDrawText3D(GLTtext text, float x, float y, float z, float scale, float[] view, float[] projection) {
        if (text == null) {
            return;
        }
        if (text._dirty) {
            this._gltUpdateBuffers(text);
        }
        if (text.vertexCount == 0) {
            return;
        }
        float[] model = new float[]{scale, 0.0f, 0.0f, 0.0f, 0.0f, -scale, 0.0f, 0.0f, 0.0f, 0.0f, scale, 0.0f, x, y + 17.0f * scale, z, 1.0f};
        float[] mvp = new float[16];
        float[] vp = new float[16];
        GLText._gltMat4Mult(projection, view, vp);
        GLText._gltMat4Mult(vp, model, mvp);
        GL32.glUniformMatrix4fv((int)this._gltText2DShaderMVPUniformLocation, (boolean)false, (float[])mvp);
        GL32.glBindVertexArray((int)text._vao);
        GL32.glDrawArrays((int)4, (int)0, (int)text.vertexCount);
        GL32.glBindVertexArray((int)0);
    }

    public void gltColor(float r, float g, float b, float a) {
        GL32.glUniform4f((int)this._gltText2DShaderColorUniformLocation, (float)r, (float)g, (float)b, (float)a);
    }

    public Vector4f gltGetColor() {
        float[] color = new float[4];
        GL32.glGetUniformfv((int)this._gltText2DShader, (int)this._gltText2DShaderColorUniformLocation, (float[])color);
        return new Vector4f(color[0], color[1], color[2], color[3]);
    }

    public static float gltGetLineHeight(float scale) {
        return 17.0f * scale;
    }

    public float gltGetTextWidth(GLTtext text, float scale) {
        if (text == null) {
            return 0.0f;
        }
        float maxWidth = 0.0f;
        float width = 0.0f;
        for (int i = 0; i < text._textLength; ++i) {
            char c = text._text.charAt(i);
            if (c == '\n' || c == '\r') {
                if (width > maxWidth) {
                    maxWidth = width;
                }
                width = 0.0f;
                continue;
            }
            if (!GLText.gltIsCharacterSupported(c) && !GLText.gltIsCharacterSupported(c = ' ')) continue;
            _GLTglyph glyph = this._gltFontGlyphs2[c - 32];
            width += (float)glyph.w;
        }
        if (width > maxWidth) {
            maxWidth = width;
        }
        return maxWidth * scale;
    }

    public static float gltGetTextHeight(GLTtext text, float scale) {
        if (text == null || text._text == null) {
            return 0.0f;
        }
        return (float)(GLText.gltCountNewLines(text) + 1) * GLText.gltGetLineHeight(scale);
    }

    public static boolean gltIsCharacterSupported(char c) {
        if (c == '\t') {
            return true;
        }
        if (c == '\n') {
            return true;
        }
        if (c == '\r') {
            return true;
        }
        for (int i = 0; i < 83; ++i) {
            if (_gltFontGlyphCharacters.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static int gltCountSupportedCharacters(String str) {
        if (str == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (!GLText.gltIsCharacterSupported(str.charAt(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean gltIsCharacterDrawable(char c) {
        if (c < ' ') {
            return false;
        }
        if (c > 'z') {
            return false;
        }
        return this._gltFontGlyphs2[c - 32].drawable;
    }

    public int gltCountDrawableCharacters(String str) {
        if (str == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (!this.gltIsCharacterDrawable(str.charAt(i))) continue;
            ++count;
        }
        return count;
    }

    public static int gltCountNewLines(GLTtext text) {
        int count = 0;
        for (int i = 0; i < text._text.length(); ++i) {
            if (text._text.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    public static void _gltGetViewportSize(int[] width, int[] height) {
        int[] dimensions = new int[4];
        GL32.glGetIntegerv((int)2978, (int[])dimensions);
        if (width != null) {
            width[0] = dimensions[2];
        }
        if (height != null) {
            height[0] = dimensions[3];
        }
    }

    public static void _gltMat4Mult(float[] lhs, float[] rhs, float[] result) {
        for (int c = 0; c < 4; ++c) {
            for (int r = 0; r < 4; ++r) {
                result[GLText._GLT_MAT4_INDEX((int)r, (int)c)] = 0.0f;
                for (int i = 0; i < 4; ++i) {
                    int n = GLText._GLT_MAT4_INDEX(r, c);
                    result[n] = result[n] + lhs[GLText._GLT_MAT4_INDEX(r, i)] * rhs[GLText._GLT_MAT4_INDEX(i, c)];
                }
            }
        }
    }

    public void _gltUpdateBuffers(GLTtext text) {
        if (text == null || !text._dirty) {
            return;
        }
        if (text._vertices != null) {
            text.vertexCount = 0;
            text._vertices = null;
        }
        if (text._text == null || text._textLength == 0) {
            text._dirty = false;
            return;
        }
        int countDrawable = this.gltCountDrawableCharacters(text._text);
        if (countDrawable == 0) {
            text._dirty = false;
            return;
        }
        int vertexCount = countDrawable * 2 * 3;
        int vertexSize = 4;
        float[] vertices = new float[vertexCount * vertexSize];
        if (vertices == null) {
            return;
        }
        int vertexElementIndex = 0;
        float glyphX = 0.0f;
        float glyphY = 0.0f;
        float glyphHeight = 17.0f;
        float glyphAdvanceX = 0.0f;
        float glyphAdvanceY = 0.0f;
        for (int i = 0; i < text._textLength; ++i) {
            char c = text._text.charAt(i);
            if (c == '\n') {
                glyphX = 0.0f;
                glyphY += glyphHeight + glyphAdvanceY;
                continue;
            }
            if (c == '\r') {
                glyphX = 0.0f;
                continue;
            }
            if (!GLText.gltIsCharacterSupported(c) && !GLText.gltIsCharacterSupported(c = ' ')) continue;
            _GLTglyph glyph = this._gltFontGlyphs2[c - 32];
            float glyphWidth = glyph.w;
            if (glyph.drawable) {
                vertices[vertexElementIndex++] = glyphX;
                vertices[vertexElementIndex++] = glyphY;
                vertices[vertexElementIndex++] = glyph.u1;
                vertices[vertexElementIndex++] = glyph.v1;
                vertices[vertexElementIndex++] = glyphX + glyphWidth;
                vertices[vertexElementIndex++] = glyphY + glyphHeight;
                vertices[vertexElementIndex++] = glyph.u2;
                vertices[vertexElementIndex++] = glyph.v2;
                vertices[vertexElementIndex++] = glyphX + glyphWidth;
                vertices[vertexElementIndex++] = glyphY;
                vertices[vertexElementIndex++] = glyph.u2;
                vertices[vertexElementIndex++] = glyph.v1;
                vertices[vertexElementIndex++] = glyphX;
                vertices[vertexElementIndex++] = glyphY;
                vertices[vertexElementIndex++] = glyph.u1;
                vertices[vertexElementIndex++] = glyph.v1;
                vertices[vertexElementIndex++] = glyphX;
                vertices[vertexElementIndex++] = glyphY + glyphHeight;
                vertices[vertexElementIndex++] = glyph.u1;
                vertices[vertexElementIndex++] = glyph.v2;
                vertices[vertexElementIndex++] = glyphX + glyphWidth;
                vertices[vertexElementIndex++] = glyphY + glyphHeight;
                vertices[vertexElementIndex++] = glyph.u2;
                vertices[vertexElementIndex++] = glyph.v2;
            }
            glyphX += glyphWidth + glyphAdvanceX;
        }
        text.vertexCount = vertexCount;
        text._vertices = vertices;
        GL32.glBindBuffer((int)34962, (int)text._vbo);
        GL32.glBufferData((int)34962, (float[])vertices, (int)35048);
        GL32.glBindBuffer((int)34962, (int)0);
        text._dirty = false;
    }

    private void gltInit() {
        this._gltCreateText2DShader();
        this._gltCreateText2DFontTexture();
    }

    public void gltTerminate() {
        if (this._gltText2DShader != 0) {
            GL32.glDeleteProgram((int)this._gltText2DShader);
            this._gltText2DShader = 0;
        }
        if (this._gltText2DFontTexture != 0) {
            GL32.glDeleteTextures((int)this._gltText2DFontTexture);
            this._gltText2DFontTexture = 0;
        }
    }

    public void _gltCreateText2DShader() {
        int vertexShader = GL32.glCreateShader((int)35633);
        GL32.glShaderSource((int)vertexShader, (CharSequence)_gltText2DVertexShaderSource);
        GL32.glCompileShader((int)vertexShader);
        int compileStatus = GL32.glGetShaderi((int)vertexShader, (int)35713);
        if (compileStatus != 1) {
            RuntimeException e;
            int infoLogLength = GL32.glGetShaderi((int)vertexShader, (int)35716);
            if (infoLogLength > 1) {
                String infoLog = GL32.glGetShaderInfoLog((int)vertexShader, (int)infoLogLength);
                System.out.printf("Vertex Shader #%d <Info Log>:\n%s\n", vertexShader, infoLog);
                e = new RuntimeException("Failed to compile vertex shader: " + infoLog);
            } else {
                e = new RuntimeException("Failed to compile vertex shader");
            }
            GL32.glDeleteShader((int)vertexShader);
            this.gltTerminate();
            throw e;
        }
        int fragmentShader = GL32.glCreateShader((int)35632);
        GL32.glShaderSource((int)fragmentShader, (CharSequence)_gltText2DFragmentShaderSource);
        GL32.glCompileShader((int)fragmentShader);
        compileStatus = GL32.glGetShaderi((int)fragmentShader, (int)35713);
        if (compileStatus != 1) {
            RuntimeException e;
            int infoLogLength = GL32.glGetShaderi((int)fragmentShader, (int)35716);
            if (infoLogLength > 1) {
                String infoLog = GL32.glGetShaderInfoLog((int)fragmentShader, (int)infoLogLength);
                System.out.printf("Fragment Shader #%d <Info Log>:\n%s\n", fragmentShader, infoLog);
                e = new RuntimeException("Failed to compile fragment shader: " + infoLog);
            } else {
                e = new RuntimeException("Failed to compile fragment shader");
            }
            GL32.glDeleteShader((int)vertexShader);
            GL32.glDeleteShader((int)fragmentShader);
            this.gltTerminate();
            throw e;
        }
        this._gltText2DShader = GL32.glCreateProgram();
        GL32.glAttachShader((int)this._gltText2DShader, (int)vertexShader);
        GL32.glAttachShader((int)this._gltText2DShader, (int)fragmentShader);
        GL32.glBindAttribLocation((int)this._gltText2DShader, (int)0, (CharSequence)"position");
        GL32.glBindAttribLocation((int)this._gltText2DShader, (int)1, (CharSequence)"texCoord");
        GL32.glBindFragDataLocation((int)this._gltText2DShader, (int)0, (CharSequence)"fragColor");
        GL32.glLinkProgram((int)this._gltText2DShader);
        GL32.glDetachShader((int)this._gltText2DShader, (int)vertexShader);
        GL32.glDeleteShader((int)vertexShader);
        GL32.glDetachShader((int)this._gltText2DShader, (int)fragmentShader);
        GL32.glDeleteShader((int)fragmentShader);
        int linkStatus = GL32.glGetProgrami((int)this._gltText2DShader, (int)35714);
        if (linkStatus != 1) {
            RuntimeException e;
            int infoLogLength = GL32.glGetProgrami((int)this._gltText2DShader, (int)35716);
            if (infoLogLength > 1) {
                String infoLog = GL32.glGetProgramInfoLog((int)this._gltText2DShader, (int)infoLogLength);
                System.out.printf("Shader Program #%d <Info Log>:\n%s\n", this._gltText2DShader, infoLog);
                e = new RuntimeException("Failed to link shader program: " + infoLog);
            } else {
                e = new RuntimeException("Failed to link shader program");
            }
            this.gltTerminate();
            throw e;
        }
        GL32.glUseProgram((int)this._gltText2DShader);
        this._gltText2DShaderMVPUniformLocation = GL32.glGetUniformLocation((int)this._gltText2DShader, (CharSequence)"mvp");
        this._gltText2DShaderColorUniformLocation = GL32.glGetUniformLocation((int)this._gltText2DShader, (CharSequence)"color");
        this.gltColor(1.0f, 1.0f, 1.0f, 1.0f);
        GL32.glUniform1i((int)GL32.glGetUniformLocation((int)this._gltText2DShader, (CharSequence)"diffuse"), (int)0);
        GL32.glUseProgram((int)0);
    }

    private void _gltCreateText2DFontTexture() {
        int texPixelIndex;
        _GLTglyphdata glyphData;
        _GLTglyph glyph;
        int glyphDataHeight;
        int glyphDataWidth;
        int glyphMarginBottom;
        int glyphMarginTop;
        int glyphHeight;
        int glyphY;
        int glyphWidth;
        int glyphX;
        char c;
        int i;
        int i2;
        for (i2 = 0; i2 < this._gltFontGlyphs.length; ++i2) {
            this._gltFontGlyphs[i2] = new _GLTglyph();
        }
        for (i2 = 0; i2 < this._gltFontGlyphs2.length; ++i2) {
            this._gltFontGlyphs2[i2] = new _GLTglyph();
        }
        int texWidth = 0;
        int texHeight = 0;
        int drawableGlyphCount = 0;
        _GLTglyphdata[] glyphsData = new _GLTglyphdata[83];
        for (int i3 = 0; i3 < 83; ++i3) {
            glyphsData[i3] = new _GLTglyphdata();
        }
        int glyphMarginLeft = 0;
        int glyphMarginRight = 0;
        for (i = 0; i < 83; ++i) {
            c = _gltFontGlyphCharacters.charAt(i);
            long glyphPacked = _gltFontGlyphRects[i];
            glyphX = (int)(glyphPacked >>> 0 & 0xFFFFL);
            glyphWidth = (int)(glyphPacked >>> 16 & 0xFFL);
            glyphY = 0;
            glyphHeight = 17;
            int glyphMarginPacked = (int)(glyphPacked >>> 24 & 0xFFFFL);
            glyphMarginTop = glyphMarginPacked >>> 0 & 0xFF;
            glyphMarginBottom = glyphMarginPacked >>> 8 & 0xFF;
            glyphDataWidth = glyphWidth;
            glyphDataHeight = glyphHeight - (glyphMarginTop + glyphMarginBottom);
            glyph = this._gltFontGlyphs[i];
            glyph.c = c;
            glyph.x = glyphX;
            glyph.y = glyphY;
            glyph.w = glyphWidth;
            glyph.h = glyphHeight;
            glyphData = glyphsData[i];
            glyphData.x = glyphX;
            glyphData.y = glyphY;
            glyphData.w = glyphWidth;
            glyphData.h = glyphHeight;
            glyphData.marginLeft = glyphMarginLeft;
            glyphData.marginTop = glyphMarginTop;
            glyphData.marginRight = glyphMarginRight;
            glyphData.marginBottom = glyphMarginBottom;
            glyphData.dataWidth = glyphDataWidth;
            glyphData.dataHeight = glyphDataHeight;
            glyph.drawable = false;
            if (glyphDataWidth > 0 && glyphDataHeight > 0) {
                glyph.drawable = true;
            }
            if (!glyph.drawable) continue;
            ++drawableGlyphCount;
            texWidth += glyphWidth;
            if (texHeight >= glyphHeight) continue;
            texHeight = glyphHeight;
        }
        boolean textureGlyphPadding = true;
        boolean textureGlyphSpacing = true;
        texWidth += 1 * (drawableGlyphCount - 1);
        int texAreaSize = (texWidth += 2) * (texHeight += 2);
        int texPixelComponents = 4;
        byte[] texData = new byte[texAreaSize * 4];
        for (texPixelIndex = 0; texPixelIndex < texAreaSize * 4; ++texPixelIndex) {
            texData[texPixelIndex] = 0;
        }
        int glyphDataTypeSizeBits = 64;
        int data0Index = 0;
        int data1Index = 0;
        int bit0Index = 0;
        int bit1Index = 1;
        int texX = 0;
        int texY = 0;
        ++texX;
        for (i = 0; i < 83; ++i) {
            glyph = this._gltFontGlyphs[i];
            glyphData = glyphsData[i];
            if (!glyph.drawable) continue;
            c = glyph.c;
            glyphX = glyph.x;
            glyphY = glyph.y;
            glyphWidth = glyph.w;
            glyphHeight = glyph.h;
            glyphMarginLeft = glyphData.marginLeft;
            glyphMarginTop = glyphData.marginTop;
            glyphMarginRight = glyphData.marginRight;
            glyphMarginBottom = glyphData.marginBottom;
            glyphDataWidth = glyphData.dataWidth;
            glyphDataHeight = glyphData.dataHeight;
            texY = 1;
            float u1 = (float)texX / (float)texWidth;
            float v1 = (float)texY / (float)texHeight;
            float u2 = (float)glyphWidth / (float)texWidth;
            float v2 = (float)glyphHeight / (float)texHeight;
            glyph.u1 = u1;
            glyph.v1 = v1;
            glyph.u2 = u1 + u2;
            glyph.v2 = v1 + v2;
            texX += glyphMarginLeft;
            texY += glyphMarginTop;
            for (int y = 0; y < glyphDataHeight; ++y) {
                for (int x = 0; x < glyphDataWidth; ++x) {
                    int a;
                    int b;
                    int g;
                    int r;
                    long c0 = _gltFontGlyphData[data0Index] >>> bit0Index & 1L;
                    long c1 = _gltFontGlyphData[data1Index] >>> bit1Index & 1L;
                    if (c0 == 0L && c1 == 0L) {
                        r = 0;
                        g = 0;
                        b = 0;
                        a = 0;
                    } else if (c0 == 0L && c1 == 1L) {
                        r = 255;
                        g = 255;
                        b = 255;
                        a = 255;
                    } else if (c0 == 1L && c1 == 0L) {
                        r = 0;
                        g = 0;
                        b = 0;
                        a = 0;
                    } else {
                        throw new RuntimeException("Invalid glyph data");
                    }
                    texPixelIndex = (texY + y) * texWidth * 4 + (texX + x) * 4;
                    texData[texPixelIndex + 0] = (byte)r;
                    texData[texPixelIndex + 1] = (byte)g;
                    texData[texPixelIndex + 2] = (byte)b;
                    texData[texPixelIndex + 3] = (byte)a;
                    bit1Index += 2;
                    if ((bit0Index += 2) >= 64) {
                        bit0Index %= 64;
                        ++data0Index;
                    }
                    if (bit1Index < 64) continue;
                    bit1Index %= 64;
                    ++data1Index;
                }
            }
            texX += glyphDataWidth;
            texY += glyphDataHeight;
            texX += glyphMarginRight;
            ++texX;
        }
        for (i = 0; i < 83; ++i) {
            this._gltFontGlyphs2[glyph.c - 32] = glyph = this._gltFontGlyphs[i];
        }
        this._gltText2DFontTexture = GL32.glGenTextures();
        GL32.glBindTexture((int)3553, (int)this._gltText2DFontTexture);
        GL32.glTexImage2D((int)3553, (int)0, (int)6408, (int)texWidth, (int)texHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)ByteBuffer.allocateDirect(texData.length).put(texData).position(0));
        GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL32.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL32.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL32.glBindTexture((int)3553, (int)0);
    }

    private static class _GLTglyph {
        public char c;
        public int x;
        public int y;
        public int w;
        public int h;
        public float u1;
        public float v1;
        public float u2;
        public float v2;
        public boolean drawable;

        private _GLTglyph() {
        }
    }

    public static class GLTtext {
        public String _text;
        public int _textLength;
        public boolean _dirty;
        public int vertexCount;
        public float[] _vertices;
        public int _vao;
        public int _vbo;
    }

    private static class _GLTglyphdata {
        public int x;
        public int y;
        public int w;
        public int h;
        public int marginLeft;
        public int marginTop;
        public int marginRight;
        public int marginBottom;
        public int dataWidth;
        public int dataHeight;

        private _GLTglyphdata() {
        }
    }
}

