/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client.screens.widget;

import com.google.common.collect.ImmutableList;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.client.screens.PFMConfigScreen;
import com.unlikepaladin.pfm.config.option.AbstractConfigOption;
import com.unlikepaladin.pfm.config.option.BooleanConfigOption;
import com.unlikepaladin.pfm.config.option.Side;
import com.unlikepaladin.pfm.runtime.PFMAssetGenerator;
import com.unlikepaladin.pfm.runtime.PFMDataGenerator;
import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import com.unlikepaladin.pfm.utilities.PFMFileUtil;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PFMOptionListWidget
extends ContainerObjectSelectionList<Entry> {
    final PFMConfigScreen parent;
    int maxKeyNameLength;
    public BitSet hasChanges;
    public Map<AbstractConfigOption, Boolean> newConfigValues;
    public Map<AbstractConfigOption, Integer> configOptionToIndexForHasChanges;

    public PFMOptionListWidget(PFMConfigScreen parent, Minecraft client) {
        super(client, parent.width + 125, parent.height - 75, 43, 20);
        this.parent = parent;
        String string = null;
        int index = 0;
        this.hasChanges = new BitSet(PaladinFurnitureMod.getPFMConfig().options.size());
        this.newConfigValues = new HashMap<AbstractConfigOption, Boolean>(PaladinFurnitureMod.getPFMConfig().options.size());
        this.configOptionToIndexForHasChanges = new HashMap<AbstractConfigOption, Integer>(PaladinFurnitureMod.getPFMConfig().options.size());
        for (Map.Entry<String, AbstractConfigOption> configOptionEntry : PaladinFurnitureMod.getPFMConfig().options.entrySet()) {
            Component text;
            int i;
            String configOptionCategory = configOptionEntry.getValue().getCategory();
            if (!configOptionCategory.equals(string)) {
                string = configOptionCategory;
                this.addEntry((AbstractSelectionList.Entry)new CategoryEntry(Component.translatable((String)configOptionCategory)));
            }
            if ((i = client.font.width((FormattedText)(text = configOptionEntry.getValue().getTitle()))) > this.maxKeyNameLength) {
                this.maxKeyNameLength = i;
            }
            if (configOptionEntry.getValue().getType() == Boolean.class) {
                this.newConfigValues.put(configOptionEntry.getValue(), (Boolean)configOptionEntry.getValue().getValue());
                this.addEntry((AbstractSelectionList.Entry)new BooleanEntry((BooleanConfigOption)configOptionEntry.getValue(), text, index));
            } else {
                PaladinFurnitureMod.GENERAL_LOGGER.warn("Unsupported Config Type!");
            }
            this.configOptionToIndexForHasChanges.put(configOptionEntry.getValue(), index);
            ++index;
        }
        this.addEntry((AbstractSelectionList.Entry)new CategoryEntry(Component.literal((String)"")));
        this.addEntry((AbstractSelectionList.Entry)new ButtonEntry(Side.CLIENT, (Component)Component.translatable((String)"pfm.option.regenAssets"), (Component)Component.translatable((String)"pfm.config.regen"), (Component)Component.translatable((String)"pfm.option.regenAssets.tooltip"), button -> {
            PFMFileUtil.deleteDir(PFMRuntimeResources.getAssetPackDirectory().toFile());
            PFMAssetGenerator.FROZEN = false;
            PFMRuntimeResources.prepareAndRunAssetGen(true);
            Minecraft.getInstance().delayTextureReload();
        }));
        ButtonEntry entry = new ButtonEntry(Side.SERVER, (Component)Component.translatable((String)"pfm.option.regenData"), (Component)Component.translatable((String)"pfm.config.regen"), (Component)Component.translatable((String)"pfm.option.regenData.tooltip"), button -> {
            PFMFileUtil.deleteDir(PFMRuntimeResources.getDataPackDirectory().toFile());
            PFMDataGenerator.FROZEN = false;
            PFMRuntimeResources.prepareAndRunDataGen(true);
        });
        entry.button.active = !PFMConfigScreen.isOnServer;
        this.addEntry((AbstractSelectionList.Entry)entry);
    }

    public void save() {
        for (Map.Entry<AbstractConfigOption, Boolean> entry : this.newConfigValues.entrySet()) {
            if (entry.getKey().getType() != Boolean.class) continue;
            entry.getKey().setValue(entry.getValue());
        }
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 15;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 32;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends Entry {
        final MutableComponent text;
        private final int textWidth;

        public CategoryEntry(MutableComponent text) {
            this.text = text;
            this.textWidth = ((PFMOptionListWidget)PFMOptionListWidget.this).minecraft.font.width((FormattedText)this.text);
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Font font = ((PFMOptionListWidget)PFMOptionListWidget.this).minecraft.font;
            MutableComponent mutableComponent = this.text.setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
            int n = ((PFMOptionListWidget)PFMOptionListWidget.this).minecraft.screen.width / 2 - this.textWidth / 2;
            Objects.requireNonNull(((PFMOptionListWidget)PFMOptionListWidget.this).minecraft.font);
            context.drawString(font, (Component)mutableComponent, n, y + entryHeight - 9 - 1, 0xFFFFFF, true);
        }

        public boolean changeFocus(boolean lookForwards) {
            return false;
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(NarrationElementOutput builder) {
                    builder.add(NarratedElementType.TITLE, (Component)CategoryEntry.this.text);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class BooleanEntry
    extends Entry {
        private final BooleanConfigOption configOption;
        private final Component optionName;
        private final Button valueButton;
        private final Button resetButton;
        private final Tooltip supplier;
        int index;
        boolean hasChanges = false;

        BooleanEntry(BooleanConfigOption configOption, Component optionName, int index) {
            this.configOption = configOption;
            this.optionName = optionName;
            this.index = index;
            MutableComponent sideText = configOption.getSide() == Side.CLIENT ? Component.translatable((String)"pfm.option.client").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withBold(Boolean.valueOf(true)).withColor(16219956)) : Component.translatable((String)"pfm.option.server").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withBold(Boolean.valueOf(true)).withColor(16219956));
            MutableComponent styledTooltip = ((MutableComponent)configOption.getToolTip()).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withBold(Boolean.valueOf(false)).withColor(ChatFormatting.WHITE));
            MutableComponent tooltipText = sideText.append((Component)Component.literal((String)"\n")).append((Component)styledTooltip);
            this.supplier = Tooltip.create((Component)tooltipText);
            this.valueButton = Button.builder((Component)optionName, button -> {
                PFMOptionListWidget.this.parent.focusedConfigOption = configOption;
                PFMOptionListWidget.this.newConfigValues.put(configOption, PFMOptionListWidget.this.newConfigValues.get(configOption) == false);
                this.hasChanges = !this.hasChanges;
                PFMOptionListWidget.this.hasChanges.set(index, this.hasChanges);
            }).tooltip(this.supplier).bounds(0, 0, 75, 20).createNarration(Supplier::get).build();
            this.resetButton = Button.builder((Component)Component.translatable((String)"controls.reset"), button -> {
                PFMOptionListWidget.this.newConfigValues.put(configOption, configOption.getDefaultValue());
                this.hasChanges = true;
                PFMOptionListWidget.this.hasChanges.set(index, true);
            }).bounds(0, 0, 50, 20).createNarration(textSupplier -> Component.translatable((String)"narrator.controls.reset", (Object[])new Object[]{optionName})).build();
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Font font = ((PFMOptionListWidget)PFMOptionListWidget.this).minecraft.font;
            int n = x + 90 - PFMOptionListWidget.this.maxKeyNameLength;
            int n2 = y + entryHeight / 2;
            Objects.requireNonNull(((PFMOptionListWidget)PFMOptionListWidget.this).minecraft.font);
            context.drawString(font, this.optionName, n, n2 - 9 / 2, 0xFFFFFF, false);
            this.resetButton.setX(x + 190);
            this.resetButton.setY(y);
            this.resetButton.active = this.configOption.getSide() == Side.SERVER ? !PFMConfigScreen.isOnServer && this.configOption.getDefaultValue() != PFMOptionListWidget.this.newConfigValues.get(this.configOption) : this.configOption.getDefaultValue() != PFMOptionListWidget.this.newConfigValues.get(this.configOption);
            this.resetButton.render(context, mouseX, mouseY, tickDelta);
            this.valueButton.setX(x + 105);
            this.valueButton.setY(y);
            this.valueButton.setMessage(PFMOptionListWidget.this.newConfigValues.get(this.configOption) != false ? CommonComponents.GUI_YES : CommonComponents.GUI_NO);
            this.valueButton.active = this.configOption.getSide() != Side.SERVER || !PFMConfigScreen.isOnServer;
            this.valueButton.render(context, mouseX, mouseY, tickDelta);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.valueButton, (Object)this.resetButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.valueButton, (Object)this.resetButton);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.valueButton.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            return this.resetButton.mouseClicked(mouseX, mouseY, button);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            return this.valueButton.mouseReleased(mouseX, mouseY, button) || this.resetButton.mouseReleased(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ButtonEntry
    extends Entry {
        private final Component optionName;
        private final Button button;
        private final Tooltip supplier;
        private final Side side;

        ButtonEntry(Side side, final Component optionName, Component buttonText, Component tooltip, Button.OnPress pressAction) {
            this.optionName = optionName;
            this.side = side;
            MutableComponent sideText = side == Side.CLIENT ? Component.translatable((String)"pfm.option.client").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withBold(Boolean.valueOf(true)).withColor(16219956)) : Component.translatable((String)"pfm.option.server").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withBold(Boolean.valueOf(true)).withColor(16219956));
            MutableComponent styledTooltip = ((MutableComponent)tooltip).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withBold(Boolean.valueOf(false)).withColor(ChatFormatting.WHITE));
            MutableComponent tooltipText = sideText.append((Component)Component.literal((String)"\n")).append((Component)styledTooltip);
            this.supplier = Tooltip.create((Component)tooltipText);
            this.button = new Button(this, 0, 0, 135, 20, buttonText, pressAction, Supplier::get){

                protected MutableComponent createNarrationMessage() {
                    return (MutableComponent)optionName;
                }
            };
            this.button.setTooltip(this.supplier);
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Font font = ((PFMOptionListWidget)PFMOptionListWidget.this).minecraft.font;
            int n = x + 90 - PFMOptionListWidget.this.maxKeyNameLength;
            int n2 = y + entryHeight / 2;
            Objects.requireNonNull(((PFMOptionListWidget)PFMOptionListWidget.this).minecraft.font);
            context.drawString(font, this.optionName, n, n2 - 9 / 2, 0xFFFFFF, false);
            this.button.setX(x + 105);
            this.button.setY(y);
            this.button.render(context, mouseX, mouseY, tickDelta);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.button);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.button);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return this.button.mouseClicked(mouseX, mouseY, button);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            return this.button.mouseReleased(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

