/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.api.provider.BalmProviderHolder;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;

public interface BlockEntityContract
extends BalmProviderHolder {
    public static final Map<Class<?>, BalmProvider<?>> providers = new HashMap();

    public <T> T getProvider(Class<T> var1);

    default public void buildProviders(List<BalmProviderHolder> providers) {
        providers.add(this);
        BlockEntityContract blockEntityContract = this;
        if (blockEntityContract instanceof BalmContainerProvider) {
            final BalmContainerProvider containerProvider = (BalmContainerProvider)blockEntityContract;
            providers.add(new BalmProviderHolder(){

                public List<BalmProvider<?>> getProviders() {
                    Container container = containerProvider.getContainer();
                    if (container != null) {
                        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(Container.class, (Object)container)});
                    }
                    return Collections.emptyList();
                }

                public List<Pair<Direction, BalmProvider<?>>> getSidedProviders() {
                    ArrayList providers = new ArrayList();
                    for (Direction direction : Direction.values()) {
                        Container container = containerProvider.getContainer(direction);
                        if (container == null) continue;
                        providers.add(Pair.of((Object)direction, (Object)new BalmProvider(Container.class, (Object)container)));
                    }
                    return providers;
                }
            });
        }
        if ((blockEntityContract = this) instanceof BalmFluidTankProvider) {
            final BalmFluidTankProvider fluidTankProvider = (BalmFluidTankProvider)blockEntityContract;
            providers.add(new BalmProviderHolder(){

                public List<BalmProvider<?>> getProviders() {
                    FluidTank fluidTank = fluidTankProvider.getFluidTank();
                    if (fluidTank != null) {
                        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(FluidTank.class, (Object)fluidTank)});
                    }
                    return Collections.emptyList();
                }

                public List<Pair<Direction, BalmProvider<?>>> getSidedProviders() {
                    ArrayList providers = new ArrayList();
                    for (Direction direction : Direction.values()) {
                        FluidTank fluidTank = fluidTankProvider.getFluidTank(direction);
                        if (fluidTank == null) continue;
                        providers.add(Pair.of((Object)direction, (Object)new BalmProvider(FluidTank.class, (Object)fluidTank)));
                    }
                    return providers;
                }
            });
        }
        if ((blockEntityContract = this) instanceof BalmEnergyStorageProvider) {
            final BalmEnergyStorageProvider energyStorageProvider = (BalmEnergyStorageProvider)blockEntityContract;
            providers.add(new BalmProviderHolder(){

                public List<BalmProvider<?>> getProviders() {
                    EnergyStorage energyStorage = energyStorageProvider.getEnergyStorage();
                    if (energyStorage != null) {
                        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(EnergyStorage.class, (Object)energyStorage)});
                    }
                    return Collections.emptyList();
                }

                public List<Pair<Direction, BalmProvider<?>>> getSidedProviders() {
                    ArrayList providers = new ArrayList();
                    for (Direction direction : Direction.values()) {
                        EnergyStorage energyStorage = energyStorageProvider.getEnergyStorage(direction);
                        if (energyStorage == null) continue;
                        providers.add(Pair.of((Object)direction, (Object)new BalmProvider(EnergyStorage.class, (Object)energyStorage)));
                    }
                    return providers;
                }
            });
        }
    }
}

