/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge;

import com.unlikepaladin.pfm.blocks.StoveBlock;
import com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge.menu.StoveScreenHandlerBalm;
import com.unlikepaladin.pfm.menus.StoveScreenHandler;
import com.unlikepaladin.pfm.registry.BlockEntities;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.container.SubContainer;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.tag.BalmItemTags;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProcessor;
import net.blay09.mods.cookingforblockheads.api.KitchenOperation;
import net.blay09.mods.cookingforblockheads.api.event.OvenCookedEvent;
import net.blay09.mods.cookingforblockheads.block.entity.IMutableNameable;
import net.blay09.mods.cookingforblockheads.recipe.ModRecipes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class StoveBlockEntityBalm
extends BalmBlockEntity
implements KitchenItemProcessor,
BalmMenuProvider<StoveScreenHandler.StoveData>,
IMutableNameable,
BalmContainerProvider,
BalmEnergyStorageProvider {
    private static final int COOK_TIME = 200;
    private final DefaultContainer container = new DefaultContainer(20){

        public boolean canPlaceItem(int slot, ItemStack itemStack) {
            if (slot < 3) {
                return !StoveBlockEntityBalm.this.getSmeltingResult(itemStack).isEmpty();
            }
            return slot != 3 || StoveBlockEntityBalm.isItemFuel(itemStack);
        }

        public void slotChanged(int slot) {
            if (slot >= 7 && slot < 16) {
                StoveBlockEntityBalm.this.slotCookTime[slot - 7] = 0;
            }
            StoveBlockEntityBalm.this.isDirty = true;
            StoveBlockEntityBalm.this.setChanged();
        }
    };
    private final ContainerData dataAccess = new ContainerData(){

        public int get(int id) {
            if (id == 0) {
                return StoveBlockEntityBalm.this.furnaceBurnTime;
            }
            if (id == 1) {
                return StoveBlockEntityBalm.this.currentItemBurnTime;
            }
            return id >= 2 && id <= 11 ? StoveBlockEntityBalm.this.slotCookTime[id - 2] : 0;
        }

        public void set(int id, int value) {
            if (id == 0) {
                StoveBlockEntityBalm.this.furnaceBurnTime = value;
            } else if (id == 1) {
                StoveBlockEntityBalm.this.currentItemBurnTime = value;
            } else if (id >= 2 && id <= 11) {
                StoveBlockEntityBalm.this.slotCookTime[id - 2] = value;
            }
        }

        public int getCount() {
            return 11;
        }
    };
    private final EnergyStorage energyStorage = new EnergyStorage(10000){

        public int fill(int maxReceive, boolean simulate) {
            if (!simulate) {
                StoveBlockEntityBalm.this.setChanged();
            }
            return super.fill(maxReceive, simulate);
        }

        public int drain(int maxExtract, boolean simulate) {
            if (!simulate) {
                StoveBlockEntityBalm.this.setChanged();
            }
            return super.drain(maxExtract, simulate);
        }
    };
    private final SubContainer inputContainer = new SubContainer((Container)this.container, 0, 3);
    private final SubContainer fuelContainer = new SubContainer((Container)this.container, 3, 4);
    final SubContainer outputContainer = new SubContainer((Container)this.container, 4, 7);
    private final SubContainer processingContainer = new SubContainer((Container)this.container, 7, 16);
    final SubContainer toolsContainer = new SubContainer((Container)this.container, 16, 20);
    private Component customName;
    private boolean isFirstTick = true;
    public int[] slotCookTime = new int[9];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    private boolean isDirty;
    private boolean hasPowerUpgrade;
    private Direction facing;
    private final Container singleSlotRecipeWrapper = new DefaultContainer(1);

    public StoveBlockEntityBalm(BlockPos pos, BlockState state) {
        super(BlockEntities.STOVE_BLOCK_ENTITY, pos, state);
    }

    public boolean triggerEvent(int id, int type) {
        return super.triggerEvent(id, type);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof StoveBlockEntityBalm) {
            StoveBlockEntityBalm stoveBlockEntityBalm = (StoveBlockEntityBalm)blockEntity;
            stoveBlockEntityBalm.clientTick(level, pos, state);
        }
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof StoveBlockEntityBalm) {
            StoveBlockEntityBalm stoveBlockEntityBalm = (StoveBlockEntityBalm)blockEntity;
            stoveBlockEntityBalm.serverTick(level, pos, state);
        }
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isFirstTick && state.getBlock() instanceof StoveBlock) {
            this.facing = (Direction)state.getValue((Property)StoveBlock.FACING);
            this.isFirstTick = false;
        }
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
        boolean hasChanged = false;
        int burnPotential = 200 - this.furnaceBurnTime;
        if (this.hasPowerUpgrade && burnPotential > 0 && this.shouldConsumeFuel()) {
            this.furnaceBurnTime += this.energyStorage.drain(burnPotential, false);
        }
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!level.isClientSide) {
            ItemStack itemStack;
            int i;
            ItemStack containerItem;
            int firstEmptySlot;
            if (this.furnaceBurnTime == 0 && this.shouldConsumeFuel()) {
                for (firstEmptySlot = 0; firstEmptySlot < this.fuelContainer.getContainerSize(); ++firstEmptySlot) {
                    ItemStack fuelItem = this.fuelContainer.getItem(firstEmptySlot);
                    if (fuelItem.isEmpty()) continue;
                    this.currentItemBurnTime = this.furnaceBurnTime = (int)Math.max(1.0, (double)StoveBlockEntityBalm.getBurnTime(fuelItem) * CookingForBlockheadsConfig.getActive().ovenFuelTimeMultiplier);
                    if (this.furnaceBurnTime == 0) break;
                    containerItem = Balm.getHooks().getCraftingRemainingItem(fuelItem);
                    fuelItem.shrink(1);
                    if (fuelItem.isEmpty()) {
                        this.fuelContainer.setItem(firstEmptySlot, containerItem);
                    }
                    hasChanged = true;
                    break;
                }
            }
            firstEmptySlot = -1;
            int firstTransferSlot = -1;
            for (i = 0; i < this.processingContainer.getContainerSize(); ++i) {
                itemStack = this.processingContainer.getItem(i);
                if (!itemStack.isEmpty()) {
                    if (this.slotCookTime[i] != -1) {
                        ItemStack smeltingResult;
                        double maxCookTime = 200.0 * CookingForBlockheadsConfig.getActive().ovenCookTimeMultiplier;
                        if ((double)this.slotCookTime[i] >= maxCookTime && firstTransferSlot == -1) {
                            firstTransferSlot = i;
                            continue;
                        }
                        if (this.furnaceBurnTime > 0) {
                            int n = i;
                            this.slotCookTime[n] = this.slotCookTime[n] + 1;
                        }
                        if (!((double)this.slotCookTime[i] >= maxCookTime) || (smeltingResult = this.getSmeltingResult(itemStack)).isEmpty()) continue;
                        ItemStack resultStack = smeltingResult.copy();
                        this.processingContainer.setItem(i, resultStack);
                        Balm.getEvents().fireEvent((Object)new OvenCookedEvent(level, this.worldPosition, resultStack));
                        this.slotCookTime[i] = -1;
                        if (firstTransferSlot != -1) continue;
                        firstTransferSlot = i;
                        continue;
                    }
                    if (firstTransferSlot != -1) continue;
                    firstTransferSlot = i;
                    continue;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
            }
            if (firstTransferSlot != -1) {
                containerItem = this.processingContainer.getItem(firstTransferSlot);
                containerItem = ContainerUtils.insertItemStacked((Container)this.outputContainer, (ItemStack)containerItem, (boolean)false);
                this.processingContainer.setItem(firstTransferSlot, containerItem);
                if (containerItem.isEmpty()) {
                    this.slotCookTime[firstTransferSlot] = 0;
                }
                hasChanged = true;
            }
            if (firstEmptySlot != -1) {
                for (i = 0; i < this.inputContainer.getContainerSize(); ++i) {
                    itemStack = this.inputContainer.getItem(i);
                    if (itemStack.isEmpty()) continue;
                    this.processingContainer.setItem(firstEmptySlot, itemStack.split(1));
                    if (itemStack.getCount() > 0) break;
                    this.inputContainer.setItem(i, ItemStack.EMPTY);
                    break;
                }
            }
        }
        if (hasChanged) {
            this.setChanged();
        }
    }

    public ItemStack getSmeltingResult(ItemStack itemStack) {
        SingleRecipeInput recipeInput = new SingleRecipeInput(itemStack);
        ItemStack ovenRecipeResult = this.getSmeltingResult(ModRecipes.ovenRecipeType, recipeInput);
        return !ovenRecipeResult.isEmpty() ? ovenRecipeResult : this.getSmeltingResult(RecipeType.SMELTING, recipeInput);
    }

    public <T extends RecipeInput> ItemStack getSmeltingResult(RecipeType<? extends Recipe<T>> recipeType, T container) {
        ItemStack result;
        RecipeHolder recipe = this.level.getRecipeManager().getRecipeFor(recipeType, container, this.level).orElse(null);
        if (recipe != null && !(result = recipe.value().getResultItem((HolderLookup.Provider)this.level.registryAccess())).isEmpty() && result.has(DataComponents.FOOD)) {
            return result;
        }
        return ItemStack.EMPTY;
    }

    public static boolean isItemFuel(ItemStack itemStack) {
        if (CookingForBlockheadsConfig.getActive().ovenRequiresCookingOil) {
            return itemStack.is(BalmItemTags.COOKING_OIL);
        }
        return StoveBlockEntityBalm.getBurnTime(itemStack) > 0;
    }

    protected static int getBurnTime(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return 0;
        }
        return CookingForBlockheadsConfig.getActive().ovenRequiresCookingOil && itemStack.is(BalmItemTags.COOKING_OIL) ? 800 : Balm.getHooks().getBurnTime(itemStack);
    }

    private boolean shouldConsumeFuel() {
        for (int i = 0; i < this.processingContainer.getContainerSize(); ++i) {
            ItemStack cookingStack = this.processingContainer.getItem(i);
            if (cookingStack.isEmpty() || this.slotCookTime[i] == -1) continue;
            return true;
        }
        return false;
    }

    protected void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider registryLookup) {
        super.loadAdditional(tagCompound, registryLookup);
        this.container.deserialize(tagCompound.getCompound("ItemHandler"), registryLookup);
        this.furnaceBurnTime = tagCompound.getShort("BurnTime");
        this.currentItemBurnTime = tagCompound.getShort("CurrentItemBurnTime");
        this.slotCookTime = tagCompound.getIntArray("CookTimes");
        if (this.slotCookTime.length != 9) {
            this.slotCookTime = new int[9];
        }
        this.hasPowerUpgrade = tagCompound.getBoolean("HasPowerUpgrade");
        this.energyStorage.setEnergy(tagCompound.getInt("EnergyStored"));
        if (tagCompound.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tagCompound.getString("CustomName"), (HolderLookup.Provider)registryLookup);
        }
    }

    protected void saveAdditional(CompoundTag tagCompound, HolderLookup.Provider registryLookup) {
        super.saveAdditional(tagCompound, registryLookup);
        tagCompound.put("ItemHandler", (Tag)this.container.serialize(registryLookup));
        tagCompound.putShort("BurnTime", (short)this.furnaceBurnTime);
        tagCompound.putShort("CurrentItemBurnTime", (short)this.currentItemBurnTime);
        tagCompound.putIntArray("CookTimes", ArrayUtils.clone((int[])this.slotCookTime));
        tagCompound.putBoolean("HasPowerUpgrade", this.hasPowerUpgrade);
        tagCompound.putInt("EnergyStored", this.energyStorage.getEnergy());
        if (this.customName != null) {
            tagCompound.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)registryLookup));
        }
    }

    protected void writeUpdateTag(CompoundTag tag) {
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
        super.writeUpdateTag(tag);
    }

    public boolean hasPowerUpgrade() {
        return this.hasPowerUpgrade;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public float getBurnTimeProgress() {
        return this.currentItemBurnTime == 0 && this.furnaceBurnTime > 0 ? 1.0f : (float)this.furnaceBurnTime / (float)this.currentItemBurnTime;
    }

    public float getCookProgress(int i) {
        return (float)this.slotCookTime[i] / (float)(200.0 * CookingForBlockheadsConfig.getActive().ovenCookTimeMultiplier);
    }

    public ItemStack smeltItem(ItemStack itemStack) {
        return ContainerUtils.insertItemStacked((Container)this.inputContainer, (ItemStack)itemStack, (boolean)false);
    }

    public ItemStack getToolItem(int i) {
        return this.toolsContainer.getItem(i);
    }

    public void setToolItem(int i, ItemStack itemStack) {
        this.toolsContainer.setItem(i, itemStack);
    }

    public Container getContainer(Direction side) {
        if (side == null) {
            return this.getContainer();
        }
        return switch (side) {
            case Direction.UP -> this.inputContainer;
            case Direction.DOWN -> this.outputContainer;
            default -> this.fuelContainer;
        };
    }

    public Container getInputContainer() {
        return this.inputContainer;
    }

    public Container getFuelContainer() {
        return this.fuelContainer;
    }

    public Direction getFacing() {
        return this.facing == null ? Direction.NORTH : this.facing;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new StoveScreenHandlerBalm(i, playerInventory, this);
    }

    public AABB balmGetRenderBoundingBox() {
        return new AABB(this.worldPosition.offset(-1, 0, -1).getCenter(), this.worldPosition.offset(2, 1, 2).getCenter());
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public Component getDefaultName() {
        return Component.translatable((String)"container.cookingforblockheads.oven");
    }

    public Container getContainer() {
        return this.container;
    }

    public ContainerData getContainerData() {
        return this.dataAccess;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        nbt.put("ItemHandler", (Tag)this.container.serialize(provider));
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider holders) {
        this.loadAdditional(tag, holders);
        super.handleUpdateTag(tag, holders);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookup) {
        super.onDataPacket(connection, pkt, lookup);
        this.container.deserialize(pkt.getTag().getCompound("ItemHandler"), lookup);
    }

    protected void onContainerOpen(Level world, BlockPos pos, BlockState state) {
        if (state.getBlock() instanceof StoveBlock) {
            this.playSound(state, SoundEvents.IRON_TRAPDOOR_OPEN);
            this.setOpen(state, true);
        }
    }

    protected void onContainerClose(Level world, BlockPos pos, BlockState state) {
        if (state.getBlock() instanceof StoveBlock) {
            this.playSound(state, SoundEvents.IRON_TRAPDOOR_CLOSE);
            this.setOpen(state, false);
        }
    }

    void setOpen(BlockState state, boolean open) {
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    public void onClose(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.onContainerClose(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void onOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.onContainerOpen(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    void playSound(BlockState state, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getNormal();
        double d = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double e = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double f = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    public boolean canProcess(RecipeType<?> recipeType) {
        return recipeType == RecipeType.SMELTING;
    }

    public KitchenOperation processRecipe(Recipe<?> recipe, List<IngredientToken> ingredientTokens) {
        for (IngredientToken ingredientToken : ingredientTokens) {
            ItemStack itemStack = ingredientToken.consume();
            ItemStack restStack = ContainerUtils.insertItemStacked((Container)this.inputContainer, (ItemStack)itemStack, (boolean)false);
            if (restStack.isEmpty()) continue;
            ingredientToken.restore(restStack);
        }
        return KitchenOperation.EMPTY;
    }

    public StoveScreenHandler.StoveData getScreenOpeningData(ServerPlayer serverPlayerEntity) {
        return new StoveScreenHandler.StoveData(this.worldPosition);
    }

    public StreamCodec<RegistryFriendlyByteBuf, StoveScreenHandler.StoveData> getScreenStreamCodec() {
        return StoveScreenHandler.PACKET_CODEC;
    }
}

