/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.emi;

import com.unlikepaladin.pfm.compat.emi.FreezingWidget;
import com.unlikepaladin.pfm.compat.emi.PaladinFurnitureModEMIPlugin;
import com.unlikepaladin.pfm.recipes.FreezingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;

public class EmiFreezingRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final EmiIngredient input;
    private final EmiStack output;
    private final AbstractCookingRecipe recipe;
    private final int fuelMultiplier;
    private final boolean infiniBurn;

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 82;
    }

    public int getDisplayHeight() {
        return 38;
    }

    public EmiFreezingRecipe(RecipeHolder<FreezingRecipe> entry) {
        FreezingRecipe recipe = (FreezingRecipe)entry.value();
        this.input = EmiIngredient.of((Ingredient)((Ingredient)recipe.getIngredients().get(0)));
        this.output = EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
        this.recipe = recipe;
        this.id = entry.id();
        this.fuelMultiplier = 2;
        this.infiniBurn = false;
    }

    public EmiRecipeCategory getCategory() {
        return PaladinFurnitureModEMIPlugin.FREEZER;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addFillingArrow(24, 5, 50 * this.recipe.getCookingTime()).tooltip((mx, my) -> List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"emi.cooking.time", (Object[])new Object[]{Float.valueOf((float)this.recipe.getCookingTime() / 20.0f)}).getVisualOrderText())));
        if (this.infiniBurn) {
            widgets.addTexture(FreezingWidget.FULL_FREEZER, 1, 24);
        } else {
            widgets.addTexture(FreezingWidget.EMPTY_FREEZER, 1, 24);
            widgets.addAnimatedTexture(FreezingWidget.FULL_FREEZER, 1, 24, 2000, false, true, true);
        }
        widgets.addSlot(this.input, 0, 4);
        widgets.addSlot((EmiIngredient)this.output, 56, 0).large(true).recipeContext((EmiRecipe)this);
    }
}

