/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.emi;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.compat.emi.PaladinFurnitureModEMIPlugin;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import com.unlikepaladin.pfm.registry.ScreenHandlerIDs;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class EmiFurnitureRecipe
extends EmiPatternCraftingRecipe {
    private final FurnitureRecipe recipe;
    private static final Map<FurnitureRecipe, List<EmiStack>> outputs = new HashMap<FurnitureRecipe, List<EmiStack>>();
    static Map<ItemStack, List<ItemStack>> itemStackListMap = new HashMap<ItemStack, List<ItemStack>>();

    public EmiFurnitureRecipe(RecipeHolder<FurnitureRecipe> entry) {
        super(EmiFurnitureRecipe.padIngredients((FurnitureRecipe)entry.value()), EmiStack.EMPTY, entry.id());
        for (int i = 0; i < this.input.size(); ++i) {
            Inventory playerInventory = PaladinFurnitureMod.isClient ? Minecraft.getInstance().player.getInventory() : new Inventory(null);
            TransientCraftingContainer inv = new TransientCraftingContainer(new AbstractContainerMenu(this, ScreenHandlerIDs.WORKBENCH_SCREEN_HANDLER, -1){

                public boolean stillValid(Player player) {
                    return false;
                }

                public ItemStack quickMoveStack(Player player, int index) {
                    return null;
                }
            }, 3, 3);
            for (int j = 0; j < this.input.size(); ++j) {
                if (j == i || ((EmiIngredient)this.input.get(j)).isEmpty()) continue;
                inv.setItem(j, ((EmiStack)((EmiIngredient)this.input.get(j)).getEmiStacks().get(0)).getItemStack().copy());
            }
            List stacks = ((EmiIngredient)this.input.get(i)).getEmiStacks();
            for (EmiStack stack : stacks) {
                inv.setItem(i, stack.getItemStack().copy());
                ItemStack remainder = (ItemStack)((FurnitureRecipe)entry.value()).getRemainingItems(new FurnitureRecipe.FurnitureRecipeInput(playerInventory)).get(i);
                if (remainder.isEmpty()) continue;
                stack.setRemainder(EmiStack.of((ItemStack)remainder));
            }
        }
        this.recipe = (FurnitureRecipe)entry.value();
    }

    public List<EmiStack> getOutputs() {
        return EmiFurnitureRecipe.getOutputEntries(this.recipe);
    }

    public EmiRecipeCategory getCategory() {
        return PaladinFurnitureModEMIPlugin.FURNITURE;
    }

    public ResourceLocation getId() {
        return super.getId();
    }

    public static List<EmiStack> getOutputEntries(FurnitureRecipe recipe) {
        if (!outputs.containsKey(recipe)) {
            outputs.put(recipe, recipe.getInnerRecipes().stream().map(FurnitureRecipe.CraftableFurnitureRecipe::getRecipeOuput).map(EmiStack::of).collect(Collectors.toList()));
        }
        return outputs.get(recipe);
    }

    public static List<ItemStack> collectIngredientsFromRecipe(FurnitureRecipe.CraftableFurnitureRecipe recipe) {
        if (itemStackListMap.containsKey(recipe.getRecipeOuput())) {
            return itemStackListMap.get(recipe.getRecipeOuput());
        }
        List<Ingredient> ingredients = recipe.getIngredients();
        HashMap<Item, Integer> containedItems = new HashMap<Item, Integer>();
        for (Ingredient ingredient : ingredients) {
            for (ItemStack stack : ingredient.getItems()) {
                if (!containedItems.containsKey(stack.getItem())) {
                    containedItems.put(stack.getItem(), stack.getCount());
                    continue;
                }
                containedItems.put(stack.getItem(), (Integer)containedItems.get(stack.getItem()) + stack.getCount());
            }
        }
        ArrayList<ItemStack> listOfList = new ArrayList<ItemStack>();
        for (Map.Entry entry : containedItems.entrySet()) {
            listOfList.add(new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        if (listOfList.size() != recipe.parent().getMaxInnerRecipeSize()) {
            while (listOfList.size() != recipe.parent().getMaxInnerRecipeSize()) {
                listOfList.add(ItemStack.EMPTY);
            }
        }
        itemStackListMap.put(recipe.getRecipeOuput(), listOfList);
        return listOfList;
    }

    private static List<EmiIngredient> padIngredients(FurnitureRecipe recipe) {
        ArrayList ingredients = new ArrayList(recipe.getMaxInnerRecipeSize());
        for (FurnitureRecipe.CraftableFurnitureRecipe innerRecipe : recipe.getInnerRecipes()) {
            List<ItemStack> list = EmiFurnitureRecipe.collectIngredientsFromRecipe(innerRecipe);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = list.get(i);
                if (ingredients.size() <= i) {
                    ingredients.add(new ArrayList());
                }
                ((List)ingredients.get(i)).add(stack);
            }
        }
        ArrayList<EmiIngredient> finalList = new ArrayList<EmiIngredient>();
        for (List list : ingredients) {
            finalList.add(EmiIngredient.of((Ingredient)Ingredient.of(list.stream())));
        }
        return finalList;
    }

    public SlotWidget getInputWidget(int slot, int x, int y) {
        return new GeneratedSlotWidget(r -> {
            int selectedRecipe = r.nextInt(this.recipe.getInnerRecipes().size());
            List<ItemStack> ingredients = EmiFurnitureRecipe.collectIngredientsFromRecipe(this.recipe.getInnerRecipes().get(selectedRecipe));
            if (ingredients.size() > slot) {
                return EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{ingredients.get(slot)}), (long)ingredients.get(slot).getCount());
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(r -> {
            int selectedRecipe = r.nextInt(this.recipe.getInnerRecipes().size());
            return EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{this.recipe.getInnerRecipes().get(selectedRecipe).getRecipeOuput()}), (long)this.recipe.getInnerRecipes().get(selectedRecipe).getRecipeOuput().getCount());
        }, this.unique, x, y);
    }
}

