/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.emi;

import com.mojang.blaze3d.systems.RenderSystem;
import com.unlikepaladin.pfm.compat.emi.EmiFreezingRecipe;
import com.unlikepaladin.pfm.compat.emi.EmiFurnitureRecipe;
import com.unlikepaladin.pfm.compat.emi.FreezerRecipeHandler;
import com.unlikepaladin.pfm.compat.emi.FurnitureRecipeHandler;
import com.unlikepaladin.pfm.recipes.FreezingRecipe;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import com.unlikepaladin.pfm.registry.ScreenHandlerIDs;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class PaladinFurnitureModEMIPlugin
implements EmiPlugin {
    protected static EmiRecipeCategory FURNITURE;
    protected static EmiRecipeCategory FREEZER;
    public static EmiIngredient WORKBENCH_ICON;
    public static ResourceLocation WORKBENCH_ID;
    public static EmiIngredient FREEZER_ICON;
    public static ResourceLocation FREEZER_ID;

    public void register(EmiRegistry registry) {
        FURNITURE = new EmiRecipeCategory(WORKBENCH_ID, (EmiRenderable)WORKBENCH_ICON, PaladinFurnitureModEMIPlugin.simplifiedRenderer(240, 240));
        FREEZER = new EmiRecipeCategory(FREEZER_ID, (EmiRenderable)FREEZER_ICON, PaladinFurnitureModEMIPlugin.simplifiedRenderer(240, 240));
        registry.addCategory(FURNITURE);
        registry.addWorkstation(FURNITURE, WORKBENCH_ICON);
        registry.addCategory(FREEZER);
        registry.addWorkstation(FREEZER, FREEZER_ICON);
        registry.addWorkstation(FREEZER, (EmiIngredient)EmiStack.of((ItemLike)PaladinFurnitureModBlocksItems.GRAY_FREEZER));
        registry.addWorkstation(FREEZER, (EmiIngredient)EmiStack.of((ItemLike)PaladinFurnitureModBlocksItems.IRON_FREEZER));
        registry.addRecipeHandler(ScreenHandlerIDs.WORKBENCH_SCREEN_HANDLER, (EmiRecipeHandler)new FurnitureRecipeHandler());
        registry.addRecipeHandler(ScreenHandlerIDs.FREEZER_SCREEN_HANDLER, (EmiRecipeHandler)new FreezerRecipeHandler(FREEZER));
        for (RecipeHolder recipe : registry.getRecipeManager().getAllRecipesFor(RecipeTypes.FURNITURE_RECIPE)) {
            registry.addRecipe((EmiRecipe)new EmiFurnitureRecipe((RecipeHolder<FurnitureRecipe>)recipe));
        }
        for (RecipeHolder recipe : registry.getRecipeManager().getAllRecipesFor(RecipeTypes.FREEZING_RECIPE)) {
            registry.addRecipe((EmiRecipe)new EmiFreezingRecipe((RecipeHolder<FreezingRecipe>)recipe));
        }
    }

    private static EmiRenderable simplifiedRenderer(int u, int v) {
        return (context, x, y, delta) -> {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            context.blit(ResourceLocation.fromNamespaceAndPath((String)"emi", (String)"textures/gui/widgets.png"), x, y, (float)u, (float)v, 16, 16, 256, 256);
        };
    }

    static {
        WORKBENCH_ICON = EmiStack.of((ItemLike)PaladinFurnitureModBlocksItems.WORKING_TABLE);
        WORKBENCH_ID = ResourceLocation.parse((String)"pfm:furniture");
        FREEZER_ICON = EmiStack.of((ItemLike)PaladinFurnitureModBlocksItems.WHITE_FREEZER);
        FREEZER_ID = ResourceLocation.parse((String)"pfm:freezer");
    }
}

