/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.jei;

import com.unlikepaladin.pfm.compat.jei.PaladinFurnitureModJEI;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class FurnitureCategory
implements IRecipeCategory<FurnitureRecipe> {
    private final IDrawable BACKGROUND;
    public static final ResourceLocation TEXTURE_GUI_VANILLA = ResourceLocation.parse((String)"pfm:textures/gui/gui_jei.png");
    public final IDrawable ICON;
    public static final Component TITLE = Component.translatable((String)"rei.pfm.furniture");
    private final ICraftingGridHelper craftingGridHelper;
    private static final int craftOutputSlot = 9;
    private static final int craftInputSlot1 = 0;
    private int itemsPerInnerRecipe;
    public static final ResourceLocation IDENTIFIER = ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)"crafting");
    Map<FurnitureRecipe, List<ItemStack>> inputCache = new HashMap<FurnitureRecipe, List<ItemStack>>();
    Map<ItemStack, ItemStack> focusToOutput = new HashMap<ItemStack, ItemStack>();
    Map<FurnitureRecipe, List<List<ItemStack>>> cachedInput = new HashMap<FurnitureRecipe, List<List<ItemStack>>>();
    Map<FurnitureRecipe, List<ItemStack>> cachedOutput = new HashMap<FurnitureRecipe, List<ItemStack>>();
    Map<ItemStack, List<List<ItemStack>>> itemStackListMap = new HashMap<ItemStack, List<List<ItemStack>>>();
    private final Map<FurnitureRecipe, List<ItemStack>> outputs = new HashMap<FurnitureRecipe, List<ItemStack>>();

    public FurnitureCategory(IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)PaladinFurnitureModBlocksItems.WORKING_TABLE));
        this.BACKGROUND = guiHelper.createDrawable(TEXTURE_GUI_VANILLA, 0, 60, 116, 54);
        this.craftingGridHelper = guiHelper.createCraftingGridHelper();
    }

    public RecipeType<FurnitureRecipe> getRecipeType() {
        return PaladinFurnitureModJEI.FURNITURE_RECIPE;
    }

    public Component getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public List<ItemStack> getIngredients(FurnitureRecipe recipe) {
        this.itemsPerInnerRecipe = recipe.getMaxInnerRecipeSize();
        if (!this.inputCache.containsKey(recipe)) {
            ArrayList inputEntries = new ArrayList();
            for (FurnitureRecipe.CraftableFurnitureRecipe innerRecipe : recipe.getInnerRecipes()) {
                List<List<ItemStack>> finalList = this.collectIngredientsFromRecipe(innerRecipe);
                finalList.forEach(inputEntries::addAll);
            }
            this.inputCache.put(recipe, inputEntries);
        }
        return this.inputCache.get(recipe);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, FurnitureRecipe recipe, IFocusGroup focuses) {
        this.itemsPerInnerRecipe = recipe.getMaxInnerRecipeSize();
        List<ItemStack> outputs = this.getOutputEntries(recipe);
        Optional focused = focuses.getItemStackFocuses(RecipeIngredientRole.OUTPUT).findFirst();
        if (focused.isPresent() && ((IFocus)focused.get()).getRole() == RecipeIngredientRole.OUTPUT) {
            ItemStack focusedStack = (ItemStack)((IFocus)focused.get()).getTypedValue().getItemStack().get();
            if (!this.focusToOutput.containsKey(focusedStack)) {
                for (ItemStack stack : outputs) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)focusedStack)) continue;
                    this.focusToOutput.put(focusedStack, stack);
                    break;
                }
            }
            List<ItemStack> output = List.of(this.focusToOutput.get(focusedStack));
            List<List<ItemStack>> inputs = this.collectIngredientsFromRecipe(recipe.getInnerRecipeFromOutput(this.focusToOutput.get(focusedStack)));
            this.craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputs, 3, 3);
            this.craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, output);
        } else {
            if (!this.cachedOutput.containsKey(recipe)) {
                this.cachedOutput.put(recipe, outputs);
            }
            this.craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, this.cachedOutput.get(recipe));
            if (!this.cachedInput.containsKey(recipe)) {
                ArrayList finalInput = new ArrayList(this.itemsPerInnerRecipe);
                for (int i = 0; i < this.itemsPerInnerRecipe; ++i) {
                    finalInput.add(new ArrayList());
                }
                for (FurnitureRecipe.CraftableFurnitureRecipe inner : recipe.getInnerRecipes()) {
                    List<List<ItemStack>> stsk = this.collectIngredientsFromRecipe(inner);
                    for (int i = 0; i < stsk.size(); ++i) {
                        ((List)finalInput.get(i % this.itemsPerInnerRecipe)).addAll((Collection)stsk.get(i));
                    }
                }
                this.cachedInput.put(recipe, finalInput);
            }
            this.craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, this.cachedInput.get(recipe), 3, 3);
        }
    }

    public List<List<ItemStack>> collectIngredientsFromRecipe(FurnitureRecipe.CraftableFurnitureRecipe recipe) {
        if (this.itemStackListMap.containsKey(recipe.getRecipeOuput())) {
            return this.itemStackListMap.get(recipe.getRecipeOuput());
        }
        List<Ingredient> ingredients = recipe.getIngredients();
        HashMap<Item, Integer> containedItems = new HashMap<Item, Integer>();
        for (Ingredient ingredient : ingredients) {
            for (ItemStack stack : ingredient.getItems()) {
                if (!containedItems.containsKey(stack.getItem())) {
                    containedItems.put(stack.getItem(), stack.getCount());
                    continue;
                }
                containedItems.put(stack.getItem(), (Integer)containedItems.get(stack.getItem()) + stack.getCount());
            }
        }
        ArrayList<List<ItemStack>> listOfList = new ArrayList<List<ItemStack>>();
        for (Map.Entry entry : containedItems.entrySet()) {
            listOfList.add(List.of(new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue())));
        }
        if (listOfList.size() != this.itemsPerInnerRecipe) {
            while (listOfList.size() != this.itemsPerInnerRecipe) {
                listOfList.add(List.of());
            }
        }
        this.itemStackListMap.put(recipe.getRecipeOuput(), listOfList);
        return listOfList;
    }

    public List<ItemStack> getOutputEntries(FurnitureRecipe recipe) {
        if (!this.outputs.containsKey(recipe)) {
            this.outputs.put(recipe, recipe.getInnerRecipes().stream().map(FurnitureRecipe.CraftableFurnitureRecipe::getRecipeOuput).toList());
        }
        return this.outputs.get(recipe);
    }
}

