/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.patchouli;

import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class FreezingRecipeProcessor
implements IComponentProcessor {
    private Recipe<?> recipe;

    public void setup(Level level, IVariableProvider variables) {
        String recipeId = variables.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString();
        RecipeManager manager = level.getRecipeManager();
        this.recipe = manager.byKey(ResourceLocation.parse((String)recipeId)).map(RecipeHolder::value).orElse(null);
    }

    @NotNull
    public IVariable process(Level level, String key) {
        if (this.recipe != null) {
            switch (key) {
                case "ingredient": {
                    Ingredient ingredient = (Ingredient)this.recipe.getIngredients().get(0);
                    ItemStack[] stacks = ingredient.getItems();
                    ItemStack stack = stacks.length == 0 ? ItemStack.EMPTY : stacks[0];
                    return IVariable.from((Object)stack, (HolderLookup.Provider)level.registryAccess());
                }
                case "output": {
                    ItemStack result = this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
                    return IVariable.from((Object)result, (HolderLookup.Provider)level.registryAccess());
                }
                case "icon": {
                    ItemStack icon = this.recipe.getToastSymbol();
                    return IVariable.from((Object)icon, (HolderLookup.Provider)level.registryAccess());
                }
                case "text": {
                    ItemStack out = this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
                    return IVariable.wrap((String)(out.getCount() + "x$(br)" + String.valueOf(out.getHoverName())));
                }
                case "icount": {
                    return IVariable.wrap((Number)this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getCount());
                }
                case "iname": {
                    return IVariable.wrap((String)this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getHoverName().getString());
                }
            }
        }
        return IVariable.empty();
    }

    public void refresh(Screen parent, int left, int top) {
        super.refresh(parent, left, top);
    }

    public boolean allowRender(String group) {
        return this.recipe != null;
    }
}

