/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.patchouli;

import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class FurnitureRecipeProcessor
implements IComponentProcessor {
    private FurnitureRecipe recipe;
    private ResourceLocation variant;

    public void setup(Level level, IVariableProvider variables) {
        String recipeId = variables.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString();
        RecipeManager manager = level.getRecipeManager();
        Recipe recipe = manager.byKey(ResourceLocation.parse((String)recipeId)).map(RecipeHolder::value).orElse(null);
        this.recipe = recipe instanceof FurnitureRecipe ? (FurnitureRecipe)recipe : null;
        this.variant = variables.has("variant") ? ResourceLocation.tryParse((String)variables.get("variant", (HolderLookup.Provider)level.registryAccess()).asString()) : null;
    }

    @NotNull
    public IVariable process(Level level, String key) {
        if (this.recipe != null) {
            List<FurnitureRecipe.CraftableFurnitureRecipe> innerRecipeList = this.variant != null ? this.recipe.getInnerRecipesForVariant(this.variant) : this.recipe.getInnerRecipes();
            if (key.startsWith("item")) {
                int index = Integer.parseInt(key.substring(4)) - 1;
                ItemStack[] ingredientsArr = new ItemStack[innerRecipeList.size()];
                for (int i = 0; i < innerRecipeList.size(); ++i) {
                    Ingredient ingredient;
                    ItemStack[] stacks;
                    FurnitureRecipe.CraftableFurnitureRecipe innerRecipe = innerRecipeList.get(i);
                    ingredientsArr[i] = index >= innerRecipe.getIngredients().size() ? ItemStack.EMPTY : ((stacks = (ingredient = innerRecipe.getIngredients().get(index)).getItems()).length == 0 ? ItemStack.EMPTY : stacks[0]);
                }
                return IVariable.from((Object)ingredientsArr, (HolderLookup.Provider)level.registryAccess());
            }
            if (key.equals("resultitem")) {
                ItemStack[] resultsArr = new ItemStack[innerRecipeList.size()];
                for (int i = 0; i < innerRecipeList.size(); ++i) {
                    FurnitureRecipe.CraftableFurnitureRecipe innerRecipe = innerRecipeList.get(i);
                    resultsArr[i] = innerRecipe.getResultItem((HolderLookup.Provider)level.registryAccess());
                }
                return IVariable.from((Object)resultsArr, (HolderLookup.Provider)level.registryAccess());
            }
            if (key.equals("icon")) {
                ItemStack icon = this.recipe.getToastSymbol();
                return IVariable.from((Object)icon, (HolderLookup.Provider)level.registryAccess());
            }
            if (key.equals("text")) {
                return IVariable.wrap((String)(this.recipe.getOutputCount((HolderLookup.Provider)level.registryAccess()) + "x$(br)" + this.recipe.getName((HolderLookup.Provider)level.registryAccess())));
            }
            if (key.equals("icount")) {
                return IVariable.wrap((Number)this.recipe.getOutputCount((HolderLookup.Provider)level.registryAccess()));
            }
            if (key.equals("iname")) {
                return IVariable.wrap((String)this.recipe.getName((HolderLookup.Provider)level.registryAccess()));
            }
        }
        return IVariable.empty();
    }

    public void refresh(Screen parent, int left, int top) {
        super.refresh(parent, left, top);
    }
}

