/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.rei;

import com.google.common.collect.Lists;
import com.unlikepaladin.pfm.compat.rei.FurnitureDisplay;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.DisplayMerger;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class FurnitureCategory
implements DisplayCategory<FurnitureDisplay> {
    public static final EntryStack<ItemStack> ICON = EntryStacks.of((ItemLike)PaladinFurnitureModBlocksItems.WORKING_TABLE);
    public static final Component TITLE = Component.translatable((String)"rei.pfm.furniture");

    public CategoryIdentifier<? extends FurnitureDisplay> getCategoryIdentifier() {
        return FurnitureDisplay.IDENTIFIER;
    }

    public Renderer getIcon() {
        return ICON;
    }

    public Component getTitle() {
        return TITLE;
    }

    public List<Widget> setupDisplay(FurnitureDisplay display, Rectangle bounds) {
        HashMap<EntryStack, Integer> stackToSlotIndex = new HashMap<EntryStack, Integer>();
        Point startPoint = new Point(bounds.getCenterX() - 58, bounds.getCenterY() - 27);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createArrow((Point)new Point(startPoint.x + 60, startPoint.y + 18)));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 95, startPoint.y + 19)));
        List<EntryIngredient> input = display.getInputEntries();
        Slot output = Widgets.createSlot((Point)new Point(startPoint.x + 95, startPoint.y + 19)).disableBackground().markOutput();
        int recipeIndex = 0;
        for (EntryIngredient ingredient : display.getOutputEntries()) {
            output.entries((Collection)ingredient);
            stackToSlotIndex.put((EntryStack)ingredient.get(0), recipeIndex);
            ++recipeIndex;
        }
        widgets.add(output);
        ArrayList slots = Lists.newArrayList();
        int innerRecipeSize = display.itemsPerInnerRecipe();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                Slot inputSlot = Widgets.createSlot((Point)new Point(startPoint.x + 1 + x * 18, startPoint.y + 1 + y * 18)).markInput();
                slots.add(inputSlot);
            }
        }
        int i = 0;
        while (i < innerRecipeSize) {
            int finalSlotIndex = i++;
            widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
                Integer currentRecipe = (Integer)stackToSlotIndex.get(output.getCurrentEntry());
                if (currentRecipe != null && input.size() > finalSlotIndex + currentRecipe * innerRecipeSize) {
                    ((Slot)slots.get(finalSlotIndex)).clearEntries().entries((Collection)input.get(finalSlotIndex + currentRecipe * innerRecipeSize));
                }
            }));
        }
        widgets.addAll(slots);
        return widgets;
    }

    @Nullable
    public DisplayMerger<FurnitureDisplay> getDisplayMerger() {
        return DisplayCategory.getContentMerger();
    }
}

