/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.rei;

import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class FurnitureDisplay
implements Display {
    protected RecipeHolder<FurnitureRecipe> recipe;
    public static final CategoryIdentifier<FurnitureDisplay> IDENTIFIER = CategoryIdentifier.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)"furniture"));
    private int itemsPerInnerRecipe;
    private final List<EntryIngredient> inputs = new ArrayList<EntryIngredient>();
    private final List<EntryIngredient> outputs = new ArrayList<EntryIngredient>();

    public FurnitureDisplay(RecipeHolder<FurnitureRecipe> entry) {
        this.recipe = entry;
        this.itemsPerInnerRecipe = ((FurnitureRecipe)entry.value()).getIngredients().size();
    }

    public List<EntryIngredient> getInputEntries() {
        if (!this.inputs.isEmpty()) {
            return this.inputs;
        }
        ArrayList inputEntries = new ArrayList();
        this.itemsPerInnerRecipe = ((FurnitureRecipe)this.recipe.value()).getMaxInnerRecipeSize();
        for (FurnitureRecipe.CraftableFurnitureRecipe innerRecipe : ((FurnitureRecipe)this.recipe.value()).getInnerRecipes()) {
            List<Ingredient> ingredients = innerRecipe.getIngredients();
            HashMap<Item, Integer> containedItems = new HashMap<Item, Integer>();
            for (Ingredient ingredient : ingredients) {
                for (ItemStack stack : ingredient.getItems()) {
                    if (!containedItems.containsKey(stack.getItem())) {
                        containedItems.put(stack.getItem(), stack.getCount());
                        continue;
                    }
                    containedItems.put(stack.getItem(), (Integer)containedItems.get(stack.getItem()) + stack.getCount());
                }
            }
            ArrayList<Ingredient> finalList = new ArrayList<Ingredient>();
            for (Map.Entry entry : containedItems.entrySet()) {
                finalList.add(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue())}));
            }
            finalList.sort(Comparator.comparing(o -> o.getItems()[0].getItem().toString()));
            if (finalList.size() != this.itemsPerInnerRecipe) {
                while (finalList.size() != this.itemsPerInnerRecipe) {
                    finalList.add(Ingredient.EMPTY);
                }
            }
            inputEntries.addAll(finalList);
        }
        for (Ingredient ingredient : inputEntries) {
            if (!ingredient.isEmpty()) {
                this.inputs.add(EntryIngredients.ofIngredient((Ingredient)ingredient));
                continue;
            }
            this.inputs.add(EntryIngredient.empty());
        }
        return this.inputs;
    }

    public int itemsPerInnerRecipe() {
        return this.itemsPerInnerRecipe;
    }

    public List<EntryIngredient> getOutputEntries() {
        if (this.outputs.isEmpty()) {
            this.outputs.addAll(((FurnitureRecipe)this.recipe.value()).getInnerRecipes().stream().map(FurnitureRecipe.CraftableFurnitureRecipe::getRecipeOuput).map(EntryIngredients::of).toList());
        }
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return IDENTIFIER;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.of(this.recipe.id());
    }
}

