/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.config.option;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.config.option.AbstractConfigOption;
import com.unlikepaladin.pfm.config.option.ConfigOptionTypes;
import com.unlikepaladin.pfm.config.option.ConfigSizeTracker;
import com.unlikepaladin.pfm.config.option.NullConfigOption;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import org.jetbrains.annotations.Nullable;

public class ConfigIO {
    public static AbstractConfigOption readCompressed(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            AbstractConfigOption option;
            AbstractConfigOption abstractConfigOption = option = ConfigIO.readCompressed(inputStream);
            return abstractConfigOption;
        }
    }

    public static AbstractConfigOption readCompressed(InputStream stream) throws IOException {
        try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(stream)));){
            AbstractConfigOption nbtCompound;
            AbstractConfigOption abstractConfigOption = nbtCompound = ConfigIO.read(dataInputStream, ConfigSizeTracker.EMPTY);
            return abstractConfigOption;
        }
    }

    public static void writeCompressed(AbstractConfigOption compound, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            ConfigIO.writeCompressed(compound, outputStream);
        }
    }

    public static void writeCompressed(AbstractConfigOption compound, OutputStream stream) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(stream)));){
            ConfigIO.write(compound, dataOutputStream);
        }
    }

    public static void write(AbstractConfigOption compound, File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);){
            ConfigIO.write(compound, dataOutputStream);
        }
    }

    @Nullable
    public static AbstractConfigOption read(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            AbstractConfigOption nbtCompound;
            try (DataInputStream dataInputStream = new DataInputStream(fileInputStream);){
                nbtCompound = ConfigIO.read(dataInputStream, ConfigSizeTracker.EMPTY);
            }
            AbstractConfigOption abstractConfigOption = nbtCompound;
            return abstractConfigOption;
        }
    }

    public static AbstractConfigOption read(DataInput input) throws IOException {
        return ConfigIO.read(input, ConfigSizeTracker.EMPTY);
    }

    public static AbstractConfigOption read(DataInput input, ConfigSizeTracker tracker) throws IOException {
        AbstractConfigOption configOption = ConfigIO.read(input, 0, tracker);
        if (configOption != null) {
            return configOption;
        }
        throw new IOException("Object was not instance of AbstractConfig");
    }

    protected static void write(AbstractConfigOption element, DataOutput output) throws IOException {
        output.writeByte(element.getConfigType());
        if (element.getType() != Boolean.class) {
            PaladinFurnitureMod.GENERAL_LOGGER.warn("Unsupported Type: " + String.valueOf(element.getType()));
            return;
        }
        element.write(output);
    }

    private static AbstractConfigOption read(DataInput input, int depth, ConfigSizeTracker tracker) throws IOException {
        byte b = input.readByte();
        if (b == 0) {
            return NullConfigOption.INSTANCE;
        }
        try {
            return ConfigOptionTypes.byId(b).read(input, depth, tracker);
        }
        catch (IOException iOException) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)iOException, (String)"Loading Config data");
            CrashReportCategory crashReportSection = crashReport.addCategory("Config Element");
            crashReportSection.setDetail("Config type", (Object)b);
            throw new ReportedException(crashReport);
        }
    }
}

