/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.mixin.PFMFeatureFlagFactory;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ExtraStoolVariant
extends VariantBase<ExtraStoolVariant> {
    public static ExtraStoolVariant GRAY_DARK_OAK = new ExtraStoolVariant(Blocks.GRAY_CONCRETE, Blocks.STRIPPED_DARK_OAK_LOG, "gray_dark_oak");
    public static ExtraStoolVariant WHITE = new ExtraStoolVariant(Blocks.WHITE_CONCRETE, Blocks.LIGHT_GRAY_CONCRETE, "white");
    public static ExtraStoolVariant GRAY = new ExtraStoolVariant(null, Blocks.LIGHT_GRAY_CONCRETE, "gray");
    public static ExtraStoolVariant LIGHT_GRAY_DARK_OAK = new ExtraStoolVariant(Blocks.LIGHT_GRAY_CONCRETE, Blocks.STRIPPED_DARK_OAK_LOG, "light_gray_dark_oak");
    private final String name;
    private final Block baseBlock;
    private final Block secondaryBlock;
    static final List<ExtraStoolVariant> DEFAULT_VARIANTS = new ArrayList<ExtraStoolVariant>();

    public static List<ExtraStoolVariant> values() {
        if (DEFAULT_VARIANTS.isEmpty()) {
            DEFAULT_VARIANTS.add(GRAY_DARK_OAK);
            DEFAULT_VARIANTS.add(WHITE);
            DEFAULT_VARIANTS.add(GRAY);
            DEFAULT_VARIANTS.add(LIGHT_GRAY_DARK_OAK);
        }
        return DEFAULT_VARIANTS;
    }

    ExtraStoolVariant(ResourceLocation identifier, Block baseBlock, Block secondaryBlock) {
        super(identifier);
        this.name = identifier.getPath();
        this.baseBlock = baseBlock;
        this.secondaryBlock = secondaryBlock;
    }

    ExtraStoolVariant(Block baseBlock, Block secondaryBlock, String name) {
        this(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)name), baseBlock, secondaryBlock);
    }

    public String getSerializedName() {
        return this.name;
    }

    @Override
    public Block getBaseBlock() {
        if (this.baseBlock == null) {
            return PaladinFurnitureModBlocksItems.RAW_CONCRETE;
        }
        return this.baseBlock;
    }

    @Override
    public Block getSecondaryBlock() {
        return this.secondaryBlock;
    }

    public static Optional<ExtraStoolVariant> getOptionalVariant(ResourceLocation name) {
        return DEFAULT_VARIANTS.stream().filter(extraStoolVariant -> extraStoolVariant.identifier.equals((Object)name)).findFirst();
    }

    @Override
    public boolean isNetherWood() {
        return false;
    }

    @Override
    public ExtraStoolVariant getVariantType() {
        return this;
    }

    @Override
    public List<FeatureFlag> getFeatureList() {
        FeatureFlag flag = PFMFeatureFlagFactory.newFlag(this.getBaseBlock().requiredFeatures().universe, 0);
        flag.mask = this.getBaseBlock().requiredFeatures().mask;
        return List.of(flag);
    }

    @Override
    public boolean isVanilla() {
        return this.identifier.getNamespace().equals("") || this.identifier.getNamespace().equals("minecraft");
    }

    @Override
    public void initializeChildrenBlocks() {
    }

    @Override
    public void initializeChildrenItems() {
    }

    @Override
    public Block mainChild() {
        return this.getBaseBlock();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture(BlockType type) {
        if (type == BlockType.SECONDARY) {
            return ModelHelper.getTextureId(this.getSecondaryBlock());
        }
        return ModelHelper.getTextureId(this.getBaseBlock());
    }

    @Override
    public String getPath() {
        return this.identifier.getPath();
    }
}

