/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.unlikepaladin.pfm.data.materials.StoneVariant;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.VariantRegistryBase;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import org.jetbrains.annotations.Nullable;

public class StoneVariantRegistry
extends VariantRegistryBase<StoneVariant> {
    public static final StoneVariant STONE = new StoneVariant(ResourceLocation.parse((String)"stone"), Blocks.STONE, Blocks.COBBLESTONE);
    public static final StoneVariantRegistry INSTANCE = new StoneVariantRegistry();

    public static Collection<String> getNamespaces() {
        return StoneVariantRegistry.INSTANCE.variants.values().stream().map(VariantBase::getNamespace).collect(Collectors.toUnmodifiableList());
    }

    public static Collection<StoneVariant> getVariants() {
        return Collections.unmodifiableCollection(StoneVariantRegistry.INSTANCE.variants.values());
    }

    @Nullable
    public static StoneVariant getVariant(ResourceLocation name) {
        return StoneVariantRegistry.INSTANCE.variants.getOrDefault(name, STONE);
    }

    public static Optional<StoneVariant> getOptionalVariant(ResourceLocation name) {
        return StoneVariantRegistry.INSTANCE.variants.containsKey(name) ? Optional.of((StoneVariant)StoneVariantRegistry.INSTANCE.variants.get(name)) : Optional.empty();
    }

    @Override
    public Optional<StoneVariant> getVariantFromBlock(Block baseBlock, ResourceLocation blockId) {
        BlockState state;
        String name = null;
        String path = blockId.getPath();
        if (blockId.getNamespace().equals("tfc")) {
            Optional cobble;
            if (path.contains("rock/polished/") && (cobble = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)path.replace("polished", "raw")))).isPresent()) {
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)path.replace("rock/polished/", ""));
                return Optional.of(new StoneVariant(id, baseBlock, (Block)cobble.get()));
            }
            return Optional.empty();
        }
        if (path.endsWith("_polished")) {
            name = path.substring(0, path.length() - "_polished".length());
        } else if (path.startsWith("polished_")) {
            name = path.substring("polished_".length());
        } else if (path.endsWith("_polish")) {
            name = path.substring(0, path.length() - "_polish".length());
        } else if (path.startsWith("polish_")) {
            name = path.substring("polish_".length());
        }
        String namespace = blockId.getNamespace();
        if (!(namespace.equals("cozy_home") || namespace.equals("adorn") || name == null || namespace.equals("securitycraft") || namespace.equals("absentbydesign") || namespace.equals("chipped") || namespace.equals("polydecorations") || namespace.equals("extshape") || namespace.equals("modernlife") || namespace.equals("ars_nouveau") && path.contains("sconce") || namespace.equals("excessive_building") || (state = baseBlock.defaultBlockState()).getProperties().size() > 2 || baseBlock instanceof SlabBlock || name.contains("slab") || baseBlock instanceof BasePressurePlateBlock || name.contains("pressure_plate"))) {
            SoundType soundGroup = state.getSoundType();
            NoteBlockInstrument instrument = state.instrument();
            if (soundGroup == SoundType.DEEPSLATE || soundGroup == SoundType.POLISHED_DEEPSLATE || soundGroup == SoundType.STONE || instrument == NoteBlockInstrument.BASEDRUM) {
                name = name.replace("/", "_");
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)name);
                Block rawBlock = StoneVariantRegistry.findRaw(id);
                if (rawBlock != null) {
                    return Optional.of(new StoneVariant(id, baseBlock, rawBlock));
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public StoneVariant getDefaultType() {
        return STONE;
    }

    @Override
    public Class<StoneVariant> getType() {
        return StoneVariant.class;
    }

    @Nullable
    private static Block findRaw(ResourceLocation id) {
        ResourceLocation[] test = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getPath()), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)(id.getPath() + "raw")), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)(id.getPath() + "_raw")), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("raw_" + id.getPath())), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("raw" + id.getPath())), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)(id.getPath() + "_cobble")), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)(id.getPath() + "cobble")), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("cobble_" + id.getPath())), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("cobble" + id.getPath())), ResourceLocation.parse((String)id.getPath()), ResourceLocation.parse((String)(id.getPath() + "raw")), ResourceLocation.parse((String)(id.getPath() + "_raw")), ResourceLocation.parse((String)("raw_" + id.getPath())), ResourceLocation.parse((String)("raw" + id.getPath())), ResourceLocation.parse((String)(id.getPath() + "_cobble")), ResourceLocation.parse((String)(id.getPath() + "cobble")), ResourceLocation.parse((String)("cobble_" + id.getPath())), ResourceLocation.parse((String)("cobble" + id.getPath()))};
        Block temp = null;
        for (ResourceLocation r : test) {
            if (!BuiltInRegistries.BLOCK.containsKey(r)) continue;
            temp = (Block)BuiltInRegistries.BLOCK.get(r);
            break;
        }
        return temp;
    }
}

