/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.unlikepaladin.pfm.blocks.blockentities.PFMBedBlockEntity;
import com.unlikepaladin.pfm.client.EntityRenderIDs;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class PFMBedBlockEntityRenderer
implements BlockEntityRenderer<PFMBedBlockEntity> {
    private final ModelPart bedHead;
    private final ModelPart bedFoot;

    public PFMBedBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.bedHead = ctx.bakeLayer(EntityRenderIDs.BED_HEAD_LAYER);
        this.bedFoot = ctx.bakeLayer(EntityRenderIDs.BED_FOOT_LAYER);
    }

    public static LayerDefinition getFootTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition group = modelPartData.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)8.0f, (float)24.0f, (float)-8.0f));
        PartDefinition foot_r1 = group.addOrReplaceChild("foot_r1", CubeListBuilder.create().texOffs(2, 24).addBox(-8.0f, -11.0f, -8.0f, 16.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.0f, (float)-1.0f, (float)11.0f, (float)-1.5708f, (float)3.1416f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public static LayerDefinition getHeadTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition group = modelPartData.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)8.0f, (float)24.0f, (float)-8.0f));
        PartDefinition head_r1 = group.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(2, 2).addBox(-28.0f, -5.0f, -3.0f, 16.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-28.0f, (float)-6.0f, (float)8.0f, (float)-1.5708f, (float)3.1416f, (float)0.0f));
        PartDefinition pillow = group.addOrReplaceChild("pillow", CubeListBuilder.create(), PartPose.offset((float)-28.0f, (float)-5.0f, (float)8.0f));
        PartDefinition head_r2 = pillow.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(7, 5).mirror().addBox(-20.0f, -5.0f, -5.0f, 7.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(7, 5).addBox(-27.0f, -5.0f, -5.0f, 7.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)3.1416f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void render(PFMBedBlockEntity bedBlockEntity, float f, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, int j) {
        Level world2;
        Material spriteIdentifier = bedBlockEntity != null ? Sheets.BED_TEXTURES[bedBlockEntity.getColor().getId()] : Sheets.BED_TEXTURES[DyeColor.WHITE.getId()];
        Level level = world2 = bedBlockEntity != null ? bedBlockEntity.getLevel() : null;
        if (world2 != null) {
            BlockState blockState = bedBlockEntity.getBlockState();
            DoubleBlockCombiner.NeighborCombineResult propertySource = DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)BlockEntityType.BED, BedBlock::getBlockType, BedBlock::getConnectedDirection, (DirectionProperty)ChestBlock.FACING, (BlockState)blockState, (LevelAccessor)world2, (BlockPos)bedBlockEntity.getBlockPos(), (world, pos) -> false);
            int k = ((Int2IntFunction)propertySource.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(i);
            this.renderPart(matrixStack, vertexConsumerProvider, blockState.getValue((Property)BedBlock.PART) == BedPart.HEAD ? this.bedHead : this.bedFoot, (Direction)blockState.getValue((Property)BedBlock.FACING), spriteIdentifier, k, j, false);
        } else {
            matrixStack.pushPose();
            matrixStack.mulPose(Axis.YP.rotationDegrees(270.0f));
            matrixStack.translate(0.0, 0.0, -2.0);
            this.renderPart(matrixStack, vertexConsumerProvider, this.bedHead, Direction.NORTH, spriteIdentifier, i, j, false);
            matrixStack.translate(0.0, 0.0, 1.0);
            this.renderPart(matrixStack, vertexConsumerProvider, this.bedFoot, Direction.NORTH, spriteIdentifier, i, j, true);
            matrixStack.popPose();
        }
    }

    private void renderPart(PoseStack matrix, MultiBufferSource vertexConsumers, ModelPart part, Direction direction, Material sprite, int light, int overlay, boolean isFoot) {
        matrix.pushPose();
        matrix.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrix.translate(0.5, -1.5, 0.0);
        matrix.mulPose(Axis.YP.rotationDegrees(direction.toYRot()));
        switch (direction) {
            case EAST: {
                matrix.translate(-0.5, 0.0, 0.0);
                break;
            }
            case WEST: {
                matrix.translate(0.5, 0.0, 0.0);
                break;
            }
            case NORTH: {
                matrix.translate(0.0, 0.0, 0.5);
                break;
            }
            case SOUTH: {
                matrix.translate(0.0, 0.0, -0.5);
            }
        }
        VertexConsumer vertexConsumer = sprite.buffer(vertexConsumers, RenderType::entitySolid);
        part.render(matrix, vertexConsumer, light, overlay);
        matrix.popPose();
    }
}

