/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.fabric.menus.slots;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GenericOutputSlot
extends Slot {
    private final Player player;
    private int amount;
    public int maxItemCount;

    public GenericOutputSlot(Player player, Container inventory, int index, int x, int y, int maxItemCount) {
        super(inventory, index, x, y);
        this.player = player;
        this.maxItemCount = maxItemCount;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.amount += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    public void onTake(Player player, ItemStack stack) {
        this.checkTakeAchievements(stack);
        super.onTake(player, stack);
    }

    protected void onQuickCraft(ItemStack stack, int amount) {
        this.amount += amount;
        this.checkTakeAchievements(stack);
    }

    public int getMaxStackSize() {
        return this.maxItemCount == 0 ? (this.maxItemCount = super.getMaxStackSize()) : this.maxItemCount;
    }

    protected void checkTakeAchievements(ItemStack stack) {
        stack.onCraftedBy(this.player.level(), this.player, this.amount);
        this.amount = 0;
    }
}

