/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.items;

import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.blocks.blockentities.DyeableFurnitureBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class DyeKit
extends Item {
    private final DyeColor color;

    public DyeKit(Item.Properties settings, DyeColor color) {
        super(settings);
        this.color = color;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public InteractionResult useOn(UseOnContext context) {
        Player playerEntity = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockPos blockPos = context.getClickedPos();
        Level world = context.getLevel();
        BlockState blockState = world.getBlockState(blockPos);
        if (playerEntity.isShiftKeyDown()) {
            boolean dyed = false;
            if (blockState.getBlock() instanceof DyeableFurnitureBlock && stack.getItem() instanceof DyeKit) {
                world.playSound(null, blockPos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                String newBlock = blockState.getBlock().toString();
                newBlock = newBlock.replace(((DyeableFurnitureBlock)blockState.getBlock()).getPFMColor().toString(), this.getColor().toString()).replace("block.pfm.", "").replace("Block{", "").replace("}", "");
                BlockState blockState1 = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)newBlock))).withPropertiesOf(blockState);
                world.setBlock(blockPos, blockState1, 3);
                stack.shrink(1);
                dyed = true;
            }
            if (world.getBlockEntity(blockPos) instanceof DyeableFurnitureBlockEntity && stack.getItem() instanceof DyeKit) {
                world.playSound(null, blockPos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                DyeableFurnitureBlockEntity dyeableFurnitureBlockEntity = (DyeableFurnitureBlockEntity)world.getBlockEntity(blockPos);
                dyeableFurnitureBlockEntity.setPFMColor(this.getColor());
                world.sendBlockUpdated(blockPos, blockState, blockState, 3);
                if (!dyed) {
                    stack.shrink(1);
                }
                dyed = true;
            }
            if (dyed) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        Sheep sheepEntity;
        if (entity instanceof Sheep && (sheepEntity = (Sheep)entity).isAlive() && !sheepEntity.isSheared() && sheepEntity.getColor() != ((DyeKit)stack.getItem()).getColor()) {
            sheepEntity.getCommandSenderWorld().playSound(user, (Entity)sheepEntity, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!user.level().isClientSide) {
                sheepEntity.setColor(this.color);
                stack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)user.level().isClientSide);
        }
        return InteractionResult.PASS;
    }
}

