/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.items;

import com.unlikepaladin.pfm.blocks.BasicShowerHandleBlock;
import com.unlikepaladin.pfm.blocks.BasicShowerHeadBlock;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ShowerHandleItem
extends BlockItem {
    private Supplier<BasicShowerHandleBlock> block;

    public ShowerHandleItem(Supplier<BasicShowerHandleBlock> block, Item.Properties settings) {
        super((Block)block.get(), settings);
        this.block = block;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (player.isShiftKeyDown()) {
            stack.remove(DataComponents.BLOCK_ENTITY_DATA);
            ShowerHandleItem.createNbt(stack);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        super.useOn(context);
        BlockPos pos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        Block block = state.getBlock();
        if (block instanceof BasicShowerHeadBlock) {
            this.setShowerHeadPosNBT(context.getItemInHand(), pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        boolean canPlace;
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        LongTag showerHeadLong = ShowerHandleItem.getShowerHead(context.getItemInHand());
        Direction playerFacing = context.getHorizontalDirection();
        Direction placeDirection = context.getClickedFace();
        boolean bl = canPlace = state.canSurvive((LevelReader)world, pos) && placeDirection.getAxis().isHorizontal();
        if (!canPlace) {
            return false;
        }
        if (showerHeadLong != null) {
            BlockPos placedPos;
            BlockPos headPos = BlockPos.of((long)showerHeadLong.getAsLong());
            double distance = Math.sqrt(headPos.distToLowCornerSqr((double)(placedPos = pos.relative(playerFacing)).getX() + 0.5, (double)placedPos.getY() + 0.5, (double)placedPos.getZ() + 0.5));
            if (distance > 16.0 && world.isClientSide()) {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"message.pfm.shower_handle_far", (Object[])new Object[]{headPos.toString()}), false);
            }
            if (distance > 16.0) {
                context.getItemInHand().remove(DataComponents.BLOCK_ENTITY_DATA);
                ShowerHandleItem.createNbt(context.getItemInHand());
            } else {
                this.setShowerHeadPosNBT(context.getItemInHand(), pos.subtract((Vec3i)headPos));
            }
            return state.canSurvive((LevelReader)world, pos) && placeDirection.getAxis().isHorizontal();
        }
        return true;
    }

    private void setShowerHeadPosNBT(ItemStack stack, BlockPos pos) {
        LongTag showerHeadPos;
        CompoundTag nbtCompound = ShowerHandleItem.createNbt(stack);
        if (!nbtCompound.contains("showerHead", 4)) {
            nbtCompound.put("showerHead", (Tag)LongTag.valueOf((long)0L));
        }
        if ((showerHeadPos = (LongTag)nbtCompound.get("showerHead")).getAsLong() != pos.asLong()) {
            nbtCompound.put("showerHead", (Tag)LongTag.valueOf((long)pos.asLong()));
        }
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)nbtCompound));
    }

    @Nullable
    public static LongTag getShowerHead(ItemStack stack) {
        CompoundTag blockEntityTag;
        if (stack.has(DataComponents.BLOCK_ENTITY_DATA) && (blockEntityTag = ((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).getUnsafe()).contains("showerHead", 4)) {
            return (LongTag)blockEntityTag.get("showerHead");
        }
        return null;
    }

    private static CompoundTag createNbt(ItemStack stack) {
        if (!stack.has(DataComponents.BLOCK_ENTITY_DATA)) {
            CompoundTag nbtCompound = new CompoundTag();
            nbtCompound.putString("id", "pfm:shower_handle_block_entity");
            stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)nbtCompound));
        }
        return ((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).copyTag();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        if (stack.has(DataComponents.BLOCK_ENTITY_DATA) && ShowerHandleItem.getShowerHead(stack) != null) {
            tooltip.add((Component)Component.translatable((String)"tooltip.pfm.shower_handle_connected", (Object[])new Object[]{1}));
        }
        super.appendHoverText(stack, context, tooltip, type);
    }
}

