/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.menus;

import com.unlikepaladin.pfm.blocks.blockentities.MicrowaveBlockEntity;
import com.unlikepaladin.pfm.fabric.menus.slots.SizeableSlot;
import com.unlikepaladin.pfm.menus.neoforge.AbstractMicrowaveScreenHandlerImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public abstract class AbstractMicrowaveScreenHandler
extends RecipeBookMenu<SingleRecipeInput, AbstractCookingRecipe> {
    private final Container inventory;
    private final ContainerData propertyDelegate;
    protected final Level world;
    private final RecipeType<? extends AbstractCookingRecipe> recipeType;
    private final RecipeBookType category;
    public boolean isActive;
    public MicrowaveBlockEntity microwaveBlockEntity;
    public static final StreamCodec<RegistryFriendlyByteBuf, MicrowaveData> PACKET_CODEC = StreamCodec.ofMember(MicrowaveData::write, MicrowaveData::new);

    protected AbstractMicrowaveScreenHandler(MenuType<?> type, RecipeType<? extends AbstractCookingRecipe> recipeType, RecipeBookType category, int syncId, Inventory playerInventory, MicrowaveData packet) {
        this((MicrowaveBlockEntity)playerInventory.player.level().getBlockEntity(packet.pos()), type, recipeType, category, syncId, playerInventory, (Container)new SimpleContainer(1), (ContainerData)new SimpleContainerData(2));
        this.isActive = packet.isActive();
    }

    protected AbstractMicrowaveScreenHandler(MicrowaveBlockEntity microwaveBlockEntity, MenuType<?> type, RecipeType<? extends AbstractCookingRecipe> recipeType, RecipeBookType category, int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super(type, syncId);
        int i;
        this.microwaveBlockEntity = microwaveBlockEntity;
        this.recipeType = recipeType;
        this.category = category;
        AbstractMicrowaveScreenHandler.checkContainerSize((Container)inventory, (int)1);
        AbstractMicrowaveScreenHandler.checkContainerDataCount((ContainerData)propertyDelegate, (int)2);
        this.inventory = inventory;
        inventory.startOpen(playerInventory.player);
        this.propertyDelegate = propertyDelegate;
        this.world = playerInventory.player.getCommandSenderWorld();
        this.addSlot(new SizeableSlot(playerInventory.player, inventory, 0, 78, 40));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
        this.addDataSlots(propertyDelegate);
    }

    public void fillCraftSlotsStackedContents(StackedContents finder) {
        if (this.inventory instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.inventory).fillStackedContents(finder);
        }
    }

    public boolean getActive() {
        return this.isActive;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setActive(MicrowaveBlockEntity blockEntity, boolean isActive) {
        void var1_1;
        AbstractMicrowaveScreenHandlerImpl.setActive(blockEntity, (boolean)var1_1);
    }

    public void clearCraftingContent() {
        this.getSlot(0).setByPlayer(ItemStack.EMPTY);
    }

    public boolean recipeMatches(RecipeHolder<AbstractCookingRecipe> recipe) {
        return recipe != null && recipe.value() != null && ((AbstractCookingRecipe)recipe.value()).matches(new SingleRecipeInput(this.inventory.getItem(0)), this.world);
    }

    public int getResultSlotIndex() {
        return 1;
    }

    public int getGridWidth() {
        return 1;
    }

    public int getGridHeight() {
        return 1;
    }

    public int getSize() {
        return 1;
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public Container getInventory() {
        return this.inventory;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index == 0 ? !this.moveItemStackTo(itemStack2, 3, 37, false) : (this.isCookable(itemStack2) ? !this.insertItemToSlot(itemStack2, 0, 1, false) : (index >= 3 && index < 30 ? !this.moveItemStackTo(itemStack2, 30, 37, false) : index >= 30 && index < 37 && !this.moveItemStackTo(itemStack2, 3, 30, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack2);
        }
        return itemStack;
    }

    protected boolean insertItemToSlot(ItemStack stack, int startIndex, int endIndex, boolean fromLast) {
        boolean bl = false;
        int i = startIndex;
        if (fromLast) {
            i = endIndex - 1;
        }
        if (!stack.isEmpty()) {
            int n = i = fromLast ? endIndex - 1 : startIndex;
            while (fromLast ? i >= startIndex : i < endIndex) {
                Slot slot = (Slot)this.slots.get(i);
                ItemStack itemStack = slot.getItem();
                if (itemStack.isEmpty() && slot.mayPlace(stack)) {
                    if (stack.getCount() > slot.getMaxStackSize()) {
                        slot.setByPlayer(stack.split(slot.getMaxStackSize()));
                    } else {
                        slot.setByPlayer(stack.split(stack.getCount()));
                    }
                    slot.setChanged();
                    bl = true;
                    break;
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return bl;
    }

    protected boolean isCookable(ItemStack itemStack) {
        Optional optionalRecipeEntry = this.world.getRecipeManager().getRecipeFor(this.recipeType, (RecipeInput)new SingleRecipeInput(itemStack), this.world);
        return optionalRecipeEntry != null && optionalRecipeEntry.isPresent() && ((RecipeHolder)optionalRecipeEntry.get()).value() != null;
    }

    public int getCookProgress() {
        int i = this.propertyDelegate.get(0);
        int j = this.propertyDelegate.get(1);
        if (j == 0 || i == 0) {
            return 0;
        }
        return i * 24 / j;
    }

    public boolean isActive() {
        return this.propertyDelegate.get(0) != 0;
    }

    public RecipeBookType getRecipeBookType() {
        return this.category;
    }

    public boolean shouldMoveToInventory(int index) {
        return true;
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.stopOpen(player);
    }

    public record MicrowaveData(BlockPos pos, Boolean isActive) {
        public MicrowaveData(RegistryFriendlyByteBuf buf) {
            this(buf.readBlockPos(), buf.readBoolean());
        }

        public void write(RegistryFriendlyByteBuf buf) {
            buf.writeBlockPos(this.pos);
            buf.writeBoolean(this.isActive.booleanValue());
        }
    }
}

