/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.menus;

import com.google.common.collect.Lists;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import com.unlikepaladin.pfm.registry.ScreenHandlerIDs;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WorkbenchScreenHandler
extends AbstractContainerMenu {
    private final ContainerLevelAccess context;
    private final List<FurnitureRecipe.CraftableFurnitureRecipe> availableRecipes = Lists.newArrayList();
    public static final List<FurnitureRecipe.CraftableFurnitureRecipe> ALL_RECIPES = Lists.newArrayList();
    private final List<FurnitureRecipe.CraftableFurnitureRecipe> sortedRecipes = Lists.newArrayList();
    private final List<FurnitureRecipe.CraftableFurnitureRecipe> searchableRecipes = Lists.newArrayList();
    private final DataSlot selectedRecipe = DataSlot.standalone();
    private final Level world;
    final Slot outputSlot;
    final ResultContainer output = new ResultContainer();
    long lastTakeTime;
    final Inventory playerInventory;
    Runnable contentsChangedListener;
    public boolean searching = false;

    public WorkbenchScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.NULL);
    }

    public WorkbenchScreenHandler(int syncId, Inventory playerInventory, final ContainerLevelAccess context) {
        super(ScreenHandlerIDs.WORKBENCH_SCREEN_HANDLER, syncId);
        int i;
        this.context = context;
        this.world = playerInventory.player.level();
        this.playerInventory = playerInventory;
        this.contentsChangedListener = () -> {};
        this.outputSlot = this.addSlot(new Slot((Container)this.output, 0, 143, 50){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                if (WorkbenchScreenHandler.this.craft()) {
                    stack.onCraftedBy(player.level(), player, stack.getCount());
                    WorkbenchScreenHandler.this.output.awardUsedRecipes(player, List.of());
                    WorkbenchScreenHandler.this.populateResult(player);
                    context.execute((world, pos) -> {
                        long l = world.getGameTime();
                        if (WorkbenchScreenHandler.this.lastTakeTime != l) {
                            world.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                            WorkbenchScreenHandler.this.lastTakeTime = l;
                        }
                    });
                    WorkbenchScreenHandler.this.contentsChangedListener.run();
                    WorkbenchScreenHandler.this.updateInput();
                    super.onTake(player, stack);
                }
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 98 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 156));
        }
        this.addDataSlot(this.selectedRecipe);
        if (ALL_RECIPES.isEmpty()) {
            this.world.getRecipeManager().getAllRecipesFor(RecipeTypes.FURNITURE_RECIPE).stream().map(RecipeHolder::value).forEach(recipe -> ALL_RECIPES.addAll(recipe.getInnerRecipes()));
            ALL_RECIPES.sort(FurnitureRecipe.CraftableFurnitureRecipe::compareTo);
        }
        this.updateInput();
        this.selectedRecipe.set(-1);
    }

    boolean craft() {
        FurnitureRecipe.FurnitureRecipeInput furnitureRecipeInput;
        FurnitureRecipe.CraftableFurnitureRecipe simpleFurnitureRecipe;
        if (!this.availableRecipes.isEmpty() && this.isInBounds(this.availableRecipes, this.selectedRecipe.get()) && (simpleFurnitureRecipe = this.sortedRecipes.get(this.selectedRecipe.get())).matches(furnitureRecipeInput = new FurnitureRecipe.FurnitureRecipeInput(this.playerInventory), this.playerInventory.player.level())) {
            simpleFurnitureRecipe.craftAndRemoveItems(furnitureRecipeInput, (HolderLookup.Provider)this.playerInventory.player.level().registryAccess());
            return true;
        }
        return false;
    }

    void populateResult(Player player) {
        if (!this.availableRecipes.isEmpty() && this.isInBounds(this.availableRecipes, this.selectedRecipe.get())) {
            FurnitureRecipe.CraftableFurnitureRecipe simpleFurnitureRecipe = this.sortedRecipes.get(this.selectedRecipe.get());
            this.outputSlot.setByPlayer(simpleFurnitureRecipe.craft(new FurnitureRecipe.FurnitureRecipeInput(player.getInventory()), (HolderLookup.Provider)player.level().registryAccess()));
        } else {
            this.outputSlot.setByPlayer(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public boolean isInBounds(List<FurnitureRecipe.CraftableFurnitureRecipe> simpleFurnitureRecipes, int id) {
        if (id >= simpleFurnitureRecipes.size() || id < 0) {
            return false;
        }
        return simpleFurnitureRecipes.contains(this.getSortedRecipes().get(id));
    }

    public void slotsChanged(Container inventory) {
        this.updateInput();
        super.slotsChanged(inventory);
    }

    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.get();
    }

    public List<FurnitureRecipe.CraftableFurnitureRecipe> getAvailableRecipes() {
        return this.availableRecipes;
    }

    public List<FurnitureRecipe.CraftableFurnitureRecipe> getSortedRecipes() {
        return this.sortedRecipes;
    }

    public List<FurnitureRecipe.CraftableFurnitureRecipe> getAllRecipes() {
        return ALL_RECIPES;
    }

    public int getAvailableRecipeCount() {
        return this.availableRecipes.size();
    }

    public int getTotalRecipeCount() {
        return this.sortedRecipes.size();
    }

    public int getVisibleRecipeCount() {
        return this.searching ? this.searchableRecipes.size() : this.getTotalRecipeCount();
    }

    public void updateInput() {
        FurnitureRecipe.FurnitureRecipeInput input = new FurnitureRecipe.FurnitureRecipeInput(this.playerInventory);
        if (!this.availableRecipes.isEmpty() && this.getSelectedRecipe() != -1 && !this.sortedRecipes.get(this.getSelectedRecipe()).matches(input, this.world)) {
            this.selectedRecipe.set(-1);
            this.outputSlot.setByPlayer(ItemStack.EMPTY);
        }
        this.availableRecipes.clear();
        this.availableRecipes.addAll(ALL_RECIPES.stream().filter(newFurnitureRecipe -> newFurnitureRecipe.matches(input, this.world)).toList());
        this.sortedRecipes.clear();
        this.sortedRecipes.addAll(this.availableRecipes);
        this.sortedRecipes.addAll(ALL_RECIPES.stream().filter(furnitureRecipe -> !this.sortedRecipes.contains(furnitureRecipe)).toList());
    }

    public boolean canCraft() {
        return !this.availableRecipes.isEmpty();
    }

    public void setContentsChangedListener(Runnable contentsChangedListener) {
        this.contentsChangedListener = contentsChangedListener;
    }

    public boolean stillValid(Player player) {
        return WorkbenchScreenHandler.stillValid((ContainerLevelAccess)this.context, (Player)player, (Block)PaladinFurnitureModBlocksItems.WORKING_TABLE);
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.outputSlot && super.canTakeItemForPickAll(stack, slot);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            Item item = itemStack2.getItem();
            itemStack = itemStack2.copy();
            if (index == 0) {
                item.onCraftedBy(itemStack2, player.level(), player);
                if (!this.moveItemStackTo(itemStack2, 1, 37, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemStack2, itemStack);
            } else if (index >= 1 && index < 28 ? !this.moveItemStackTo(itemStack2, 28, 37, false) : index >= 28 && index < 37 && !this.moveItemStackTo(itemStack2, 1, 28, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack2);
            this.broadcastChanges();
        }
        return itemStack;
    }

    public boolean clickMenuButton(Player player, int id) {
        this.updateInput();
        if (this.isInBounds(this.availableRecipes, id) && this.canCraft()) {
            this.selectedRecipe.set(id);
            this.populateResult(player);
            return true;
        }
        return false;
    }

    public List<FurnitureRecipe.CraftableFurnitureRecipe> getSearchableRecipes() {
        return this.searchableRecipes;
    }
}

